/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import java.util.StringTokenizer;

public abstract class UpgradableMetadataObject {
    public static final String SAS_VERSION_9_3 = "9.3";
    public static final String SAS_VERSION_9_4 = "9.4";
    public static final int SAS_MAJOR_9 = 9;
    public static final int SAS_MINOR_3 = 3;
    public static final int SAS_MINOR_4 = 4;
    public static final String SAS_VERSION = "9.4";
    public static final int SAS_MINOR = 4;
    public static final int VERSION_NEXT = 1;
    public static final int VERSION_SAME = 0;
    public static final int VERSION_PREVIOUS = -1;

    protected int checkVersionEquality(String oldVersion, String newVersion) {
        int equality = 0;
        if (oldVersion == null) {
            oldVersion = "";
        }
        if (newVersion == null) {
            newVersion = "";
        }
        try {
            StringTokenizer stOld = new StringTokenizer(oldVersion, ".");
            StringTokenizer stNew = new StringTokenizer(newVersion, ".");
            boolean isContinue = true;
            int i = 0;
            while (isContinue) {
                int iOld = 0;
                int iNew = 0;
                if (stOld.hasMoreElements()) {
                    String oldStr = stOld.nextToken();
                    iOld = new Integer(oldStr);
                } else {
                    isContinue = false;
                }
                if (stNew.hasMoreElements()) {
                    String oldNew = stNew.nextToken();
                    iNew = new Integer(oldNew);
                } else {
                    isContinue = false;
                }
                if (iNew > iOld) {
                    return 1;
                }
                if (iOld > iNew) {
                    return -1;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return equality;
    }

    protected abstract boolean isMetadataModelNeedToBeUpgradedTo93() throws MUUException;

    protected abstract boolean upgradeMetadataModelTo93() throws MUUException;

    protected abstract boolean isMetadataModelNeedToBeUpgradedTo94() throws MUUException;

    protected abstract boolean upgradeMetadataModelTo94() throws MUUException;
}

