/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.SMUProperties;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Properties;

public class MUU_Workspacpool
extends MUU_Object {
    public static final String m_strProductCode = "WORKSPACPOOL";
    public static final String m_strPublicName = "SAS Pooled Workspace";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><Properties/><ServiceTypes/><SoftwareTrees/><SourceConnections/><UsedByComponents/><UsingComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><TCPIPConnection><Properties/><Domain/><Source/><UsingPrototype/></TCPIPConnection><LogicalServer><InitProcesses/><Properties/><ServiceTypes/><UsedByComponents/><UsingPrototype/></LogicalServer><Transformation><Properties/></Transformation><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ProductName='SAS Pooled Workspace'\"/>";
    public static final String[] INIT_TERMINATE_PROG_SEARCH = new String[]{"WorkspaceInit", "WorkspaceTerm"};
    public static final String[] PROP_INIT_TERMINATE_PROG_ARRAY = new String[]{".request.init.program", ".request.term.program"};

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            this.doLocationChange();
            this.substituteValues(cmSrv);
            cmSrv.updateMetadataAll();
            this.m_store.updatedMetadataAll();
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    private void substituteValues(ServerComponent cmSrv) throws MUUException {
        try {
            AssociationList lstProps = cmSrv.getProperties();
            String strCommand = null;
            for (int iProp = 0; iProp < lstProps.size(); ++iProp) {
                String commandOption;
                Property objProp = (Property)lstProps.get(iProp);
                if (!"Command".equalsIgnoreCase(objProp.getPropertyName())) continue;
                String strTempdir = MUU_Workspacpool.getProperty("tempdir");
                SMUProperties smuProperties = SMUProperties.getSMUProperties(m_strProductCode, strTempdir);
                Properties properties = smuProperties.getServerPropertiesById(cmSrv.getId());
                properties.list(System.out);
                if (properties == null) continue;
                String strContextDirPath = properties.getProperty("config.lev.appservercontext.dir");
                String strSrvConfigDirName = properties.getProperty("iomsrv.workspacpool.config.dir.name");
                String strScriptFileName = MUU_Workspacpool.getProperty("scriptname");
                if (strContextDirPath == null || strSrvConfigDirName == null || strScriptFileName == null) continue;
                strCommand = strContextDirPath + File.separator + strSrvConfigDirName + File.separator + strScriptFileName;
                if ("Windows".equalsIgnoreCase(MUU_Object.getOS_Family())) {
                    strCommand = "\"" + strCommand + "\"";
                }
                if ((commandOption = MUU_Workspacpool.getCustomProperty("cmdoption")) != null && commandOption.trim().length() > 0) {
                    strCommand = strCommand + " " + commandOption;
                }
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Workspacpool.updating.command.log"));
                objProp.setDefaultValue(strCommand);
                objProp.updateMetadataAll();
                break;
            }
            if (strCommand == null) {
                MUU_Client.m_logger.error(MessageBundle.getString("MUU_Workspacpool.cmd.nt.created.log"));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        MUU_Client.m_logger.info("## calling updateInitTerminatePaths");
        this.updateInitTermProgPaths(cmSrv);
    }

    @Override
    protected boolean isMachineGroupAssociated() {
        return true;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        return false;
    }
}

