/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;

public class MUU_WorkSpaceSrv
extends MUU_Object {
    public static final String m_strProductCode = "WORKSPACESRV";
    public static final String m_strPublicName = "WorkSpace Server";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><Properties/><ServiceTypes/><SoftwareTrees/><SourceConnections/><UsedByComponents/><UsingComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><TCPIPConnection><Properties/><Domain/><Source/><UsingPrototype/></TCPIPConnection><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"></Property><LogicalServer><InitProcesses/><Properties/><ServiceTypes/><UsedByComponents/><UsingPrototype/></LogicalServer><Transformation><Properties/></Transformation><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ProductName='SAS Workspace'\"/>";
    public static final String[] INIT_TERMINATE_PROG_SEARCH = new String[]{"WorkspaceInit", "WorkspaceTerm"};
    public static final String[] PROP_INIT_TERMINATE_PROG_ARRAY = new String[]{".request.init.program", ".request.term.program"};
    private static final String CONFIG_FILE_NAME = "WorkspaceServer";
    private static final String PROP_ALLOW_RECONNECT = "AllowReconnect";

    MUU_WorkSpaceSrv() {
    }

    protected void AddAssociations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            String strReposId = this.getReposID();
            super.MoveSCMachine(strReposId, cmSrv);
            String strName = null;
            this.addAllowReconnect(cmSrv, "False");
            AssociationList alLogicalServers = cmSrv.getUsedByComponents();
            if (alLogicalServers.size() > 0) {
                LogicalServer cmLogSrv = (LogicalServer)alLogicalServers.get(0);
                AssociationList alLogSrvProps = cmLogSrv.getProperties();
                strName = "LogicalServer.Security.Property.SACS.Name.xmlKey.txt";
                Property propEnableSACS = this.CreateProperty(strReposId, strName, "EnableSACS", "True", "12");
                strName = "LogicalServer.Security.Property.AuthService.Name.xmlKey.txt";
                Property propAuthService = this.CreateProperty(strReposId, strName, "AuthService", "Host", "12");
                alLogSrvProps.addElement((Object)propEnableSACS);
                alLogSrvProps.addElement((Object)propAuthService);
                cmLogSrv.updateMetadataAll();
                AssociationList alTransforms = cmLogSrv.getInitProcesses();
                if (alTransforms.size() > 0) {
                    Transformation cmTransform = (Transformation)alTransforms.get(0);
                    Property propTimeout = this.CreateProperty(strReposId, "LBClusterTimeout", "LBClusterTimeout", "60000", "4");
                    AssociationList alTransProps = cmTransform.getProperties();
                    alTransProps.addElement((Object)propTimeout);
                    cmTransform.setProperties(alTransProps);
                    cmTransform.updateMetadataAll();
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    void SubstituteValues(ServerComponent cmSrv) throws MUUException {
        try {
            AssociationList lstProps = cmSrv.getProperties();
            for (int iProp = 0; iProp < lstProps.size(); ++iProp) {
                Property objProp = (Property)lstProps.get(iProp);
                if ("Command".equalsIgnoreCase(objProp.getPropertyName())) {
                    String strTempDir = MUU_Object.getProperty("tempdir");
                    File dirTemp = new File(strTempDir);
                    if (dirTemp.exists()) {
                        String[] arrServers = dirTemp.list();
                        for (int iSrv = 0; iSrv < arrServers.length; ++iSrv) {
                            String strFileName = arrServers[iSrv];
                            if (strFileName.indexOf("workspacesrv") != 0 || strFileName.indexOf("_Configuration.properties") == -1) continue;
                            Properties propServer = new Properties();
                            try {
                                String commandOption;
                                String strFileSep = System.getProperty("file.separator");
                                strFileName = strTempDir + strFileSep + strFileName;
                                propServer.load(new FileInputStream(strFileName));
                                String strSrvName = propServer.getProperty("iomsrv.workspacesrv.name");
                                String strSrvDirName = propServer.getProperty("iomsrv.workspacesrv.config.dir.name");
                                if (!strSrvName.equalsIgnoreCase(cmSrv.getName())) continue;
                                String strCommand = propServer.getProperty("config.lev.appservercontext.dir");
                                strCommand = strCommand + strFileSep;
                                strCommand = strCommand + strSrvDirName;
                                String executableFile = null;
                                File scriptDirectory = new File(strCommand);
                                if (scriptDirectory.exists() && scriptDirectory.isDirectory()) {
                                    executableFile = MetaDataHelper.getConfigFileName(scriptDirectory.getAbsolutePath(), CONFIG_FILE_NAME);
                                }
                                strCommand = executableFile;
                                if ("Windows".equalsIgnoreCase(MUU_Object.getOS_Family())) {
                                    strCommand = "\"" + strCommand + "\"";
                                }
                                if ((commandOption = MUU_WorkSpaceSrv.getCustomProperty("cmdoption")) != null && commandOption.trim().length() > 0) {
                                    strCommand = strCommand + " " + commandOption;
                                }
                                objProp.setDefaultValue(strCommand);
                                break;
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace(System.err);
                                throw new MUUException(e);
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                                throw new MUUException(e);
                            }
                        }
                    } else {
                        MUU_Client.m_logger.error(MessageBundle.getString("MUU_WorkSpaceSrv.tmpdir.nt.found.log"));
                    }
                    objProp.updateMetadataAll();
                    break;
                }
                if (iProp < lstProps.size()) continue;
                MUU_Client.m_logger.error(MessageBundle.getString("MUU_WorkSpaceSrv.cmd.nt.found.log"));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        MUU_Client.m_logger.info("## calling updateInitTerminatePaths");
        this.updateInitTermProgPaths(cmSrv);
        this.substituteReconnect(cmSrv);
    }

    private void substituteReconnect(ServerComponent server) throws MUUException {
        Property reconnect = MetaDataHelper.getProperty(server, PROP_ALLOW_RECONNECT);
        try {
            if (reconnect != null) {
                reconnect.setDefaultValue("True");
            } else {
                this.addAllowReconnect(server, "True");
            }
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        catch (MdException exception) {
            throw new MUUException(exception);
        }
    }

    private void addAllowReconnect(ServerComponent server, String value) throws RemoteException, MdException, MUUException {
        String strName = "Server.Property.AllowReconnect.Name.xmlKey.txt";
        Property propAllowConnect = this.CreateProperty(this.getReposID(), strName, PROP_ALLOW_RECONNECT, value, "12");
        AssociationList alProps = server.getProperties();
        if (alProps == null) {
            alProps = new AssociationList("Properties");
            server.setProperties(alProps);
        }
        alProps.addElement((Object)propAllowConnect);
    }

    protected void DeleteAssociations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            super.setSQLType(cmSrv);
            super.DeleteCOMConnections(cmSrv);
            AssociationList alProps = cmSrv.getProperties();
            for (int iProp = alProps.size() - 1; iProp >= 0; --iProp) {
                Property objProp = (Property)alProps.get(iProp);
                String strPropName = objProp.getPropertyName();
                if (!strPropName.equalsIgnoreCase("LBStartSize")) continue;
                objProp.delete();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    protected boolean isMachineGroupAssociated() {
        return true;
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            this.doLocationChange();
            this.SubstituteValues(cmSrv);
            cmSrv.updateMetadataAll();
            this.m_store.updatedMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        try {
            this.DeleteAssociations();
            this.AddAssociations();
            this.m_objMetadata.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }
}

