/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.RootImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public class MUU_StorProcSrv
extends MUU_Object {
    public static final String m_strProductCode = "STORPROCSRV";
    public static final String m_strPublicName = "Stored Process Server";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><Properties/><ServiceTypes/><SoftwareTrees/><SourceConnections/><UsedByComponents/><UsingComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><LogicalServer><InitProcesses/><Properties/><ServiceTypes/><UsedByComponents/><UsingPrototype/></LogicalServer><Transformation><Properties/></Transformation><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ProductName='SAS Stored Process'\"/>";
    private static final String CONFIG_FILE_NAME = "StoredProcessServer";

    MUU_StorProcSrv() {
    }

    protected void AddAssociations() throws MUUException {
        try {
            AssociationList alLogicalServers;
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            String strReposId = this.getReposID();
            super.MoveSCMachine(strReposId, cmSrv);
            String strType = "Person";
            String strOptions = "<XMLSelect Search=\"@Name='sastrust'\"/>";
            List lstPeople = this.getObjectList(strReposId, strType, 128, strOptions);
            if (lstPeople.size() > 0) {
                RootImpl rUser = (RootImpl)lstPeople.get(0);
                String strInputXML = "<Person Id=\"" + rUser.getId() + "\"/>";
                String strTemplate = "<Templates><Person><IdentityGroups/></Person></Templates>";
                Person objUser = (Person)this.getMdObject(strInputXML, strTemplate);
                strType = "IdentityGroup";
                strOptions = "<XMLSelect Search=\"@Name='SAS General Servers'\"/>";
                List lstGroups = this.getObjectList(strReposId, strType, 128, strOptions);
                if (lstGroups.size() > 0) {
                    RootImpl serverGroup = (RootImpl)lstGroups.get(0);
                    strInputXML = "<IdentityGroup Id=\"" + serverGroup.getId() + "\"/>";
                    strTemplate = "<Templates><IdentityGroup><MemberIdentities/></IdentityGroup></Templates>";
                    IdentityGroup objGroup = (IdentityGroup)this.getMdObject(strInputXML, strTemplate);
                    AssociationList alMembers = objGroup.getMemberIdentities();
                    alMembers.add((Object)objUser);
                    objGroup.updateMetadataAll();
                    objUser.updateMetadataAll();
                }
            }
            if ((alLogicalServers = cmSrv.getUsedByComponents()).size() > 0) {
                LogicalServer cmLogSrv = (LogicalServer)alLogicalServers.get(0);
                AssociationList alLogSrvProps = cmLogSrv.getProperties();
                String strName = "LogicalServer.STP.Property.ContextCost.Name.xmlKey.txt";
                Property propContextCost = this.CreateProperty(strReposId, strName, "Context Cost", "100", "4");
                alLogSrvProps.addElement((Object)propContextCost);
                strName = "LogicalServer.STP.Property.ContextClose.Name.xmlKey.txt";
                Property propContextClose = this.CreateProperty(strReposId, strName, "Context Close Timeout", "900", "4");
                alLogSrvProps.addElement((Object)propContextClose);
                strName = "LogicalServer.STP.Property.ContextExecute.Name.xmlKey.txt";
                Property propContextExecute = this.CreateProperty(strReposId, strName, "Context Execute Timeout", "300", "4");
                alLogSrvProps.addElement((Object)propContextExecute);
                strName = "LogicalServer.STP.Property.SessionCost.Name.xmlKey.txt";
                Property propSessionCost = this.CreateProperty(strReposId, strName, "Session Cost", "1", "4");
                alLogSrvProps.addElement((Object)propSessionCost);
                strName = "LogicalServer.STP.Property.DefaultTimeout.Name.xmlKey.txt";
                Property propDefaultTimeout = this.CreateProperty(strReposId, strName, "Default Session Timeout", "900", "4");
                alLogSrvProps.addElement((Object)propDefaultTimeout);
                strName = "LogicalServer.STP.Property.MaxTimeout.Name.xmlKey.txt";
                Property propMaxTimeout = this.CreateProperty(strReposId, strName, "Maximum Session Timeout", "3600", "4");
                alLogSrvProps.addElement((Object)propMaxTimeout);
                strName = "LogicalServer.Security.Property.SACS.Name.xmlKey.txt";
                Property propSACS = this.CreateProperty(strReposId, strName, "EnableSACS", "True", "12");
                alLogSrvProps.addElement((Object)propSACS);
                strName = "LogicalServer.Security.Property.AuthService.Name.xmlKey.txt";
                Property propAuthService = this.CreateProperty(strReposId, strName, "AuthService", "Metadata", "12");
                alLogSrvProps.addElement((Object)propAuthService);
                cmLogSrv.updateMetadataAll();
                AssociationList alTransforms = cmLogSrv.getInitProcesses();
                if (alTransforms.size() > 0) {
                    Transformation cmTransform = (Transformation)alTransforms.get(0);
                    AssociationList alTransProps = cmTransform.getProperties();
                    strName = "LB.Property.AvailabilityTimeout.Name.xmlKey.txt";
                    Property propTimeout = this.CreateProperty(strReposId, strName, "LBClusterTimeout", "60000", "4");
                    alTransProps.addElement((Object)propTimeout);
                    strName = "LB.Property.MultibridgeRequired.Name.xmlKey.txt";
                    Property propMultibridgeRequired = this.CreateProperty(strReposId, strName, "MultibridgeRequired", "True", "12");
                    alTransProps.addElement((Object)propMultibridgeRequired);
                    cmTransform.setProperties(alTransProps);
                    cmTransform.updateMetadataAll();
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    void SubstituteValues(ServerComponent cmSrv) throws MUUException {
        try {
            AssociationList lstProps = cmSrv.getProperties();
            for (int iProp = 0; iProp < lstProps.size(); ++iProp) {
                Property objProp = (Property)lstProps.get(iProp);
                if ("Command".equalsIgnoreCase(objProp.getPropertyName())) {
                    String strTempdir = MUU_Object.getProperty("tempdir");
                    File dirTemp = new File(strTempdir);
                    if (dirTemp.exists()) {
                        String[] arrServers = dirTemp.list();
                        for (int iSrv = 0; iSrv < arrServers.length; ++iSrv) {
                            String strFileName = arrServers[iSrv];
                            if (strFileName.indexOf("storprocsrv") != 0 || strFileName.indexOf("_Configuration.properties") == -1) continue;
                            Properties propServer = new Properties();
                            try {
                                String commandOption;
                                String strFileSep = System.getProperty("file.separator");
                                strFileName = strTempdir + strFileSep + strFileName;
                                propServer.load(new FileInputStream(strFileName));
                                String strSrvName = propServer.getProperty("iomsrv.storprocsrv.name");
                                String strSrvDirName = propServer.getProperty("iomsrv.storprocsrv.config.dir.name");
                                if (!strSrvName.equalsIgnoreCase(cmSrv.getName())) continue;
                                String strCommand = propServer.getProperty("config.lev.appservercontext.dir");
                                strCommand = strCommand + strFileSep;
                                strCommand = strCommand + strSrvDirName;
                                String executableFile = null;
                                File scriptDirectory = new File(strCommand);
                                if (scriptDirectory.exists() && scriptDirectory.isDirectory()) {
                                    executableFile = MetaDataHelper.getConfigFileName(scriptDirectory.getAbsolutePath(), CONFIG_FILE_NAME);
                                }
                                strCommand = executableFile;
                                if ("Windows".equalsIgnoreCase(MUU_Object.getOS_Family())) {
                                    strCommand = "\"" + strCommand + "\"";
                                }
                                if ((commandOption = MUU_StorProcSrv.getCustomProperty("cmdoption")) != null && commandOption.trim().length() > 0) {
                                    strCommand = strCommand + " " + commandOption;
                                }
                                objProp.setDefaultValue(strCommand);
                                break;
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace(System.err);
                                throw new MUUException(e);
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                                throw new MUUException(e);
                            }
                        }
                    } else {
                        MUU_Client.m_logger.error(MessageBundle.getString("MUU_StorProcSrv.tmpdir.nt.found.log"));
                    }
                    objProp.updateMetadataAll();
                    break;
                }
                if (iProp < lstProps.size()) continue;
                MUU_Client.m_logger.error(MessageBundle.getString("MUU_StorProcSrv.cmd.nt.found.log"));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        MUU_Client.m_logger.info("Calling updateInitTerminatePaths");
        this.updateInitTermProgPaths(cmSrv);
    }

    protected void DeleteAssociations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            super.setSQLType(cmSrv);
            super.DeleteCOMConnections(cmSrv);
            AssociationList alProps = cmSrv.getProperties();
            for (int iProp = alProps.size() - 1; iProp >= 0; --iProp) {
                Property objProp = (Property)alProps.get(iProp);
                String strPropName = objProp.getPropertyName();
                if (strPropName.equalsIgnoreCase("RecycleActivationLimit")) {
                    objProp.delete();
                    continue;
                }
                if (strPropName.equalsIgnoreCase("MaxClients")) {
                    objProp.delete();
                    continue;
                }
                if (!strPropName.equalsIgnoreCase("ServerShutdownAfter")) continue;
                objProp.delete();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected List getObjectList(String strReposId, String strType, int iFlags, String strOptions) throws MUUException {
        try {
            List lstObjects = this.m_omiUtil.getMetadataObjects(strReposId, strType, iFlags, strOptions);
            return lstObjects;
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected Object getMdObject(String strInputXML, String strTemplate) throws MUUException {
        try {
            int iFlags = 268;
            List lstObjects = this.m_omiUtil.getMetadataObjects((MdStore)this.m_store, strInputXML, strTemplate, iFlags);
            if (lstObjects.size() > 0) {
                return lstObjects.get(0);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return null;
    }

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    protected boolean isMachineGroupAssociated() {
        return true;
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            this.doLocationChange();
            this.SubstituteValues(cmSrv);
            cmSrv.updateMetadataAll();
            this.m_store.updatedMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        try {
            this.DeleteAssociations();
            this.AddAssociations();
            this.m_objMetadata.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }
}

