/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.muu.SMUProperties;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MUU_Spawner
extends MUU_Object {
    public static final String m_strProductCode = "OBJECTSPAWNR";
    public static final String m_strPublicName = "Object Spawner";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><SoftwareTrees/><Properties/><ServiceTypes/><SourceConnections/><UsedByComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><TCPIPConnection><Properties/><Domain/><Source/><UsingPrototype/></TCPIPConnection><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ClassIdentifier='IOM Spawner'\"/>";
    public static final String PORTBANK_PROP_PREFIX = "portbank.port";
    public static final int MAX_PORTBANK_CONNECTIONS = 3;
    public static final String PORTBANK_CONN_NAME_PREFIX = "Spawner_portbank_";
    public static final String PLAN_SELECTED_CONFIG_LIST = "plan.selected.config.list";
    static Map<String, String> classIdentifiers = new HashMap<String, String>();

    protected void AddAssociations() throws MUUException {
        ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
        String strReposId = this.getReposID();
        try {
            super.MoveSCMachine(strReposId, cmSrv);
            AssociationList alTrans = cmSrv.getInitProcesses();
            if (alTrans.size() > 0) {
                Transformation trInitialization = (Transformation)alTrans.get(0);
                AssociationList alProps = trInitialization.getProperties();
                Property objProp = this.CreateProperty(strReposId, "Disable telnet access", "DisableTelnet", "True", "12");
                alProps.addElement((Object)objProp);
            }
            this.addPortBanks(cmSrv, strReposId);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    public boolean addPortBanks(ServerComponent server, String reposId) throws MUUException {
        boolean isUpdated = false;
        try {
            MUU_Client.m_logger.debug("Adding port banks");
            AssociationList sourceConnections = server.getSourceConnections();
            if (sourceConnections != null) {
                String hostName = this.getChangedHostName(server);
                String portProperty = PORTBANK_PROP_PREFIX;
                String connectionName = PORTBANK_CONN_NAME_PREFIX;
                String portValue = null;
                TCPIPConnection portBank = null;
                int port = 0;
                for (int index = 1; index < 4; ++index) {
                    portValue = MUU_Spawner.getCustomProperty(portProperty + index);
                    connectionName = PORTBANK_CONN_NAME_PREFIX + index;
                    if (portValue != null) {
                        port = Integer.parseInt(portValue.trim());
                        portBank = this.createPortBankConnection(hostName, port, connectionName, reposId);
                        sourceConnections.add((Object)portBank);
                        isUpdated = true;
                        continue;
                    }
                    MUU_Client.m_logger.warn("No port value defined for the port bank " + connectionName);
                }
            }
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        catch (MdException exception) {
            throw new MUUException(exception);
        }
        return isUpdated;
    }

    protected void DeleteAssociations() throws MUUException {
        ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
        super.setSQLType(cmSrv);
        super.DeleteCOMConnections(cmSrv);
        this.RemoveLoadBalancingConnections();
        try {
            AssociationList alTrans = cmSrv.getInitProcesses();
            if (alTrans.size() > 0) {
                Transformation trInitialization = (Transformation)alTrans.get(0);
                AssociationList alProps = trInitialization.getProperties();
                for (int iProp = alProps.size() - 1; iProp >= 0; --iProp) {
                    Property objProp = (Property)alProps.get(iProp);
                    if (!"LogFile".equalsIgnoreCase(objProp.getPropertyName()) && !"Verbose".equalsIgnoreCase(objProp.getPropertyName())) continue;
                    objProp.delete();
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected void RemoveLoadBalancingConnections() throws MUUException {
        ServerComponent _ServerSpawner = (ServerComponent)this.m_objMetadata;
        try {
            AssociationList lstConnection = _ServerSpawner.getSourceConnections();
            if (lstConnection.size() > 0) {
                for (int i = lstConnection.size() - 1; i >= 0; --i) {
                    TCPIPConnection objConnection = (TCPIPConnection)lstConnection.get(i);
                    String strConnectiontype = objConnection.getApplicationProtocol();
                    if (!strConnectiontype.equalsIgnoreCase("LoadBalance")) continue;
                    objConnection.delete();
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    protected boolean isMachineGroupAssociated() {
        return true;
    }

    private boolean updateLogins() throws MUUException {
        boolean isMetaUpdated;
        block14: {
            isMetaUpdated = false;
            Login login = null;
            try {
                Set FQIDs = MUU_Spawner.getFQIDsOfChangedLogins();
                if (FQIDs != null) {
                    Object[] allIDs = FQIDs.toArray();
                    for (int i = 0; i < allIDs.length; ++i) {
                        String newPswd;
                        String fqid;
                        if (!(allIDs[i] instanceof String) || (login = this.getLoginObject(fqid = (String)allIDs[i])) == null) continue;
                        boolean isUpdated = false;
                        String newUserID = this.getChangedUserName(login);
                        if (newUserID != null) {
                            Object[] objs;
                            if (!login.getUserID().equals(newUserID)) {
                                objs = new Object[]{login.getName(), login.getUserID(), newUserID};
                                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Spawner.updating.user.name.fmt.log", objs));
                                login.setUserID(newUserID);
                                isUpdated = true;
                            } else {
                                objs = new Object[]{login.getUserID(), login.getName()};
                                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Spawner.need.not.update.user.name.fmt.log", objs));
                            }
                            this.removeChangedUserProperty(login);
                        }
                        if ((newPswd = this.getChangedUserPswd(login)) != null) {
                            Object[] objs = new Object[]{login.getName()};
                            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Spawner.updating.user.pswd.fmt.log", objs));
                            login.setPassword(newPswd);
                            isUpdated = true;
                            this.removeChangedPswdProperty(login);
                        }
                        if (!isUpdated) continue;
                        login.updateMetadataAll();
                        isMetaUpdated = true;
                    }
                }
            }
            catch (RemoteException e) {
                MUU_Client.setReturnCode(8);
                e.printStackTrace(System.err);
                if (login != null) {
                    try {
                        login.clearChangeList();
                    }
                    catch (RemoteException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (MdException e) {
                MUU_Client.setReturnCode(8);
                e.printStackTrace(System.err);
                if (login == null) break block14;
                try {
                    login.clearChangeList();
                }
                catch (RemoteException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return isMetaUpdated;
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            this.doLocationChange();
            ServerComponent server = (ServerComponent)this.m_objMetadata;
            this.updateServerName(server, MUU_Spawner.getProperty("productcode").toLowerCase());
            this.changeConnectionName(server);
            this.updateLogins();
            this.removeOrphanedServerAssociation(server);
            this.m_objMetadata.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    private void removeOrphanedServerAssociation(ServerComponent sc) throws MUUException {
        String planConfigList = PLAN_SELECTED_CONFIG_LIST;
        String planSelectedConfigList = MUU_Spawner.getCustomProperty(planConfigList);
        SMUProperties smuProperties = null;
        String tempFolderPath = MUU_Spawner.getProperty("tempdir");
        String productCode = MUU_Spawner.getProperty("productcode");
        smuProperties = SMUProperties.getSMUProperties(productCode, tempFolderPath);
        String oldHost = null;
        try {
            oldHost = smuProperties.getServerProperty(sc.getId(), "server.host.prior");
            String[] planLst = planSelectedConfigList.split("\\s");
            AssociationList spawnedServers = sc.getUsedByComponents();
            AssociationList dependentComponent = sc.getDependentComponents();
            ArrayList<ServerComponent> serversToRemove = new ArrayList<ServerComponent>(spawnedServers.size());
            MUU_Client.m_logger.info("Spawner Name: " + sc.getName());
            if (spawnedServers != null || spawnedServers.size() > 0) {
                System.out.println("spawnedServers.size(): " + spawnedServers.size());
                for (int i = 0; i < spawnedServers.size(); ++i) {
                    ServerComponent server;
                    if (!(spawnedServers.get(i) instanceof ServerComponent) || !classIdentifiers.containsKey((server = (ServerComponent)spawnedServers.get(i)).getClassIdentifier())) continue;
                    String prodCode = classIdentifiers.get(server.getClassIdentifier());
                    MUU_Client.m_logger.info("Checking for " + server.getName() + ", classID: " + server.getClassIdentifier() + ", prodCode: " + prodCode);
                    Boolean found = false;
                    for (int j = 0; j < planLst.length; ++j) {
                        String prod = planLst[j];
                        if (!prod.equalsIgnoreCase(prodCode)) continue;
                        MUU_Client.m_logger.info("Found " + prodCode + " in plan file.");
                        found = true;
                        break;
                    }
                    if (found.booleanValue()) continue;
                    serversToRemove.add(server);
                }
            }
            for (ServerComponent server : serversToRemove) {
                boolean result = false;
                AssociationList logicalServers = server.getUsedByComponents();
                ServerComponent component = null;
                LogicalServer logicalServer = null;
                Object softwareTrees = null;
                if (logicalServers != null && logicalServers.size() > 0) {
                    for (int index = 0; index < logicalServers.size(); ++index) {
                        component = (ServerComponent)logicalServers.get(index);
                        if (!(component instanceof LogicalServer)) continue;
                        logicalServer = (LogicalServer)component;
                    }
                }
                AssociationList allSoftwareTrees = server.getSoftwareTrees();
                Tree treeMachineGroup = null;
                Machine oldMachine = null;
                if (allSoftwareTrees != null) {
                    for (int i = 0; i < allSoftwareTrees.size(); ++i) {
                        Tree obj = (Tree)allSoftwareTrees.get(i);
                        if (!obj.getTreeType().equalsIgnoreCase("MachineGroup")) continue;
                        treeMachineGroup = obj;
                        break;
                    }
                    if (treeMachineGroup != null) {
                        AssociationList alMembers = treeMachineGroup.getMembers();
                        if (alMembers.size() > 1) {
                            MUU_Client.m_logger.info("Remove association of spawner in case of more then one associated m/c");
                            for (int iMac = 0; iMac < alMembers.size(); ++iMac) {
                                String oldMachineName;
                                CMetadata objMac = (CMetadata)alMembers.get(iMac);
                                if (!(objMac instanceof Machine) || !MetaDataHelper.isHostsEqual(oldMachineName = (oldMachine = (Machine)objMac).getName(), oldHost)) continue;
                                alMembers.remove((Object)oldMachine);
                                MUU_Client.m_logger.info("Old machine removed which is : " + oldMachineName + "for server :" + server.getName());
                            }
                            MUU_Client.m_logger.info("Now machine associated :" + alMembers.toString());
                            treeMachineGroup.setMembers(alMembers);
                            treeMachineGroup.updateMetadataAll();
                            this.m_store.updatedMetadataAll();
                        } else if (alMembers.size() >= 0) {
                            MUU_Client.m_logger.info("Remove association of spawner in case of one associated m/c");
                            spawnedServers.remove((Object)server);
                            dependentComponent.remove((Object)logicalServer);
                            MUU_Client.m_logger.info("Association removed for server :" + server.getName());
                        }
                    }
                }
                sc.setUsedByComponents(spawnedServers);
                sc.setDependentComponents(dependentComponent);
                this.m_store.updatedMetadataAll();
            }
        }
        catch (RemoteException e) {
            throw new MUUException(e);
        }
        catch (MdException e) {
            throw new MUUException(e);
        }
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        try {
            this.DeleteAssociations();
            this.AddAssociations();
            this.m_objMetadata.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    static {
        classIdentifiers.put("f3f46472-1e31-11d5-87c2-00c04f38f9f6", "OLAPCUBESRV");
        classIdentifiers.put("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8", "DSBATCHSRV");
        classIdentifiers.put("440196D4-90F0-11D0-9F41-00A024BB830C", "WORKSPACESRV");
        classIdentifiers.put("620963ee-32bf-4128-bf5f-4b0df8ff90eb", "WORKSPACPOOL");
        classIdentifiers.put("15931E31-667F-11D5-8804-00C04F35AC8C", "STORPROCSRV");
        classIdentifiers.put("028e4060-d545-11d5-880d-aa0004006d06", "CONNECTSRV");
        classIdentifiers.put("b379c9c1-89e0-4e72-ba43-6a416899b5dd", "OSSRVSCHED");
    }
}

