/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.muu.SMUProperties;
import com.sas.metadata.muu.UpgradableMetadataObject;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prompt;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.RootImpl;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MUU_Object
extends UpgradableMetadataObject {
    public static final String CONF_PROPFILE_SUFFIX = "_Configuration.properties";
    IOMI m_con = null;
    MdObjectStore m_store = null;
    MdOMIUtil m_omiUtil = null;
    MdFactory m_mdFactory = null;
    RootImpl m_objMetadata = null;
    protected String m_reposID = null;
    private static HashMap m_hmPrperties = new HashMap();
    public static final String[] PROP_INIT_TERMINATE_PROG_ARRAY = new String[]{".session.init.program", ".session.term.program", ".request.init.program", ".request.term.program"};
    public static final String PROP_CMD_OPTION = "cmdoption";
    public static final String CUSTOM_PROP_ENCRYPTION_ALGO = "encryption.algorithms.name";
    public static final String CUSTOM_PROP_ENCRYPTION_LEVEL = "req.encryption.level";
    public static final String META_PROP_ENCRYPTION_ALGO = "ServerEncryptionAlgorithms";
    public static final String META_PROP_ENCRYPTION_LEVEL = "RequiredEncryptionLevel";
    public static final int OS_UNDEFINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_OPENVMS = 6;
    public static final int OS_ALX = 7;
    public static final int OS_MVS = 8;
    public static final int OS_MAC = 9;
    public static final int OS_ZOS = 10;
    public static final String OS_FAMILY_UNDEFINED = "Undefined";
    public static final String OS_FAMILY_UNIX = "Unix";
    public static final String OS_FAMILY_WINDOWS = "Windows";
    public static final String OS_FAMILY_MAC = "Macintosh";
    public static final String OS_FAMILY_MVS = "MVS";
    public static final String OS_FAMILY_ZOS = "ZOS";
    public static final String OS_FAMILY_VMS = "VMS";

    MUU_Object() {
    }

    MUU_Object(IOMI con, MdFactoryImpl mdFactory, WAdminResource bundle) throws MUUException {
        try {
            this.m_mdFactory = mdFactory;
            MdOMRConnection omrConnection = mdFactory.getConnection();
            omrConnection.setCMRHandle(con);
            this.m_omiUtil = mdFactory.getOMIUtil();
            this.m_store = mdFactory.createObjectStore();
        }
        catch (RemoteException e) {
            MUU_Client.m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (Exception e) {
            MUU_Client.m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    public void setMetadata(RootImpl obj) {
        if (this.m_objMetadata == null) {
            this.m_objMetadata = obj;
        }
    }

    public void init(IOMI con, MdFactory mdFactory, MdObjectStore store) throws MUUException {
        try {
            this.m_mdFactory = mdFactory;
            MdOMRConnection omrConnection = mdFactory.getConnection();
            omrConnection.setCMRHandle(con);
            this.m_omiUtil = mdFactory.getOMIUtil();
            this.m_store = store;
        }
        catch (RemoteException e) {
            MUU_Client.m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (Exception e) {
            MUU_Client.m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected Prompt CreatePrompt(String strReposId, String strPromptName, String strPublicType, String strPromptInfo, int strPromptType) throws MUUException {
        Prompt obj = null;
        try {
            if (strReposId.indexOf(".") != -1) {
                strReposId = strReposId.substring(strReposId.indexOf(".") + 1);
            }
            obj = (Prompt)this.m_mdFactory.createComplexMetadataObject(this.m_store, strPromptName, "Prompt", strReposId);
            obj.setName(strPromptName);
            obj.setPublicType(strPublicType);
            obj.setPromptInfo(strPromptInfo);
            obj.setPromptType(strPromptType);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return obj;
    }

    protected Tree CreateTree(String strReposId, String strTreeName, String strTreeType) throws MUUException {
        Tree obj = null;
        try {
            if (strReposId.indexOf(".") != -1) {
                strReposId = strReposId.substring(strReposId.indexOf(".") + 1);
            }
            obj = (Tree)this.m_mdFactory.createComplexMetadataObject(this.m_store, strTreeName, "Tree", strReposId);
            obj.setName(strTreeName);
            obj.setTreeType(strTreeType);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return obj;
    }

    protected TCPIPConnection createPortBankConnection(String hostName, int portNumber, String name, String reposId) throws MUUException {
        TCPIPConnection portBankConnection = null;
        try {
            if (reposId.indexOf(".") != -1) {
                reposId = reposId.substring(reposId.indexOf(".") + 1);
            }
            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.creating.portbank.connection.fmt.log", new String[]{hostName, Integer.toString(portNumber)}));
            portBankConnection = (TCPIPConnection)this.m_mdFactory.createComplexMetadataObject(this.m_store, name, "TCPIPConnection", reposId);
            if (portBankConnection != null) {
                portBankConnection.setHostName(hostName);
                portBankConnection.setPort(portNumber);
                portBankConnection.setApplicationProtocol("PortBank");
                portBankConnection.setCommunicationProtocol("TCP");
            }
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        return portBankConnection;
    }

    protected Machine locateMachine(String hostName) throws MUUException {
        try {
            String reposID = this.getReposID();
            String strCMTemplate = "<Templates><Machine></Machine></Templates>";
            int flags = 2316;
            List mdObjects = this.getMetadataObjectsSubset(reposID, "Machine", flags, strCMTemplate);
            if (mdObjects != null) {
                for (int i = 0; i < mdObjects.size(); ++i) {
                    Machine mac = (Machine)mdObjects.get(i);
                    String machineName = mac.getName();
                    if (!MetaDataHelper.isHostsEqual(hostName, machineName)) continue;
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.found.fmt.log", new Object[]{hostName}));
                    return mac;
                }
            }
            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machien.not.found.fmt.log", new Object[]{hostName}));
            return this.createNewMachine(hostName, reposID);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    public Machine getMachineObject(String fqid) throws MUUException {
        Machine machine = null;
        try {
            String strCMTemplate = "<Templates><Machine><DeployedComponents></DeployedComponents><Trees><MachineGroup><SoftwareComponents></SoftwareComponents></MachineGroup></Trees></Machine></Templates>";
            int flags = 2316;
            CMetadata cmeta = this.getMetadataAllDepths("Machine", fqid, strCMTemplate, flags);
            if (cmeta instanceof Machine) {
                machine = (Machine)cmeta;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return machine;
    }

    protected Machine createNewMachine(String hostName, String reposID) throws MUUException {
        Machine machine = null;
        try {
            List machList;
            MdObjectStore store = this.m_store;
            String reposIDLast8 = reposID;
            if (reposIDLast8 != null && reposIDLast8.indexOf(".") != -1) {
                reposIDLast8 = reposIDLast8.substring(reposIDLast8.indexOf(".") + 1);
            }
            machine = (Machine)this.m_mdFactory.createComplexMetadataObject(store, hostName, "Machine", reposIDLast8);
            machine.setName(hostName);
            machine.updateMetadataAll();
            String reposID8Dot8 = reposID;
            if (reposID8Dot8 != null && reposID8Dot8.indexOf(".") == -1) {
                reposID8Dot8 = "A0000001." + reposID8Dot8;
            }
            if ((machList = this.m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, reposID8Dot8, "Machine", 128, "<XMLSELECT search=\"*[@Name='" + hostName + "']\" />")).size() != 0) {
                machine = (Machine)machList.get(0);
                return machine;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return null;
    }

    protected Machine CreateMachine(String strReposId, String strMachineName) throws MUUException {
        Machine obj = null;
        try {
            if (strReposId.indexOf(".") != -1) {
                strReposId = strReposId.substring(strReposId.indexOf(".") + 1);
            }
            obj = (Machine)this.m_mdFactory.createComplexMetadataObject(this.m_store, strMachineName, "Machine", strReposId);
            obj.setName(strMachineName);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return obj;
    }

    protected String getReposID() throws MUUException {
        try {
            if (this.m_reposID == null) {
                this.m_reposID = this.m_objMetadata.getRepositoryID();
            }
            if (this.m_reposID == null) {
                throw new MUUException("Repository ID cannot be null!");
            }
            if (this.m_reposID.indexOf(".") == -1) {
                return "A0000001." + this.m_reposID;
            }
            return this.m_reposID;
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected Property CreateProperty(String strReposId, String strName, String strPropertyName, String strDefaultValue, String strSQLType) throws MUUException {
        Property obj = null;
        try {
            if (strReposId.indexOf(".") != -1) {
                strReposId = strReposId.substring(strReposId.indexOf(".") + 1);
            }
            obj = (Property)this.m_mdFactory.createComplexMetadataObject(this.m_store, strName, "Property", strReposId);
            obj.setPropertyName(strPropertyName);
            obj.setDefaultValue(strDefaultValue);
            obj.setSQLType(strSQLType);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return obj;
    }

    protected Directory CreateDirectory(String strReposId, String strName, String strDirectoryName, int nIsRelative) throws MUUException {
        Directory obj = null;
        try {
            if (strReposId.indexOf(".") != -1) {
                strReposId = strReposId.substring(strReposId.indexOf(".") + 1);
            }
            obj = (Directory)this.m_mdFactory.createComplexMetadataObject(this.m_store, strName, "Directory", strReposId);
            obj.setDirectoryName(strDirectoryName);
            obj.setIsRelative(nIsRelative);
            obj.setDirectoryRole("LIBRARY_PATH");
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return obj;
    }

    public static void setProperty(String strKey, String strValue) {
        if (strKey.equals("changedhost") || strKey.equals("changedport")) {
            MUU_Object.setLocationChangeProperties(strKey, strValue);
        }
        if (strKey.equals("customoptions")) {
            System.out.println(MessageBundle.getString("MUU_Object.setting.prop.log") + strValue);
            MUU_Object.setCustomProperties(strValue);
        }
        if (strKey.equals("changeduserid")) {
            MUU_Object.setChagedLoginProperties(strValue, "changeduserid");
        }
        if (strKey.equals("changeduserpswd")) {
            MUU_Object.setChagedLoginProperties(strValue, "changeduserpswd");
        }
        m_hmPrperties.put(strKey, strValue);
    }

    private static void setCustomProperties(String values) {
        Map properties = MetaDataHelper.splitPropertyValue(values, "_Custom");
        if (properties != null) {
            m_hmPrperties.putAll(properties);
        }
    }

    private static void setChagedLoginProperties(String values, String suffix) {
        Map properties = MetaDataHelper.splitPropertyValue(values, "_" + suffix);
        if (properties != null) {
            m_hmPrperties.putAll(properties);
        }
    }

    public static String getCustomProperty(String propertyName) {
        return MUU_Object.getProperty(propertyName + "_Custom");
    }

    private static void setLocationChangeProperties(String key, String values) {
        Map properties;
        int suffixIndex = key.lastIndexOf(".") + 1;
        String propertySuffix = key;
        if (suffixIndex != -1) {
            propertySuffix = key.substring(suffixIndex);
        }
        if ((properties = MetaDataHelper.splitPropertyValue(values, propertySuffix = "_" + propertySuffix)) != null) {
            m_hmPrperties.putAll(properties);
        }
    }

    public static String getProperty(String strKey) {
        String strValue = (String)m_hmPrperties.get(strKey);
        return strValue;
    }

    public static List getPropertyKeys(String keySuffix) {
        ArrayList<String> validKeys = new ArrayList<String>();
        Set keySet = m_hmPrperties.keySet();
        if (keySet != null) {
            Object[] arrObjects = keySet.toArray();
            for (int i = 0; i < arrObjects.length; ++i) {
                String key;
                if (!(arrObjects[i] instanceof String) || !(key = (String)arrObjects[i]).endsWith(keySuffix)) continue;
                int index = key.indexOf(keySuffix);
                key = key.substring(0, index);
                validKeys.add(key);
            }
        }
        return validKeys.isEmpty() ? null : validKeys;
    }

    public static Set getFQIDsOfChangedLogins() {
        HashSet keys = new HashSet();
        List lst = MUU_Object.getPropertyKeys("_changeduserid");
        if (lst != null) {
            keys.addAll(lst);
        }
        if ((lst = MUU_Object.getPropertyKeys("_changeduserpswd")) != null) {
            keys.addAll(lst);
        }
        return keys;
    }

    public Login getLoginObject(String fqid) throws MUUException {
        Login login = null;
        try {
            String strCMTemplate = "<Templates><Login></Login></Templates>";
            int flags = 2316;
            CMetadata cmeta = this.getMetadataAllDepths("Login", fqid, strCMTemplate, flags);
            if (cmeta instanceof Login) {
                login = (Login)cmeta;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return login;
    }

    public boolean UpgradeObjects(String strReposId) throws MUUException {
        try {
            this.m_reposID = strReposId;
            if (!this.IsUpgraded()) {
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.migrating.from.older.version.log"));
                boolean isUpdated = false;
                if (this.isMetadataModelNeedToBeUpgradedTo93()) {
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.need.to.be.upgraded.to.93.log"));
                    isUpdated = this.upgradeMetadataModelTo93();
                    if (isUpdated) {
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.upgraded.to.93.log"));
                        this.updateSoftwareVersion("9.3", Integer.toString(9), Integer.toString(3));
                    } else {
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.cannot.be.upgraded.to.93.log"));
                    }
                } else {
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.need.not.upagred.to.93.log"));
                }
                if (this.isMetadataModelNeedToBeUpgradedTo94()) {
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.need.to.be.upgraded.to.94.log"));
                    isUpdated = this.upgradeMetadataModelTo94();
                    if (isUpdated) {
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.upgraded.to.94.log"));
                        this.updateSoftwareVersion("9.4", Integer.toString(9), Integer.toString(4));
                    } else {
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.cannot.be.upgraded.to.94.log"));
                    }
                } else {
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.need.not.upagred.to.94.log"));
                }
            } else {
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.model.upgrade.not.required.log"));
            }
            this.performSubstituations();
        }
        catch (MUUException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    public abstract String getPublicName();

    public abstract boolean IsUpgraded() throws MUUException;

    public abstract boolean performSubstituations() throws MUUException;

    protected void UpdateSCVersion(ServerComponent sc) throws MUUException {
        try {
            sc.setSoftwareVersion("9.4");
            sc.setMajor(9);
            sc.setMinor(4);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected void updateSoftwareVersion(String version, String major, String minor) throws MUUException {
        try {
            if (this.m_objMetadata instanceof SoftwareComponent) {
                SoftwareComponent sc = (SoftwareComponent)this.m_objMetadata;
                if (minor != null) {
                    sc.setMinor(Integer.parseInt(minor));
                }
                if (version != null) {
                    sc.setSoftwareVersion(version);
                }
                if (major != null) {
                    sc.setMajor(Integer.parseInt(major));
                }
                sc.updateMetadataAll();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected boolean updateServerName(ServerComponent server, String propertyPrefix) throws MUUException {
        String tempFolderPath = MUU_Object.getProperty("tempdir");
        String productCode = MUU_Object.getProperty("productcode");
        propertyPrefix = propertyPrefix == null ? MUU_Object.getProperty("productcode").toLowerCase() : propertyPrefix;
        SMUProperties smuProperties = SMUProperties.getSMUProperties(productCode, tempFolderPath);
        boolean isUpdated = false;
        try {
            String logicalName;
            LogicalServer logicalServer;
            String serverName = smuProperties.getServerProperty(server.getId(), propertyPrefix + ".name");
            if (serverName != null && !serverName.equals(server.getName())) {
                MUU_Client.m_logger.debug(MessageBundle.getString("MUU_Object.changing.server.name.fmt.log", new Object[]{serverName}));
                server.setName(serverName);
                isUpdated = true;
            }
            if ((logicalServer = MetaDataHelper.getLogicalServer(server)) != null && (logicalName = smuProperties.getServerProperty(server.getId(), ".logical.name")) != null && !logicalName.equals(logicalServer.getName())) {
                MUU_Client.m_logger.debug(MessageBundle.getString("MUU_Object.changing.logical.server.name.fmt.log", new Object[]{logicalName}));
                logicalServer.setName(logicalName);
                isUpdated = true;
            }
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        return isUpdated;
    }

    protected int updateMachineFromMachineGroup(ServerComponent cmSrv, String newHost, String oldHost) throws MUUException {
        int retVal = -1;
        try {
            if (this.isMachineGroupAssociated()) {
                AssociationList allSoftwareTrees = cmSrv.getSoftwareTrees();
                Tree treeMachineGroup = null;
                if (allSoftwareTrees != null) {
                    for (int i = 0; i < allSoftwareTrees.size(); ++i) {
                        Tree obj = (Tree)allSoftwareTrees.get(i);
                        if (!obj.getTreeType().equalsIgnoreCase("MachineGroup")) continue;
                        treeMachineGroup = obj;
                        break;
                    }
                    if (treeMachineGroup != null) {
                        int newMachineIndex = -1;
                        Machine oldMachine = null;
                        AssociationList alMembers = treeMachineGroup.getMembers();
                        if (alMembers.size() > 0) {
                            for (int iMac = 0; iMac < alMembers.size(); ++iMac) {
                                String oldMachineName;
                                CMetadata objMac = (CMetadata)alMembers.get(iMac);
                                if (!(objMac instanceof Machine) || !MetaDataHelper.isHostsEqual(oldMachineName = (oldMachine = (Machine)objMac).getName(), oldHost)) continue;
                                if (MetaDataHelper.isHostsEqual(oldHost, newHost)) {
                                    newMachineIndex = iMac++;
                                    break;
                                }
                                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.updating.machine.in.group.fmt.log", new Object[]{oldMachine.getName(), newHost}));
                                Machine newMachine = MetaDataHelper.getSpecificMachineFromList(newHost, (List)alMembers);
                                if (newMachine != null) {
                                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.new.host.present.in.machine.group.fmt.log", new Object[]{newHost, oldHost}));
                                    alMembers.remove(iMac);
                                } else {
                                    newMachine = this.locateMachine(newHost);
                                    if (newMachine != null) {
                                        alMembers.remove(iMac);
                                        alMembers.add(iMac, (Object)newMachine);
                                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.replacing.old.machine.by.new.fmt.log", new Object[]{oldHost, newHost}));
                                    } else {
                                        String message = MessageBundle.getString("MUU_Object.unable.to.create.new.machine.fmt.log", new Object[]{newHost});
                                        MUU_Client.m_logger.error(message);
                                        throw new MUUException(message);
                                    }
                                }
                                String oldMAchineID = oldMachine.getId();
                                treeMachineGroup.setMembers(alMembers);
                                treeMachineGroup.updateMetadataAll();
                                if (oldMAchineID != null && (oldMachine = this.getMachineObject(oldMAchineID)) != null) {
                                    this.deleteMachineIfOrphaned(oldMachine, true);
                                }
                                retVal = iMac + 1;
                                break;
                            }
                        }
                        if (retVal == -1) {
                            if (newMachineIndex != -1) {
                                MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.update.ignored.machine.in.group.fmt.log", new String[]{newHost}));
                                retVal = newMachineIndex;
                            } else {
                                MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.oldhost.ntfound.in.group.fmt.log", new String[]{oldHost}));
                            }
                        }
                    } else {
                        MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.machinegrps.ntfound.log"));
                    }
                } else {
                    MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.softwaretree.ntfound.log"));
                }
            } else {
                retVal = 0;
                MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.machine.group.not.associated.log"));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return retVal;
    }

    protected void MoveSCMachine(String strReposId, ServerComponent cmSrv) throws MUUException {
        try {
            Machine objMachine = cmSrv.getAssociatedMachine();
            if (objMachine == null) {
                return;
            }
            String strMachineName = objMachine.getName();
            AssociationList alSoftTree = cmSrv.getSoftwareTrees();
            Tree objTree = null;
            if (alSoftTree.size() == 0) {
                objTree = this.CreateTree(strReposId, "MachineGroup", "MachineGroup");
                alSoftTree.addElement((Object)objTree);
                cmSrv.setSoftwareTrees(alSoftTree);
            }
            AssociationList alMembers = null;
            for (int iTree = 0; iTree < alSoftTree.size(); ++iTree) {
                objTree = (Tree)alSoftTree.get(iTree);
                alMembers = objTree.getMembers();
                if (alMembers.size() <= 0) continue;
                for (int iMac = 0; iMac < alMembers.size(); ++iMac) {
                    String strName;
                    CMetadata mac = (CMetadata)alMembers.get(iMac);
                    if (!"Machine".equalsIgnoreCase(mac.getCMetadataType()) || !(strName = mac.getName()).equalsIgnoreCase(strMachineName)) continue;
                    return;
                }
            }
            objTree = (Tree)alSoftTree.get(0);
            alMembers = objTree.getMembers();
            alMembers.addElement((Object)objMachine);
            objTree.setMembers(alMembers);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    void SubstituteHostName(ServerComponent cmSrv) throws MUUException {
        try {
            AssociationList alConn = cmSrv.getSourceConnections();
            for (int iSrv = 0; iSrv < alConn.size(); ++iSrv) {
                CMetadata cm = (CMetadata)alConn.get(iSrv);
                if (!"TCPIPConnection".equalsIgnoreCase(cm.getCMetadataType())) continue;
                TCPIPConnection con = (TCPIPConnection)cm;
                con.setHostName(MUU_Client.m_strHost);
            }
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected void setSQLType(ServerComponent cmSrv) throws MUUException {
        try {
            AssociationList alProps = cmSrv.getProperties();
            for (int iProp = 0; iProp < alProps.size(); ++iProp) {
                Property objProp = (Property)alProps.get(iProp);
                PropertyType pType = objProp.getOwningType();
                if (objProp == null || pType == null) continue;
                objProp.setSQLType(pType.getSQLType());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected void DeleteCOMConnections(ServerComponent cmSrv) throws MUUException {
        try {
            AssociationList alSrcConn = cmSrv.getSourceConnections();
            for (int iCon = alSrcConn.size() - 1; iCon >= 0; --iCon) {
                CMetadata objConn = (CMetadata)alSrcConn.get(iCon);
                if (!"COMConnection".equalsIgnoreCase(objConn.getCMetadataType())) continue;
                objConn.delete();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected boolean isSCUpgradedToLatestVersion(ServerComponent cmSrv) throws MUUException {
        try {
            int nMinor = cmSrv.getMinor();
            String strSoftwareVer = cmSrv.getSoftwareVersion();
            if (strSoftwareVer.equalsIgnoreCase(MUU_Client.m_strSoftwareVersion) && nMinor == Integer.parseInt(MUU_Client.m_strMinor)) {
                return true;
            }
        }
        catch (RemoteException e) {
            MUU_Client.m_logger.error(e.getMessage());
            e.printStackTrace();
            throw new MUUException(e);
        }
        return false;
    }

    private boolean isPrimaryServer(SMUProperties smuProperties, ServerComponent server) throws MUUException {
        String serverId = null;
        try {
            serverId = server.getId();
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        return smuProperties.isPrimaryServer(serverId);
    }

    private boolean changeHostForConnection(String changedHost, TCPIPConnection connection) throws RemoteException {
        boolean isChanged = false;
        if (changedHost != null) {
            connection.setHostName(changedHost);
            isChanged = true;
        } else {
            MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.changed.host.log"));
        }
        return isChanged;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int changeAssociatedMachine(String changedHost, ServerComponent server, String oldHost) throws RemoteException, MdException, MUUException {
        int changedMachineIndex = -1;
        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.change.machine.log"));
        if (changedHost == null) {
            MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.changd.host.nt.found.log") + server.getName());
            return changedMachineIndex;
        }
        if (this.isMachineGroupAssociated()) {
            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.group.associated.log"));
            if (oldHost != null) {
                changedMachineIndex = this.updateMachineFromMachineGroup(server, changedHost, oldHost);
                Machine associatedMachine = server.getAssociatedMachine();
                if (associatedMachine == null) return changedMachineIndex;
                Machine oldMachine = this.getMachineObject(associatedMachine.getId());
                if (oldMachine == null) return changedMachineIndex;
                if (!MetaDataHelper.isHostsEqual(oldMachine.getName(), oldHost)) return changedMachineIndex;
                server.setAssociatedMachine(this.locateMachine(changedHost));
                this.deleteMachineIfOrphaned(oldMachine, true);
                return changedMachineIndex;
            }
            MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.old.host.nt.found.fmt.log", new Object[]{server.getName()}));
            return changedMachineIndex;
        }
        if (MetaDataHelper.isHostsEqual(changedHost, oldHost)) {
            return 0;
        }
        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.group.not.associated.log"));
        Machine newMachine = this.locateMachine(changedHost);
        if (newMachine == null) {
            String message = MessageBundle.getString("MUU_Object.unable.to.create.new.machine.fmt.log", new Object[]{changedHost});
            MUU_Client.m_logger.error(message);
            throw new MUUException(message);
        }
        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.updating.associated.machine.fmt.log", new Object[]{server.getName(), changedHost}));
        String oldMachineID = null;
        Machine associatedMachine = server.getAssociatedMachine();
        if (associatedMachine != null) {
            oldMachineID = associatedMachine.getId();
        }
        server.setAssociatedMachine(newMachine);
        server.updateMetadataAll();
        changedMachineIndex = 0;
        if (oldMachineID == null) return changedMachineIndex;
        Machine oldMachine = this.getMachineObject(oldMachineID);
        if (oldMachine == null) return changedMachineIndex;
        this.deleteMachineIfOrphaned(oldMachine, true);
        return changedMachineIndex;
    }

    private boolean deleteMachineIfOrphaned(Machine machineObj, boolean wantToDelete) {
        try {
            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.starting.process.to.check.object.isorphaned.fmt.log", new Object[]{machineObj}));
            boolean f = false;
            if (machineObj == null) {
                return false;
            }
            AssociationList assocList = machineObj.getDeployedComponents();
            if (assocList != null && !assocList.isEmpty()) {
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.object.has.deployed.components.cannot.delete.machine.fmt.log", new Object[]{machineObj}));
                return false;
            }
            AssociationList machineGroups = machineObj.getTrees();
            if (machineGroups != null) {
                if (machineGroups.isEmpty() && wantToDelete) {
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.object.has.not.deployed.components.and.no.any.tress.associated..deleting.machine.fmt.log", new Object[]{machineObj}));
                    machineObj.delete();
                    return true;
                }
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.object.has.tress.associated.fmt.log", new Object[]{machineObj, machineGroups.size()}));
                Iterator machineGroupIterator = machineGroups.iterator();
                while (machineGroupIterator.hasNext()) {
                    Object machineGrp = machineGroupIterator.next();
                    if (!(machineGrp instanceof CMetadata)) continue;
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machinegroup.object.has.software.components.associated.machine.not.orphaned.fmt.log", new Object[]{machineObj}));
                    AssociationList softwareComponents = ((CMetadata)machineGrp).getAssociatedObjects("SoftwareComponents");
                    if (softwareComponents == null || softwareComponents.isEmpty()) continue;
                    f = true;
                    break;
                }
                if (!f && wantToDelete) {
                    Iterator machineGroupIterator1 = machineGroups.iterator();
                    while (machineGroupIterator.hasNext()) {
                        Object machineGrp = machineGroupIterator.next();
                        if (!(machineGrp instanceof CMetadata)) continue;
                        ((CMetadata)machineGrp).delete();
                    }
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.machine.object.is.orphaned.deleting.machine.fmt.log", new Object[]{machineObj}));
                    machineObj.delete();
                    return true;
                }
                return false;
            }
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private boolean changePort(String changedPort, TCPIPConnection connection) throws RemoteException {
        if (connection != null) {
            Object[] arrObjects = new Object[]{connection, Integer.toString(connection.getPort()), changedPort};
            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Object.port.changed.fmt.log", arrObjects));
            connection.setPort(changedPort);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doLocationChange() throws MUUException {
        ServerComponent server = (ServerComponent)this.m_objMetadata;
        ServerComponent configurableObject = MetaDataHelper.getConfigurableObject(server);
        SMUProperties smuProperties = null;
        String tempFolderPath = MUU_Object.getProperty("tempdir");
        String productCode = MUU_Object.getProperty("productcode");
        String changedHost = null;
        String oldHost = null;
        String changedPort = null;
        smuProperties = SMUProperties.getSMUProperties(productCode, tempFolderPath);
        try {
            String hostProp;
            boolean isChanged = false;
            int changedMachineIndex = -1;
            oldHost = smuProperties.getServerProperty(server.getId(), "server.host.prior");
            changedHost = this.getChangedHostName(configurableObject);
            if (changedHost == null && (hostProp = this.getHostPropertyName()) != null) {
                changedHost = smuProperties.getProductProperty(hostProp);
            }
            changedMachineIndex = this.changeAssociatedMachine(changedHost, server, oldHost);
            AssociationList lstCons = server.getSourceConnections();
            if (lstCons != null) {
                for (int i = 0; i < lstCons.size(); ++i) {
                    try {
                        TCPIPConnection con = (TCPIPConnection)lstCons.get(i);
                        changedPort = this.getChangedPort((Connection)con);
                        if (changedPort != null && !"".equals(changedPort)) {
                            isChanged = this.changePort(changedPort, con);
                            if (changedHost == null) continue;
                            if (!this.isMachineGroupAssociated() || changedMachineIndex == 1) {
                                boolean isHostChanged = this.changeHostForConnection(changedHost, con);
                                isChanged = isHostChanged || changedMachineIndex >= 0 || isChanged;
                                continue;
                            }
                            MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.connection.host.nt.changed.log"));
                            continue;
                        }
                        Object[] arrObjects = new Object[]{con.getName()};
                        MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.changed.port.not.found.fmt.log", arrObjects));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (changedHost != null) {
                this.doLocationChange(changedHost);
            }
            if (!isChanged) return true;
        }
        catch (MdException exception) {
            exception.printStackTrace(System.err);
            throw new MUUException(exception);
        }
        catch (RemoteException exception) {
            exception.printStackTrace(System.err);
            throw new MUUException(exception);
        }
        return true;
    }

    protected String getHostPropertyName() {
        return null;
    }

    protected String getChangedHostName(ServerComponent server) {
        String propertyName = null;
        try {
            propertyName = server.getId() + "_" + "changedhost";
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
        return MUU_Object.getProperty(propertyName);
    }

    protected String getChangedPort(ServerComponent server) {
        String propertyName = null;
        try {
            propertyName = server.getId() + "_" + "changedport";
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
        return MUU_Object.getProperty(propertyName);
    }

    protected String getChangedPort(Connection con) {
        String propertyName = null;
        String changedPort = null;
        try {
            propertyName = con.getId() + "_" + "changedport";
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
        changedPort = MUU_Object.getProperty(propertyName);
        return changedPort;
    }

    protected String getChangedUserName(Login login) {
        String propertyName = null;
        String changedLoginName = null;
        try {
            propertyName = login.getId() + "_" + "changeduserid";
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
        changedLoginName = MUU_Object.getProperty(propertyName);
        return changedLoginName;
    }

    protected void removeChangedUserProperty(Login login) {
        try {
            if (login != null) {
                String prop = login.getId() + "_" + "changeduserid";
                m_hmPrperties.remove(prop);
            }
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
    }

    protected void removeChangedPswdProperty(Login login) {
        try {
            if (login != null) {
                String prop = login.getId() + "_" + "changeduserpswd";
                m_hmPrperties.remove(prop);
            }
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
    }

    protected String getChangedUserPswd(Login login) {
        String propertyName = null;
        String changedLoginPswd = null;
        try {
            propertyName = login.getId() + "_" + "changeduserpswd";
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(exception.getMessage(), (Throwable)exception);
        }
        changedLoginPswd = MUU_Object.getProperty(propertyName);
        return changedLoginPswd;
    }

    public boolean isMigrated() throws MUUException {
        boolean isConfigured = false;
        if (this.m_objMetadata != null) {
            String productCode = MUU_Object.getProperty("productcode");
            String tempDir = MUU_Object.getProperty("tempdir");
            SMUProperties smuProperties = SMUProperties.getSMUProperties(productCode, tempDir);
            try {
                isConfigured = smuProperties.isMigratedOnThisMachine(this.m_objMetadata.getId());
            }
            catch (RemoteException exception) {
                throw new MUUException(exception);
            }
        }
        return isConfigured;
    }

    public boolean doLocationChange(String changedHost) throws MUUException {
        return false;
    }

    public CMetadata getMetadataAllDepths(String strMetadataType, String strFQID, String strTemplate, int flags) throws RemoteException, MdException {
        return this.m_omiUtil.getMetadataAllDepths((MdStore)this.m_store, strMetadataType, strFQID, null, null, strTemplate, flags);
    }

    public List getMetadataObjectsSubset(String strType, int flags, String strTemplate) throws RemoteException, MdException {
        ArrayList lstObjects = null;
        List lstRepos = this.m_omiUtil.getRepositories();
        if (lstRepos != null) {
            for (int i = 0; i < lstRepos.size(); ++i) {
                CMetadata repos;
                List lstLocal;
                Object obj = lstRepos.get(i);
                if (!(obj instanceof CMetadata) || (lstLocal = this.m_omiUtil.getMetadataObjectsSubset((MdStore)this.m_store, (repos = (CMetadata)obj).getId(), strType, flags, strTemplate)) == null) continue;
                if (lstObjects == null) {
                    lstObjects = new ArrayList();
                }
                lstObjects.addAll(lstLocal);
            }
        }
        return lstObjects;
    }

    public List getMetadataObjectsSubset(String reposID, String strType, int flags, String strTemplate) throws RemoteException, MdException {
        return this.m_omiUtil.getMetadataObjectsSubset((MdStore)this.m_store, reposID, strType, flags, strTemplate);
    }

    public String getShortHostName(String hostName) {
        int index;
        if (hostName != null && (index = hostName.indexOf(".")) != -1) {
            return hostName.substring(0, index);
        }
        return hostName;
    }

    protected boolean isMachineGroupAssociated() {
        return false;
    }

    public boolean isMetadataModelNeedToBeUpgradedTo92() throws MUUException {
        if (this.m_objMetadata instanceof SoftwareComponent) {
            SoftwareComponent server = (SoftwareComponent)this.m_objMetadata;
            try {
                String version = server.getSoftwareVersion();
                int retVal = this.checkVersionEquality(version, MUU_Client.m_strSoftwareVersion);
                return retVal == 1;
            }
            catch (RemoteException e) {
                e.printStackTrace(System.err);
                throw new MUUException(e);
            }
        }
        return false;
    }

    @Override
    public boolean isMetadataModelNeedToBeUpgradedTo93() {
        if (this.m_objMetadata instanceof SoftwareComponent) {
            SoftwareComponent server = (SoftwareComponent)this.m_objMetadata;
            try {
                String version = server.getSoftwareVersion();
                int retVal = this.checkVersionEquality(version, "9.3");
                return retVal == 1;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isMetadataModelNeedToBeUpgradedTo94() {
        if (this.m_objMetadata instanceof SoftwareComponent) {
            SoftwareComponent server = (SoftwareComponent)this.m_objMetadata;
            try {
                String version = server.getSoftwareVersion();
                int retVal = this.checkVersionEquality(version, "9.4");
                return retVal == 1;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean upgradeMetadataModelTo93() throws MUUException {
        try {
            MUU_Client.m_logger.info("Started upgrade to 93 model");
            boolean isUpgraded = false;
            ServerComponent server = (ServerComponent)this.m_objMetadata;
            AssociationList softwareTrees = server.getSoftwareTrees(true);
            if (!this.isMachineGroupAssociated() && !MUU_Object.isEmpty(softwareTrees)) {
                for (int index = 0; index < softwareTrees.size(); ++index) {
                    Tree tree = (Tree)softwareTrees.get(index);
                    if (!tree.getTreeType().equals("MachineGroup")) continue;
                    MUU_Client.m_logger.info("Deleting \"MachineGroup\" Tree as multi machine deployment is not supported for this server.");
                    softwareTrees.remove(index);
                    tree.delete();
                    isUpgraded = true;
                }
            }
            if (isUpgraded) {
                server.updateMetadataAll();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    @Override
    public boolean upgradeMetadataModelTo94() throws MUUException {
        return true;
    }

    void updateInitTermProgPaths(ServerComponent cmSrv) throws MUUException {
        String tempFolderPath = MUU_Object.getProperty("tempdir");
        String productCode = MUU_Object.getProperty("productcode");
        SMUProperties smuProperties = SMUProperties.getSMUProperties(productCode, tempFolderPath);
        if (smuProperties != null) {
            try {
                boolean isPrimary = smuProperties.isPrimaryServer(cmSrv.getId());
                if (isPrimary) {
                    MUU_Client.m_logger.info("Primary Server");
                    LogicalServer logicalServer = MetaDataHelper.getLogicalServer(cmSrv);
                    if (logicalServer != null) {
                        MUU_Client.m_logger.info("Found Logical Server");
                        String metaLogicalPropName = null;
                        String metaLogicalPropValue = null;
                        AssociationList metaLogicalSvrProps = logicalServer.getProperties();
                        Property metaLogicalProp = null;
                        if (metaLogicalSvrProps != null && metaLogicalSvrProps.size() > 0) {
                            MUU_Client.m_logger.info("Found Logical Server Properties");
                            for (int i = 0; i < PROP_INIT_TERMINATE_PROG_ARRAY.length; ++i) {
                                MUU_Client.m_logger.info("Retriving properties value for " + cmSrv.getId() + " with key" + PROP_INIT_TERMINATE_PROG_ARRAY[i] + ".name");
                                String propName = smuProperties.getServerProperty(cmSrv.getId(), PROP_INIT_TERMINATE_PROG_ARRAY[i] + ".name");
                                String propValue = smuProperties.getServerProperty(cmSrv.getId(), PROP_INIT_TERMINATE_PROG_ARRAY[i] + ".value");
                                MUU_Client.m_logger.info(propName + " == " + propValue);
                                if (propName == null || propValue == null) continue;
                                boolean isValueSet = false;
                                for (int index = 0; index < metaLogicalSvrProps.size(); ++index) {
                                    isValueSet = false;
                                    metaLogicalProp = (Property)metaLogicalSvrProps.get(index);
                                    metaLogicalPropName = metaLogicalProp.getPropertyName();
                                    metaLogicalPropValue = metaLogicalProp.getDefaultValue();
                                    MUU_Client.m_logger.info(metaLogicalPropName + " == " + metaLogicalPropValue);
                                    if (!propName.equalsIgnoreCase(metaLogicalPropName)) continue;
                                    MUU_Client.m_logger.info("Setting value of " + metaLogicalPropName + " to " + propValue);
                                    metaLogicalProp.setDefaultValue(propValue);
                                    isValueSet = true;
                                    break;
                                }
                                if (isValueSet) continue;
                                MUU_Client.m_logger.error("Property not found on metadata server with name " + propName);
                            }
                        }
                    }
                }
            }
            catch (MdException exception) {
                MUU_Client.m_logger.error(exception.getMessage());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public static String getOS_Family() {
        switch (MUU_Object.getOS()) {
            case 0: {
                return OS_FAMILY_UNDEFINED;
            }
            case 1: {
                return OS_FAMILY_WINDOWS;
            }
            case 2: {
                return OS_FAMILY_UNIX;
            }
            case 3: {
                return OS_FAMILY_UNIX;
            }
            case 4: {
                return OS_FAMILY_UNIX;
            }
            case 5: {
                return OS_FAMILY_UNIX;
            }
            case 6: {
                return OS_FAMILY_VMS;
            }
            case 7: {
                return OS_FAMILY_UNIX;
            }
            case 8: {
                return OS_FAMILY_MVS;
            }
            case 9: {
                return OS_FAMILY_MAC;
            }
            case 10: {
                return OS_FAMILY_ZOS;
            }
        }
        return OS_FAMILY_UNDEFINED;
    }

    public static int getOS() {
        int rc = 0;
        String osName = System.getProperty("os.name");
        if (osName.startsWith(OS_FAMILY_WINDOWS)) {
            rc = 1;
        } else if (osName.equalsIgnoreCase("Linux")) {
            rc = 2;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            rc = 3;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            rc = 4;
        } else if (osName.equalsIgnoreCase("AIX")) {
            rc = 5;
        } else if (osName.equalsIgnoreCase("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("Compaq's Digital UNIX") || osName.equalsIgnoreCase("OSF1")) {
            rc = 7;
        } else if (osName.equalsIgnoreCase(OS_FAMILY_MVS)) {
            rc = 8;
        } else if (osName.equalsIgnoreCase("z/os")) {
            rc = 10;
        } else if (osName.startsWith("Mac")) {
            rc = 9;
        } else if (osName.startsWith("OpenVMS")) {
            rc = 6;
        }
        return rc;
    }

    void changeConnectionName(ServerComponent cmSrv) throws MUUException {
        try {
            String hostProp;
            SMUProperties smuProperties = null;
            String tempFolderPath = MUU_Object.getProperty("tempdir");
            String productCode = MUU_Object.getProperty("productcode");
            String newHost = null;
            String oldHost = null;
            smuProperties = SMUProperties.getSMUProperties(productCode, tempFolderPath);
            ServerComponent configurableObject = MetaDataHelper.getConfigurableObject(cmSrv);
            oldHost = smuProperties.getServerProperty(cmSrv.getId(), "server.host.prior");
            newHost = this.getChangedHostName(configurableObject);
            if (newHost == null && (hostProp = this.getHostPropertyName()) != null) {
                newHost = smuProperties.getProductProperty(hostProp);
            }
            MUU_Client.m_logger.info("oldHost = " + oldHost);
            MUU_Client.m_logger.info("newHost = " + newHost);
            if (oldHost != null && newHost != null) {
                String shortOldHost = this.getShortHostName(oldHost);
                String shortNewHost = this.getShortHostName(newHost);
                Pattern patternFullHostName = Pattern.compile("(?i)" + shortOldHost + "\\.([^\\.]*)\\.([^\\.]*)\\.([\\S]*)");
                Pattern patternShortHostName = Pattern.compile("(?i)" + shortOldHost + "([\\S]*)");
                AssociationList alConn = cmSrv.getSourceConnections();
                if (alConn == null || alConn.size() == 0) {
                    MUU_Client.m_logger.info("No connection found for = " + cmSrv.getName());
                }
                String conName = null;
                boolean isUpdated = false;
                for (int iSrv = 0; iSrv < alConn.size(); ++iSrv) {
                    CMetadata cm = (CMetadata)alConn.get(iSrv);
                    conName = cm.getName();
                    String newConName = null;
                    MUU_Client.m_logger.info("Before: conName = " + conName);
                    if (conName == null || conName.length() <= 0) continue;
                    Matcher matcherFullHostName = patternFullHostName.matcher(conName);
                    if (matcherFullHostName.find()) {
                        newConName = matcherFullHostName.replaceAll(newHost);
                        cm.setName(newConName);
                    } else {
                        Matcher matcherShortHostName = patternShortHostName.matcher(conName);
                        if (matcherShortHostName.find()) {
                            newConName = matcherShortHostName.replaceAll(shortNewHost);
                            cm.setName(newConName);
                        }
                    }
                    if (newConName != null) {
                        isUpdated = true;
                        MUU_Client.m_logger.info("After: conName = " + newConName);
                        continue;
                    }
                    MUU_Client.m_logger.info("Connection Name not modified ");
                }
                if (isUpdated) {
                    this.m_objMetadata.updateMetadataAll();
                }
            }
        }
        catch (RemoteException e) {
            throw new MUUException(e);
        }
        catch (MdException e) {
            throw new MUUException(e);
        }
        catch (MUUException e) {
            throw new MUUException(e);
        }
        catch (Exception e) {
            throw new MUUException(e);
        }
    }

    private String substituteString(String str, String searchString, String replaceString) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        if (searchString != null && replaceString != null) {
            while ((e = str.toLowerCase().indexOf(searchString.toLowerCase(), s)) >= 0) {
                result.append(str.substring(s, e));
                result.append(replaceString);
                s = e + searchString.length();
            }
        }
        result.append(str.substring(s));
        MUU_Client.m_logger.info("substituteString().result = " + result.toString());
        return result.toString();
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty = false;
        if (object == null) {
            isEmpty = true;
        } else if (object instanceof String && ((String)object).length() <= 0) {
            isEmpty = true;
        } else if (object instanceof Collection && ((Collection)object).size() <= 0) {
            isEmpty = true;
        } else if (object instanceof Map && ((Map)object).size() <= 0) {
            isEmpty = true;
        } else if (object.getClass().isArray() && ((Object[])object).length <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }
}

