/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import java.rmi.RemoteException;

public class MUU_OSSrvSched
extends MUU_Object {
    public static final String m_strProductCode = "OSSRVSCHED";
    public static final String m_strPublicName = "OS Scheduling server";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><Properties/><ServiceTypes/><SoftwareTrees/><SourceConnections/><UsedByComponents/><UsingComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><LogicalServer><InitProcesses/><Properties/><ServiceTypes/><UsedByComponents/><UsingPrototype/></LogicalServer><Transformation><Properties/></Transformation><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ProductName='OS'\"/>";
    private static final String PROP_CONTROL_DIR_NAME = "controldir";
    private static final String META_CMD_OPTION = "Command";
    private static final String META_CONTROL_DIR_NAME = "OutDir";
    private static final String CONFIG_FILE_NAME = "SchedulingServer";

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    private boolean substituteValues(ServerComponent server) throws MUUException {
        String property = MUU_OSSrvSched.getCustomProperty(PROP_CONTROL_DIR_NAME);
        String commandOption = MUU_OSSrvSched.getCustomProperty("cmdoption");
        this.setMetaProperty(server, META_CONTROL_DIR_NAME, property);
        if (commandOption != null) {
            String configFileName = null;
            configFileName = "Windows".equalsIgnoreCase(MUU_Object.getOS_Family()) ? "\"" + MetaDataHelper.getConfigFileName(property, CONFIG_FILE_NAME) + "\"" : MetaDataHelper.getConfigFileName(property, CONFIG_FILE_NAME);
            if (configFileName != null) {
                commandOption = configFileName + " " + commandOption;
                this.setMetaProperty(server, META_CMD_OPTION, commandOption);
            }
        }
        return false;
    }

    @Override
    public String getPublicName() {
        return null;
    }

    private boolean setMetaProperty(ServerComponent server, String propertyName, String propertyValue) {
        boolean isSet = false;
        try {
            if (propertyValue != null) {
                Property metaProperty = MetaDataHelper.getProperty(server, propertyName);
                if (metaProperty != null) {
                    metaProperty.setDefaultValue(propertyValue);
                    isSet = true;
                }
            } else {
                System.out.println(MessageBundle.getString("MUU_OSSrvSched.value.nt.found.log") + propertyName);
            }
        }
        catch (MUUException exception) {
            MUU_Client.m_logger.error(MessageBundle.getString("MUU_OSSrvSched.remote.exception.log") + exception);
        }
        catch (RemoteException exception) {
            MUU_Client.m_logger.error(MessageBundle.getString("MUU_OSSrvSched.remote.exception.log") + exception);
        }
        return isSet;
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            ServerComponent server = (ServerComponent)this.m_objMetadata;
            this.doLocationChange();
            this.updateServerName(server, MUU_OSSrvSched.getProperty("productcode").toLowerCase());
            this.changeConnectionName(server);
            this.substituteValues(server);
            server.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        return true;
    }
}

