/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MUU_OLAPCubeSrv
extends MUU_Object {
    public static final String m_strProductCode = "OLAPCUBESRV";
    public static final String m_strPublicName = "OLAP Cube server";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><Properties/><ServiceTypes/><SoftwareTrees/><SourceConnections/><UsedByComponents/><UsingComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><LogicalServer><InitProcesses/><Properties/><ServiceTypes/><UsedByComponents/><UsingPrototype/></LogicalServer><Transformation><Properties/></Transformation><Property Id=\"\" Name=\"\" PropertyName=\"\" DefaultValue=\"\"><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ProductName='SAS OLAP Server'\"/>";
    public static final String PROPERTY_PROP_NAME = "property";
    private static final String[] PROPS_TO_REMOVE = new String[]{"memmax", "dataCache", "uselabelsdt", "maxexecthreads", "TKEOLS_DBG_CACHEMEM", "TKEOLS_DBG_CACHEPICK", "TKEOLS_DBG_CACHELOAD", "TKEOLS_DBG_CACHEEXEC", "TKEOLS_DBG_CACHERANGE"};
    private static final String PROPERTY_DELETESESSIONSDEBUGJOURNAL_PROPERTYNAME = "TKEOLS_DEL_DBGJNL";
    private static final String PROPERTY_PRNTQUERYREGIONS_PROPERTYNAME = "TKEOLS_DBG_REGIONS";
    private static final String PROPERTY_PRNTFLATROWSET_PROPERTYNAME = "TKEOLS_DBG_FLATRS";
    private static final String PROPERTY_PRINTEXECUTIONFLOW_PROPERTYNAME = "TKEOLS_DBG_OVMEXEC";
    private static final String PROPERTY_PRINTEXECUTIONFLOW_NAME_OLD = "Server.OLAP.Property.PrintExecutionFlow.xmlKey.txt";
    private static final String PROPERTY_PRINTEXECUTIONFLOW_NAME_NEW = "Server.OLAP.Property.PrintOVMFlow.xmlKey.txt";

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    protected void deleteAssociations(ServerComponent server) throws MUUException {
        super.setSQLType(server);
        super.DeleteCOMConnections(server);
        MetaDataHelper.deleteProperty(server, PROPERTY_PROP_NAME);
        for (int index = 0; index < PROPS_TO_REMOVE.length; ++index) {
            MetaDataHelper.deleteProperty(server, PROPS_TO_REMOVE[index]);
        }
        try {
            server.updateMetadataAll();
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        catch (MdException exception) {
            throw new MUUException(exception);
        }
    }

    protected void AddAssociations() throws MUUException {
        ServerComponent olapServer = (ServerComponent)this.m_objMetadata;
        LogicalServer olapLogicalServer = null;
        olapLogicalServer = MetaDataHelper.getLogicalServer(olapServer);
        MetaDataHelper.addProperties((ServerComponent)olapLogicalServer, this.getProperties(this.getReposID()));
    }

    private void substituteValues(ServerComponent cmSrv) {
    }

    private List getProperties(String strReposId) throws MUUException {
        ArrayList<Property> properties = new ArrayList<Property>(2);
        Property property = null;
        String propertyName = null;
        propertyName = "LogicalServer.Security.Property.SACS.Name.xmlKey.txt";
        property = this.CreateProperty(strReposId, propertyName, "EnableSACS", "False", "12");
        properties.add(property);
        propertyName = "LogicalServer.Security.Property.AuthService.Name.xmlKey.txt";
        property = this.CreateProperty(strReposId, propertyName, "AuthService", "Metadata", "12");
        properties.add(property);
        return properties;
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            this.doLocationChange();
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            this.substituteValues(cmSrv);
            cmSrv.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            this.AddAssociations();
            this.deleteAssociations(cmSrv);
            cmSrv.updateMetadataAll();
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return false;
    }

    @Override
    public boolean upgradeMetadataModelTo93() throws MUUException {
        try {
            super.upgradeMetadataModelTo93();
            boolean isUpgraded = false;
            ServerComponent server = (ServerComponent)this.m_objMetadata;
            AssociationList properties = server.getProperties();
            MUU_Client.m_logger.info(MessageBundle.getString("MUU_OLAPCubeSrv.analzing.properties.log"));
            if (properties != null && properties.size() > 0) {
                for (int i = 0; i < properties.size(); ++i) {
                    Object obj = properties.get(i);
                    if (!(obj instanceof Property)) continue;
                    Property property = (Property)obj;
                    String propertyName = property.getPropertyName();
                    if (this.shouldDeleteProperty(propertyName)) {
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_OLAPCubeSrv.property.found.deleted.fmt.log", new Object[]{propertyName}));
                        properties.remove(i);
                        property.delete();
                        if (isUpgraded) break;
                        isUpgraded = true;
                        --i;
                        continue;
                    }
                    if (!PROPERTY_PRINTEXECUTIONFLOW_PROPERTYNAME.equalsIgnoreCase(property.getPropertyName())) continue;
                    MUU_Client.m_logger.info(MessageBundle.getString("MUU_OLAPCubeSrv.property.found.renamed.fmt.log", new Object[]{PROPERTY_PRINTEXECUTIONFLOW_PROPERTYNAME}));
                    property.setName(PROPERTY_PRINTEXECUTIONFLOW_NAME_NEW);
                    if (isUpgraded) break;
                    isUpgraded = true;
                }
            }
            if (isUpgraded) {
                server.updateMetadataAll();
            }
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    private boolean shouldDeleteProperty(String propertyName) {
        return propertyName != null && (propertyName.equalsIgnoreCase(PROPERTY_DELETESESSIONSDEBUGJOURNAL_PROPERTYNAME) || propertyName.equalsIgnoreCase(PROPERTY_PRNTFLATROWSET_PROPERTYNAME) || propertyName.equalsIgnoreCase(PROPERTY_PRNTQUERYREGIONS_PROPERTYNAME));
    }
}

