/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.muu.SMUProperties;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TextStore;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MUU_Directory
extends MUU_Object {
    public static final String m_strProductCode = "DATAPACKAGE";
    public static final String m_strPublicName = "";
    public static final String m_strMetadataType = "Directory";
    public static final String m_strTemplate = "<Templates><Directory><DeployedComponents/><Notes/><UsedByPackages/></Directory></Templates>";
    public static final String m_strXMLSelect = "";
    private static final String DIR_NEW_PATH_PROP = "source.code.repository.newpath";
    private static final String DIR_IS_RELATIVE_PROP = "directory.is.relative";
    private static final String DIR_CLASSIFIERMAPS_LIST = "directory.classifiermap.list";
    private static final String PRIOR_DIR_ID = "prior.directory.fqid";

    @Override
    public boolean IsUpgraded() throws MUUException {
        return false;
    }

    @Override
    public String getPublicName() {
        return null;
    }

    @Override
    public boolean isMigrated() throws MUUException {
        return true;
    }

    private void updateAttributes(Directory directory) throws MUUException {
        String strTempDir = MUU_Object.getProperty("tempdir");
        SMUProperties smuProperties = null;
        try {
            AssociationList lstNotes;
            smuProperties = SMUProperties.getSMUProperties(m_strProductCode, strTempDir);
            Properties properties = smuProperties.getServerPropertiesById(directory.getId());
            boolean isDirDerivedFromPrior = false;
            TextStore tsAssociatedWithDir = null;
            Properties storedProps = null;
            if (properties == null && (lstNotes = directory.getNotes()) != null) {
                for (int i = 0; i < lstNotes.size(); ++i) {
                    String priorID;
                    TextStore ts;
                    Object obj = lstNotes.get(i);
                    if (!(obj instanceof TextStore) || !(ts = (TextStore)obj).getName().equals("UpgradeNote") || (storedProps = MetaDataHelper.loadPropertiesFromStoredText(ts)) == null || (priorID = storedProps.getProperty(PRIOR_DIR_ID)) == null) continue;
                    properties = smuProperties.getServerPropertiesById(priorID);
                    tsAssociatedWithDir = ts;
                    isDirDerivedFromPrior = true;
                }
            }
            Object[] arrObjects = new Object[]{directory.getName(), directory.getDirectoryName()};
            String strMsg = MessageBundle.getString("MUU.obj.found.fmt.log", arrObjects);
            if (properties != null) {
                String strIsDirRelative = properties.getProperty(DIR_IS_RELATIVE_PROP);
                String strSrcReposNewPath = properties.getProperty(DIR_NEW_PATH_PROP);
                String strSrcReposOldPath = directory.getDirectoryName();
                if (strSrcReposOldPath != null && strSrcReposNewPath != null) {
                    String strCMIdList;
                    if ("true".equalsIgnoreCase(strIsDirRelative)) {
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Directory.upgrade.not.needed.fmt.log", arrObjects));
                    } else {
                        Object[] arrObjects1 = new Object[]{directory.getName(), strSrcReposOldPath, strSrcReposNewPath};
                        MUU_Client.m_logger.info(MessageBundle.getString("MUU_Directory.upgrading.path.fmt.log", arrObjects1));
                        directory.setDirectoryName(strSrcReposNewPath);
                        this.updateJCLFilepath(directory, strSrcReposOldPath, strSrcReposNewPath);
                    }
                    if (isDirDerivedFromPrior && storedProps != null) {
                        if (storedProps.size() > 1) {
                            storedProps.remove(PRIOR_DIR_ID);
                            String storedText = MetaDataHelper.getStringFromProperties(storedProps);
                            tsAssociatedWithDir.setStoredText(storedText);
                            tsAssociatedWithDir.updateMetadataAll();
                        } else {
                            tsAssociatedWithDir.delete();
                            tsAssociatedWithDir.updateMetadataAll();
                        }
                    }
                    if ((strCMIdList = properties.getProperty(DIR_CLASSIFIERMAPS_LIST)) != null) {
                        String strCMTemplate = "<Templates><ClassifierMap><Prompts/></ClassifierMap></Templates>";
                        int flags = 2316;
                        StringTokenizer st = new StringTokenizer(strCMIdList, "|");
                        while (st.hasMoreTokens()) {
                            String strFQID = st.nextToken();
                            Object[] objs = new Object[]{strFQID};
                            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Directory.stordproc.analyzing.fmt.log", objs));
                            CMetadata cmeta = this.getMetadataAllDepths("ClassifierMap", strFQID, strCMTemplate, flags);
                            if (!(cmeta instanceof ClassifierMap)) continue;
                            ClassifierMap cm = (ClassifierMap)cmeta;
                            this.fixArchivePathPrompt(cm, strSrcReposOldPath, strSrcReposNewPath);
                        }
                    }
                } else {
                    MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Directory.metadata.not.upgraded.fmt.log", arrObjects));
                }
            } else {
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Directory.upgrade.not.needed.fmt.log", arrObjects));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    private void updateJCLFilepath(Directory directory, String oldPath, String newPath) throws MdException, IOException {
        File dir;
        if (this.isDeployedJobDirectory(directory) && (dir = new File(newPath)).exists()) {
            JCLFileFilter jclFilter = new JCLFileFilter();
            File[] children = dir.listFiles(jclFilter);
            for (int i = 0; i < children.length; ++i) {
                boolean success;
                File file = children[i];
                File jclDir = new File(dir.getAbsolutePath() + File.separatorChar + "oldjclbackup");
                if (!jclDir.exists()) {
                    jclDir.mkdir();
                }
                if (success = file.renameTo(new File(jclDir, file.getName()))) {
                    String s;
                    File oldfile = new File(jclDir, file.getName());
                    BufferedReader reader = new BufferedReader(new FileReader(oldfile));
                    BufferedWriter writer = new BufferedWriter(new FileWriter(dir.getAbsolutePath() + File.separatorChar + oldfile.getName()));
                    while ((s = reader.readLine()) != null) {
                        s = s.replace(oldPath, newPath);
                        writer.write(s);
                        writer.newLine();
                    }
                    reader.close();
                    writer.close();
                }
                Object[] arrObjects = new Object[]{file.getName(), oldPath, newPath};
                MUU_Client.m_logger.info(MessageBundle.getString("MUU_Directory.DeployedJob.JCL.changed.path.fmt.log", arrObjects));
            }
        }
    }

    private boolean isDeployedJobDirectory(Directory directory) throws RemoteException, MdException {
        boolean Flag = false;
        if (directory.getDeployedComponents().size() > 0) {
            AssociationList lstSrvContext = directory.getDeployedComponents();
            block0: for (int i = 0; i < lstSrvContext.size(); ++i) {
                ServerContext srv;
                AssociationList lstJob;
                CMetadata cm = (CMetadata)lstSrvContext.get(i);
                if (!"ServerContext".equalsIgnoreCase(cm.getCMetadataType()) || (lstJob = (srv = (ServerContext)cm).getComputeTasks()).size() <= 0) continue;
                for (int j = 0; j < lstJob.size(); ++j) {
                    CMetadata cmj = (CMetadata)lstJob.get(j);
                    if (!"JFJob".equalsIgnoreCase(cmj.getCMetadataType())) continue;
                    Flag = true;
                    continue block0;
                }
            }
        }
        return Flag;
    }

    private void fixArchivePathPrompt(ClassifierMap cm, String oldPath, String newPath) throws ParserConfigurationException, MdException, SAXException, IOException, BackingStoreException {
        Object defaultValue;
        PromptsReadingContext readingContext;
        Log4JFactory2 factory;
        StringReader reader;
        PromptGroupInterface promptGroup;
        PromptDefinitionInterface pd;
        PromptGroup jomaPromptGroup;
        String xml;
        AssociationList promptsGroups = cm.getPrompts();
        if (promptsGroups.size() == 1 && (xml = (jomaPromptGroup = (PromptGroup)promptsGroups.get(0)).getGroupInfo()) != null && xml.length() > 0 && (pd = (promptGroup = (PromptGroupInterface)PromptUtil.newObjectFromXML((Reader)(reader = new StringReader(xml)), (LoggerFactoryInterface)(factory = new Log4JFactory2()), (PromptsReadingContext)(readingContext = PersistenceFactory.newReadingContext((LoggerFactoryInterface)factory)))).getPromptDefinition("_archive_path", true)) != null && pd.isDefaultValueSet() && (defaultValue = pd.getDefaultValue()) != null && defaultValue instanceof String) {
            String oldValue = (String)defaultValue;
            if (!oldValue.equals(oldPath)) {
                return;
            }
            MutablePromptDefinitionInterface mpd = (MutablePromptDefinitionInterface)pd;
            mpd.setDefaultValue((Object)newPath);
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            PromptsWritingContext wc = PersistenceFactory.newWritingContext((PersistenceInterface)promptGroup, (LoggerFactoryInterface)factory);
            Element element = promptGroup.write((Node)doc, (IntegratedWritingContext)wc);
            PersistHelper.removeUnreferencedPersistenceIDs((Element)element, (PromptsWritingContext)wc);
            xml = XmlUtil.documentToPrettyString((Document)doc);
            jomaPromptGroup.setGroupInfo(xml);
            Object[] arrObjects = new Object[]{cm.getName(), cm.getId(), oldValue, newPath};
            MUU_Client.m_logger.info(MessageBundle.getString("MUU_Directory.stordproc.changed.path.fmt.log", arrObjects));
        }
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            Directory cmDir = (Directory)this.m_objMetadata;
            this.updateAttributes(cmDir);
            cmDir.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        return true;
    }

    private class JCLFileFilter
    implements FileFilter {
        private JCLFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return false;
            }
            String name = f.getName().toLowerCase();
            return name.endsWith("jcl");
        }
    }
}

