/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.muu.MUU;
import com.sas.metadata.muu.MUUClientOptions;
import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.services.ServiceException;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.Security;
import java.util.List;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MUU_Client
extends BatchDriver2 {
    static String m_strHost = null;
    static String m_strPort = null;
    static String m_strUser = null;
    static String m_strProductCode = null;
    static String m_strDomain = "DefaultAuth";
    static String m_strRepository = "Foundation";
    static Logger m_logger = LogManager.getLogger(MUU_Client.class);
    static int retCode = 0;
    static String m_strMajor = null;
    static String m_strMinor = null;
    static String m_strSoftwareVersion = null;

    MUU_Client() {
        if (this._logger == null) {
            this._logger = LogManager.getLogger(MUU_Client.class);
        }
        m_logger = this._logger;
        this.setDebug(this._debug);
    }

    public static void main(String[] args) throws MUUException {
        try {
            MUU_Client cl = new MUU_Client();
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
            cl.parse(args);
            int retCode = cl.InvokeMUU();
            System.exit(retCode);
        }
        catch (MissingOptionException e) {
            m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (ParseException e) {
            m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int InvokeMUU() {
        try {
            this.initialize();
            m_logger.info(MessageBundle.getString("MUU_Client.init.wrkspace.metadata.store.log"));
            MdFactory mdFact = this._factory;
            m_logger.info(MessageBundle.getString("MUU_Client.connecting.metadatasrv.log"));
            MdOMRConnection omrConnection = mdFact.getConnection();
            MdOMIUtil omiUtil = mdFact.getOMIUtil();
            m_logger.info(MessageBundle.getString("MUU_Client.searching.repos.log"));
            List lstRepos = omiUtil.getRepositories();
            if (lstRepos == null || lstRepos.size() == 0) {
                m_logger.fatal(MessageBundle.getString("MUU_Client.repos.nt.found.log"));
                int n = 8;
                return n;
            }
            Object[] arrObjects = new Object[]{new Integer(lstRepos.size())};
            m_logger.info(MessageBundle.getString("MUU_Client.repos.found.fmt.log", arrObjects));
            m_logger.info(MessageBundle.getString("MUU_Client.init.factory.log"));
            MUU muu = new MUU(omrConnection.getCMRHandle(), mdFact);
            for (int iRepos = 0; iRepos < lstRepos.size(); ++iRepos) {
                CMetadata cm = (CMetadata)lstRepos.get(iRepos);
                String strReposId = cm.getId();
                String strReposName = cm.getName();
                m_logger.debug("Processing repository: " + strReposName);
                muu.UpgradeMetadata(strReposId, m_strProductCode);
            }
            omiUtil.dispose();
        }
        catch (ServiceException e) {
            e.printStackTrace(System.err);
            retCode = 8;
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            retCode = 8;
        }
        catch (LogicalTypeException e) {
            e.printStackTrace(System.err);
            retCode = 8;
        }
        catch (Exception exception) {
            m_logger.error(MessageBundle.getString("ERROR.log") + exception.getMessage());
            exception.printStackTrace(System.err);
            retCode = 8;
        }
        finally {
            m_logger.info(MessageBundle.getString("EXIT.MUU.log"));
        }
        return retCode;
    }

    public static void setReturnCode(int tempRetCode) {
        if (tempRetCode != -1) {
            retCode = tempRetCode;
        }
    }

    protected static String getArgumentValue(int iKeyIndex, int iParamCount, String[] args) {
        if (iKeyIndex >= iParamCount) {
            return null;
        }
        return args[iKeyIndex];
    }

    private static void createConfigFile(String strHost, String strPort, String strRepository, String strDomain) throws MUUException {
        try {
            String strUserDir = System.getProperty("user.home");
            String strFileSep = System.getProperty("file.separator");
            String strConfigFile = strUserDir + strFileSep + strHost + ".config";
            FileWriter out = new FileWriter(strConfigFile, false);
            out.write("PFS {\n");
            out.write("\tcom.sas.services.security.login.OMILoginModule  optional\n");
            out.write("\t\"host\"=\"");
            out.write(strHost);
            out.write("\"\n\t\"port\"=\"");
            out.write(strPort);
            out.write("\"\n\t\"repository\"=\"");
            out.write(strRepository);
            out.write("\"\n\t\"domain\"=\"");
            out.write(strDomain);
            out.write("\";\n};\n");
            out.flush();
            out.close();
            strConfigFile = strConfigFile.replace('\\', '/');
            strConfigFile = "file:" + strConfigFile;
            Security.setProperty("login.config.url.1", strConfigFile);
        }
        catch (IOException e) {
            m_logger.error(e.getMessage());
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new MUUClientOptions();
        super.parse(args);
        if (this._help) {
            return;
        }
        Option[] arrOptions = this._commandLine.getOptions();
        for (int iOpt = 0; iOpt < arrOptions.length; ++iOpt) {
            Option objOption = arrOptions[iOpt];
            if ("host".equalsIgnoreCase(objOption.getOpt())) {
                m_strHost = objOption.getValue();
            } else if ("port".equalsIgnoreCase(objOption.getOpt())) {
                m_strPort = objOption.getValue();
            } else if ("user".equalsIgnoreCase(objOption.getOpt())) {
                m_strUser = objOption.getValue();
            } else if ("productcode".equalsIgnoreCase(objOption.getOpt())) {
                m_strProductCode = objOption.getValue();
            } else if ("domain".equalsIgnoreCase(objOption.getOpt())) {
                m_strDomain = objOption.getValue();
            } else if ("repository".equalsIgnoreCase(objOption.getOpt())) {
                m_strRepository = objOption.getValue();
            } else if ("major".equalsIgnoreCase(objOption.getOpt())) {
                m_strMajor = objOption.getValue();
            } else if ("minor".equalsIgnoreCase(objOption.getOpt())) {
                m_strMinor = objOption.getValue();
            } else if ("softwareversion".equalsIgnoreCase(objOption.getOpt())) {
                m_strSoftwareVersion = objOption.getValue();
            }
            MUU_Object.setProperty(objOption.getOpt(), objOption.getValue());
        }
    }
}

