/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.migration.sdw.taskdefs;

import com.sas.apps.migration.sdw.taskdefs.MessageBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MergeProperties
extends Task {
    private File mergeFile;
    private File importFile;
    private File destFile;

    public void execute() throws BuildException {
        this.validate();
        Properties props = new Properties();
        Properties newProps = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.mergeFile);
            FileInputStream in2 = new FileInputStream(this.importFile);
            try {
                props.load(in);
                newProps.load(in2);
                Enumeration<?> enumProps = newProps.propertyNames();
                while (enumProps.hasMoreElements()) {
                    String key = (String)enumProps.nextElement();
                    props.setProperty(key, newProps.getProperty(key));
                }
                props.store(new FileOutputStream(this.destFile), null);
            }
            catch (Exception e) {
                throw new BuildException("Could not read file.", (Throwable)e);
            }
            finally {
                ((InputStream)in).close();
                ((InputStream)in2).close();
            }
        }
        catch (IOException IOe) {
            throw new BuildException("Could not read file.", (Throwable)IOe);
        }
    }

    private void validate() throws BuildException {
        if (!this.importFile.canRead()) {
            String message = MessageBundle.getString("MergeProperties.UnableToReadFrom.fmt.log", new String[]{this.importFile.getAbsolutePath()});
            throw new BuildException(message);
        }
        if (!this.mergeFile.canRead()) {
            String message = MessageBundle.getString("MergeProperties.UnableToReadFrom.fmt.log", new String[]{this.importFile.getAbsolutePath()});
            throw new BuildException(message);
        }
        if (!this.destFile.exists()) {
            try {
                this.destFile.createNewFile();
            }
            catch (IOException e) {
                throw new BuildException("Could not create " + this.destFile + ".");
            }
        }
    }

    public void setFile(File file) {
        this.mergeFile = file;
    }

    public void setImportFile(File file) {
        this.importFile = file;
    }

    public void setToFile(File file) {
        this.destFile = file;
    }
}

