/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.configuration.Links;

@Experimental
public class ClusterManagementResult {
    private StatusCode statusCode = StatusCode.OK;
    private String statusMessage;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private Links links;

    public ClusterManagementResult() {
    }

    public ClusterManagementResult(StatusCode statusCode, String message) {
        this.setStatus(statusCode, message);
    }

    public ClusterManagementResult(ClusterManagementResult copyFrom) {
        this.statusCode = copyFrom.statusCode;
        this.statusMessage = copyFrom.statusMessage;
        this.links = copyFrom.links;
    }

    public void setStatus(StatusCode statusCode, String message) {
        this.statusCode = statusCode;
        this.statusMessage = ClusterManagementResult.formatErrorMessage(message);
    }

    private static String formatErrorMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        char firstChar = ((String)(message = ((String)message).trim())).charAt(0);
        char newFirstChar = Character.toUpperCase(firstChar);
        if (newFirstChar != firstChar) {
            message = newFirstChar + ((String)message).substring(1);
        }
        if (!(((String)message).endsWith(".") || ((String)message).endsWith("!") || ((String)message).endsWith("?"))) {
            message = (String)message + ".";
        }
        return message;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return this.statusCode == StatusCode.OK || this.statusCode == StatusCode.ACCEPTED || this.statusCode == StatusCode.IN_PROGRESS;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        if (StringUtils.isBlank((CharSequence)this.getStatusMessage())) {
            return this.getStatusCode().toString();
        }
        return String.valueOf((Object)this.getStatusCode()) + ": " + this.getStatusMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterManagementResult that = (ClusterManagementResult)o;
        return this.statusCode == that.statusCode && Objects.equals(this.statusMessage, that.statusMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statusCode, this.statusMessage});
    }

    public static enum StatusCode {
        OK,
        ILLEGAL_ARGUMENT,
        UNAUTHENTICATED,
        UNAUTHORIZED,
        ENTITY_EXISTS,
        ENTITY_NOT_FOUND,
        ERROR,
        FAIL_TO_PERSIST,
        ACCEPTED,
        IN_PROGRESS;

    }
}

