/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.session;

import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.NodeIdFactory;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.ObservationManagerImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.session.SessionState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.value.ValueFactoryImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;

public class SessionContext
implements NamePathResolver {
    private final RepositoryContext repositoryContext;
    private final SessionImpl session;
    private final SessionState state;
    private final ValueFactory valueFactory;
    private final ItemValidator itemValidator;
    private final NodeTypeManagerImpl nodeTypeManager;
    private final PrivilegeManagerImpl privilegeManager;
    private final NamespaceRegistry nsRegistry;
    private final WorkspaceImpl workspace;
    private volatile SessionItemStateManager itemStateManager;
    private volatile ItemManager itemManager;
    private volatile AccessManager accessManager;
    private volatile ObservationManagerImpl observationManager;

    public SessionContext(RepositoryContext repositoryContext, SessionImpl session, WorkspaceConfig workspaceConfig) throws RepositoryException {
        assert (repositoryContext != null);
        assert (session != null);
        this.repositoryContext = repositoryContext;
        this.session = session;
        this.state = new SessionState(this);
        this.valueFactory = new ValueFactoryImpl(session, repositoryContext.getDataStore());
        this.itemValidator = new ItemValidator(this);
        this.nodeTypeManager = new NodeTypeManagerImpl(this);
        this.privilegeManager = new PrivilegeManagerImpl(repositoryContext.getPrivilegeRegistry(), (NameResolver)session);
        this.nsRegistry = new PermissionAwareNamespaceRegistry();
        this.workspace = this.createWorkspaceImpl(this, workspaceConfig);
    }

    protected WorkspaceImpl createWorkspaceImpl(SessionContext sessionContext, WorkspaceConfig wspConfig) throws RepositoryException {
        return new WorkspaceImpl(sessionContext, wspConfig);
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public RepositoryImpl getRepository() {
        return this.repositoryContext.getRepository();
    }

    public NodeId getRootNodeId() {
        return this.repositoryContext.getRootNodeId();
    }

    public DataStore getDataStore() {
        return this.repositoryContext.getDataStore();
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.repositoryContext.getNodeTypeRegistry();
    }

    public SessionImpl getSessionImpl() {
        return this.session;
    }

    public SessionState getSessionState() {
        return this.state;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public ItemValidator getItemValidator() {
        return this.itemValidator;
    }

    public NodeTypeManagerImpl getNodeTypeManager() {
        return this.nodeTypeManager;
    }

    public PrivilegeManagerImpl getPrivilegeManager() {
        return this.privilegeManager;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.nsRegistry;
    }

    public WorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    public SessionItemStateManager getItemStateManager() {
        assert (this.itemStateManager != null);
        return this.itemStateManager;
    }

    public void setItemStateManager(SessionItemStateManager itemStateManager) {
        assert (itemStateManager != null);
        this.itemStateManager = itemStateManager;
    }

    public HierarchyManager getHierarchyManager() {
        assert (this.itemStateManager != null);
        return this.itemStateManager.getHierarchyMgr();
    }

    public ItemManager getItemManager() {
        assert (this.itemManager != null);
        return this.itemManager;
    }

    public void setItemManager(ItemManager itemManager) {
        assert (itemManager != null);
        this.itemManager = itemManager;
    }

    public AccessManager getAccessManager() {
        assert (this.accessManager != null);
        return this.accessManager;
    }

    public void setAccessManager(AccessManager accessManager) {
        assert (accessManager != null);
        this.accessManager = accessManager;
    }

    public ObservationManagerImpl getObservationManager() {
        assert (this.observationManager != null);
        return this.observationManager;
    }

    public void setObservationManager(ObservationManagerImpl observationManager) {
        assert (observationManager != null);
        this.observationManager = observationManager;
    }

    public NodeIdFactory getNodeIdFactory() {
        return this.repositoryContext.getNodeIdFactory();
    }

    public Name getQName(String name) throws IllegalNameException, NamespaceException {
        return this.session.getQName(name);
    }

    public String getJCRName(Name name) throws NamespaceException {
        return this.session.getJCRName(name);
    }

    public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.session.getQPath(path);
    }

    public Path getQPath(String path, boolean normalizeIdentifier) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.session.getQPath(path, normalizeIdentifier);
    }

    public String getJCRPath(Path path) throws NamespaceException {
        return this.session.getJCRPath(path);
    }

    public String toString() {
        return (Object)((Object)this.session) + ":\n" + this.itemManager + "\n" + this.itemStateManager;
    }

    private class PermissionAwareNamespaceRegistry
    implements NamespaceRegistry {
        private final NamespaceRegistry nsRegistry;

        private PermissionAwareNamespaceRegistry() {
            this.nsRegistry = SessionContext.this.repositoryContext.getNamespaceRegistry();
        }

        public void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
            SessionContext.this.session.getAccessManager().checkRepositoryPermission(16384);
            this.nsRegistry.registerNamespace(prefix, uri);
        }

        public void unregisterNamespace(String prefix) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
            SessionContext.this.session.getAccessManager().checkRepositoryPermission(16384);
            this.nsRegistry.unregisterNamespace(prefix);
        }

        public String[] getPrefixes() throws RepositoryException {
            return this.nsRegistry.getPrefixes();
        }

        public String[] getURIs() throws RepositoryException {
            return this.nsRegistry.getURIs();
        }

        public String getURI(String prefix) throws NamespaceException, RepositoryException {
            return this.nsRegistry.getURI(prefix);
        }

        public String getPrefix(String uri) throws NamespaceException, RepositoryException {
            return this.nsRegistry.getPrefix(uri);
        }
    }
}

