/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.AccessControlObserver;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.Entry;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCollector
extends AccessControlObserver
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(EntryCollector.class);
    protected final SessionImpl systemSession;
    protected final NodeId rootID;
    private final EventListener moveListener;

    protected EntryCollector(SessionImpl systemSession, NodeId rootID) throws RepositoryException {
        this.systemSession = systemSession;
        this.rootID = rootID;
        ObservationManager observationMgr = systemSession.getWorkspace().getObservationManager();
        int events = 19;
        String[] ntNames = new String[]{systemSession.getJCRName(NT_REP_ACCESS_CONTROLLABLE), systemSession.getJCRName(NT_REP_ACL), systemSession.getJCRName(NT_REP_ACE)};
        String rootPath = systemSession.getRootNode().getPath();
        observationMgr.addEventListener((EventListener)this, events, rootPath, true, null, ntNames, true);
        this.moveListener = new MoveListener();
        observationMgr.addEventListener(this.moveListener, 32, rootPath, true, null, null, true);
    }

    @Override
    protected void close() {
        super.close();
        try {
            ObservationManager observationMgr = this.systemSession.getWorkspace().getObservationManager();
            observationMgr.removeEventListener((EventListener)this);
            observationMgr.removeEventListener(this.moveListener);
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while closing CachingEntryCollector", (Throwable)e);
        }
    }

    protected List<Entry> collectEntries(NodeImpl node, EntryFilter filter) throws RepositoryException {
        LinkedList<Entry> userAces = new LinkedList<Entry>();
        LinkedList<Entry> groupAces = new LinkedList<Entry>();
        if (node == null) {
            NodeImpl root = (NodeImpl)this.systemSession.getRootNode();
            if (ACLProvider.isRepoAccessControlled(root)) {
                NodeImpl aclNode = root.getNode(N_REPO_POLICY);
                EntryCollector.filterEntries(filter, Entry.readEntries(aclNode, null), userAces, groupAces);
            }
        } else {
            EntryCollector.filterEntries(filter, this.getEntries(node).getACEs(), userAces, groupAces);
            NodeId next = node.getParentId();
            while (next != null) {
                Entries entries = this.getEntries(next);
                EntryCollector.filterEntries(filter, entries.getACEs(), userAces, groupAces);
                next = entries.getNextId();
            }
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(userAces.size() + groupAces.size());
        entries.addAll(userAces);
        entries.addAll(groupAces);
        return entries;
    }

    protected static void filterEntries(EntryFilter filter, List<Entry> aces, LinkedList<Entry> userAces, LinkedList<Entry> groupAces) {
        if (!aces.isEmpty() && filter != null) {
            filter.filterEntries(aces, userAces, groupAces);
        }
    }

    protected Entries getEntries(NodeImpl node) throws RepositoryException {
        List<Entry> aces;
        if (ACLProvider.isAccessControlled(node)) {
            NodeImpl aclNode = node.getNode(N_POLICY);
            aces = Entry.readEntries(aclNode, node.getPath());
        } else {
            aces = Collections.emptyList();
        }
        return new Entries(aces, node.getParentId());
    }

    protected Entries getEntries(NodeId nodeId) throws RepositoryException {
        NodeImpl node = this.getNodeById(nodeId);
        return this.getEntries(node);
    }

    NodeImpl getNodeById(NodeId nodeId) throws RepositoryException {
        return (NodeImpl)this.systemSession.getItemManager().getItem(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        try {
            String workspaceName = this.systemSession.getWorkspace().getName();
            Session session = this.systemSession.createSession(workspaceName);
            try {
                ACLEventSieve sieve = new ACLEventSieve(session, (NameResolver)session);
                sieve.siftEvents(events);
                AccessControlModifications<NodeId> mods = sieve.getModifications();
                if (!mods.getNodeIdentifiers().isEmpty()) {
                    this.notifyListeners(mods);
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to process access control modifications", (Throwable)e);
        }
    }

    private class MoveListener
    implements SynchronousEventListener {
        private MoveListener() {
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                if (event.getType() != 32) continue;
                Map<NodeId, Integer> m = Collections.singletonMap(EntryCollector.this.rootID, 8);
                AccessControlModifications<NodeId> mods = new AccessControlModifications<NodeId>(m);
                EntryCollector.this.notifyListeners(mods);
                break;
            }
        }
    }

    protected static class Entries {
        private final List<Entry> aces;
        private NodeId nextId;

        Entries(List<Entry> aces, NodeId nextId) {
            this.aces = aces;
            this.nextId = nextId;
        }

        public List<Entry> getACEs() {
            return this.aces;
        }

        NodeId getNextId() {
            return this.nextId;
        }

        void setNextId(NodeId nextId) {
            this.nextId = nextId;
        }

        boolean isEmpty() {
            return this.aces.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size = ").append(this.aces.size()).append(", ");
            sb.append("nextNodeId = ").append(this.nextId);
            return sb.toString();
        }
    }

    protected static class ACLEventSieve {
        private final Session session;
        private final String repPolicyName;
        private final Map<NodeId, Integer> modMap = new HashMap<NodeId, Integer>();

        public ACLEventSieve(Session session, NameResolver resolver) throws RepositoryException {
            this.session = session;
            this.repPolicyName = resolver.getJCRName(AccessControlConstants.N_POLICY);
        }

        public void siftEvents(EventIterator events) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    switch (event.getType()) {
                        case 1: {
                            this.siftNodeAdded(event.getIdentifier());
                            break;
                        }
                        case 2: {
                            this.siftNodeRemoved(event.getPath());
                            break;
                        }
                        case 16: {
                            this.siftPropertyChanged(event.getIdentifier());
                            break;
                        }
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Failed to process ACL event: " + event, (Throwable)e);
                }
            }
        }

        public AccessControlModifications<NodeId> getModifications() {
            return new AccessControlModifications<NodeId>(this.modMap);
        }

        private void siftNodeAdded(String identifier) throws RepositoryException {
            try {
                NodeImpl n = (NodeImpl)this.session.getNodeByIdentifier(identifier);
                if (n.isNodeType(NT_REP_ACL)) {
                    this.addModification(this.accessControlledIdFromAclNode(n), 1);
                } else if (n.isNodeType(NT_REP_ACE)) {
                    this.addModification(this.accessControlledIdFromAceNode(n), 4);
                }
            }
            catch (ItemNotFoundException e) {
                log.debug("Cannot process NODE_ADDED event. Node {} doesn't exist (anymore).", (Object)identifier);
            }
        }

        private void siftNodeRemoved(String path) throws RepositoryException {
            String parentPath = Text.getRelativeParent((String)path, (int)1);
            if (this.session.nodeExists(parentPath)) {
                NodeImpl parent = (NodeImpl)this.session.getNode(parentPath);
                if (this.repPolicyName.equals(Text.getName((String)path))) {
                    this.addModification(parent.getNodeId(), 2);
                } else if (parent.isNodeType(NT_REP_ACL)) {
                    this.addModification(this.accessControlledIdFromAclNode(parent), 4);
                }
            } else {
                log.debug("Cannot process NODE_REMOVED event. Parent {} doesn't exist (anymore).", (Object)parentPath);
            }
        }

        private void siftPropertyChanged(String identifier) throws RepositoryException {
            try {
                NodeImpl parent = (NodeImpl)this.session.getNodeByIdentifier(identifier);
                if (parent.isNodeType(NT_REP_ACE)) {
                    this.addModification(this.accessControlledIdFromAceNode(parent), 4);
                }
            }
            catch (ItemNotFoundException e) {
                log.debug("Cannot process PROPERTY_CHANGED event. Node {} doesn't exist (anymore).", (Object)identifier);
            }
        }

        private NodeId accessControlledIdFromAclNode(Node aclNode) throws RepositoryException {
            return ((NodeImpl)aclNode.getParent()).getNodeId();
        }

        private NodeId accessControlledIdFromAceNode(Node aceNode) throws RepositoryException {
            return this.accessControlledIdFromAclNode(aceNode.getParent());
        }

        private void addModification(NodeId accessControllNodeId, int modType) {
            if (this.modMap.containsKey(accessControllNodeId)) {
                modType |= this.modMap.get(accessControllNodeId).intValue();
            }
            this.modMap.put(accessControllNodeId, modType);
        }
    }
}

