/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.CachingMultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheck;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexHistory;
import org.apache.jackrabbit.core.query.lucene.IndexInfo;
import org.apache.jackrabbit.core.query.lucene.IndexInfos;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.IndexMerger;
import org.apache.jackrabbit.core.query.lucene.IndexingQueue;
import org.apache.jackrabbit.core.query.lucene.IndexingQueueStore;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.PersistentIndex;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.Recovery;
import org.apache.jackrabbit.core.query.lucene.RedoLog;
import org.apache.jackrabbit.core.query.lucene.RedoLogFactory;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.VolatileIndex;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiIndex {
    private static final Logger log = LoggerFactory.getLogger(MultiIndex.class);
    private static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();
    private final IndexInfos indexNames;
    private final IndexHistory indexHistory;
    private final Map<String, Long> deletable = new HashMap<String, Long>();
    private final List<PersistentIndex> indexes = new ArrayList<PersistentIndex>();
    private final NamespaceMappings nsMappings;
    private final DirectoryManager directoryManager;
    private final RedoLogFactory redoLogFactory;
    private final Directory indexDir;
    private final SearchIndex handler;
    private VolatileIndex volatileIndex;
    private boolean updateInProgress = false;
    private CachingMultiIndexReader multiReader;
    private final DocNumberCache cache;
    private final Object updateMonitor = new Object();
    private boolean redoLogApplied = false;
    private long lastFlushTime = 0L;
    private final IndexMerger merger;
    private ScheduledFuture<?> flushTask = null;
    private RedoLog redoLog;
    private IndexingQueue indexingQueue;
    private boolean indexingQueueCommitPending;
    private final Set<NodeId> excludedIDs;
    private long nextTransactionId = 0L;
    private long currentTransactionId = -1L;
    private boolean reindexing = false;
    private final IndexFormatVersion version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiIndex(SearchIndex handler, Set<NodeId> excludedIDs) throws IOException {
        this.directoryManager = handler.getDirectoryManager();
        this.redoLogFactory = handler.getRedoLogFactory();
        this.indexDir = this.directoryManager.getDirectory(".");
        this.handler = handler;
        this.cache = new DocNumberCache(handler.getCacheSize());
        this.excludedIDs = new HashSet<NodeId>(excludedIDs);
        this.nsMappings = handler.getNamespaceMappings();
        this.indexNames = new IndexInfos(this.indexDir, "indexes");
        this.indexHistory = new IndexHistory(this.indexDir, handler.getMaxHistoryAge() * 1000L);
        this.removeDeletable();
        this.redoLog = this.redoLogFactory.createRedoLog(this);
        this.merger = new IndexMerger(this, handler.getContext().getExecutor());
        this.merger.setMaxMergeDocs(handler.getMaxMergeDocs());
        this.merger.setMergeFactor(handler.getMergeFactor());
        this.merger.setMinMergeDocs(handler.getMinMergeDocs());
        this.indexingQueue = new IndexingQueue(new IndexingQueueStore(this.indexDir));
        Iterator<IndexInfo> iterator = this.indexNames.iterator();
        while (iterator.hasNext()) {
            IndexInfo info = iterator.next();
            String name = info.getName();
            if (!this.directoryManager.hasDirectory(name)) {
                log.debug("index does not exist anymore: " + name);
                continue;
            }
            PersistentIndex index = new PersistentIndex(name, handler.getTextAnalyzer(), handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager, handler.getMaxHistoryAge());
            index.setUseCompoundFile(handler.getUseCompoundFile());
            index.setTermInfosIndexDivisor(handler.getTermInfosIndexDivisor());
            this.indexes.add(index);
            this.merger.indexAdded(index.getName(), index.getNumDocuments());
        }
        this.resetVolatileIndex();
        CachingMultiIndexReader reader = this.getIndexReader(handler.isInitializeHierarchyCache());
        try {
            this.version = IndexFormatVersion.getVersion((IndexReader)reader);
        }
        finally {
            reader.release();
        }
        this.indexingQueue.initialize(this);
        this.redoLogApplied = this.redoLog.hasEntries();
        Recovery.run(this, this.redoLog);
        this.enqueueUnusedSegments();
        this.attemptDelete();
        this.merger.start();
        if (this.redoLogApplied) {
            try {
                this.merger.waitUntilIdle();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.flush();
        }
        if (this.indexNames.size() > 0) {
            this.scheduleFlushTask();
        }
    }

    int numDocs() throws IOException {
        if (this.indexNames.size() == 0) {
            return this.volatileIndex.getNumDocuments();
        }
        CachingMultiIndexReader reader = this.getIndexReader();
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.release();
        }
    }

    IndexFormatVersion getIndexFormatVersion() {
        return this.version;
    }

    void createInitialIndex(ItemStateManager stateMgr, NodeId rootId, Path rootPath) throws IOException {
        if (this.indexNames.size() == 0) {
            this.reindexing = true;
            try {
                long count = 0L;
                this.executeAndLog(new Start(-1L));
                NodeState rootState = (NodeState)stateMgr.getItemState(rootId);
                count = this.createIndex(rootState, rootPath, stateMgr, count);
                this.checkIndexingQueue(true);
                this.executeAndLog(new Commit(this.getTransactionId()));
                log.debug("Created initial index for {} nodes", (Object)count);
                this.releaseMultiReader();
                this.safeFlush();
            }
            catch (Exception e) {
                String msg = "Error indexing workspace";
                IOException ex = new IOException(msg);
                ex.initCause(e);
                throw ex;
            }
            finally {
                this.reindexing = false;
                this.scheduleFlushTask();
            }
        } else {
            throw new IllegalStateException("Index already present");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void update(Collection<NodeId> remove, Collection<Document> add) throws IOException {
        if (add.size() > this.handler.getBufferSize()) {
            try {
                this.getIndexReader().release();
            }
            catch (IOException e) {
                log.warn("unable to prepare index reader for queries during update", (Throwable)e);
            }
        }
        Object e = this.updateMonitor;
        synchronized (e) {
            this.updateInProgress = true;
        }
        try {
            long transactionId = this.nextTransactionId++;
            this.executeAndLog(new Start(transactionId));
            long time = System.currentTimeMillis();
            for (NodeId id : remove) {
                this.executeAndLog(new DeleteNode(transactionId, id));
            }
            time = System.currentTimeMillis() - time;
            log.debug("{} documents deleted in {}ms", (Object)remove.size(), (Object)time);
            time = System.currentTimeMillis();
            for (Document document : add) {
                if (document == null) continue;
                this.executeAndLog(new AddNode(transactionId, document));
                this.checkVolatileCommit();
            }
            time = System.currentTimeMillis() - time;
            log.debug("{} documents added in {}ms", (Object)add.size(), (Object)time);
            this.executeAndLog(new Commit(transactionId));
        }
        finally {
            Object object = this.updateMonitor;
            synchronized (object) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
        }
    }

    void addDocument(Document doc) throws IOException {
        List<NodeId> empty = Collections.emptyList();
        this.update(empty, Collections.singleton(doc));
    }

    void removeDocument(NodeId id) throws IOException {
        List<Document> empty = Collections.emptyList();
        this.update(Collections.singleton(id), empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int removeAllDocuments(NodeId id) throws IOException {
        int num;
        Object object = this.updateMonitor;
        synchronized (object) {
            this.updateInProgress = true;
        }
        try {
            Term idTerm = TermFactory.createUUIDTerm(id.toString());
            this.executeAndLog(new Start(-1L));
            num = this.volatileIndex.removeDocument(idTerm);
            if (num > 0) {
                this.redoLog.append(new DeleteNode(this.getTransactionId(), id));
            }
            for (PersistentIndex index : this.indexes) {
                if (!this.indexNames.contains(index.getName())) continue;
                int removed = index.removeDocument(idTerm);
                if (removed > 0) {
                    this.redoLog.append(new DeleteNode(this.getTransactionId(), id));
                }
                num += removed;
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
        }
        finally {
            Object object2 = this.updateMonitor;
            synchronized (object2) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
        }
        return num;
    }

    synchronized IndexReader[] getIndexReaders(String[] indexNames, IndexListener listener) throws IOException {
        HashSet<String> names = new HashSet<String>(Arrays.asList(indexNames));
        HashMap<ReadOnlyIndexReader, PersistentIndex> indexReaders = new HashMap<ReadOnlyIndexReader, PersistentIndex>();
        try {
            for (PersistentIndex index : this.indexes) {
                if (!names.contains(index.getName())) continue;
                indexReaders.put(index.getReadOnlyIndexReader(listener), index);
            }
        }
        catch (IOException e) {
            for (Map.Entry entry : indexReaders.entrySet()) {
                try {
                    ((ReadOnlyIndexReader)entry.getKey()).release();
                }
                catch (IOException ex) {
                    log.warn("Exception releasing index reader", (Throwable)ex);
                }
                ((PersistentIndex)entry.getValue()).resetListener();
            }
            throw e;
        }
        return indexReaders.keySet().toArray(new IndexReader[indexReaders.size()]);
    }

    synchronized PersistentIndex getOrCreateIndex(String indexName) throws IOException {
        PersistentIndex index;
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return idx;
        }
        if (indexName == null) {
            while (this.directoryManager.hasDirectory(indexName = this.indexNames.newName())) {
            }
        }
        try {
            index = new PersistentIndex(indexName, this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager, this.handler.getMaxHistoryAge());
        }
        catch (IOException e) {
            if (!this.directoryManager.delete(indexName)) {
                this.deletable.put(indexName, Long.MIN_VALUE);
            }
            throw e;
        }
        index.setUseCompoundFile(this.handler.getUseCompoundFile());
        index.setTermInfosIndexDivisor(this.handler.getTermInfosIndexDivisor());
        this.indexes.add(index);
        return index;
    }

    synchronized boolean hasIndex(String indexName) throws IOException {
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return true;
        }
        return this.directoryManager.hasDirectory(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceIndexes(String[] obsoleteIndexes, PersistentIndex index, Collection<Term> deleted) throws IOException {
        if (this.handler.isInitializeHierarchyCache()) {
            long time = System.currentTimeMillis();
            index.getReadOnlyIndexReader(true).release();
            time = System.currentTimeMillis() - time;
            log.debug("hierarchy cache initialized in {} ms", (Object)time);
        }
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            Object object = this.updateMonitor;
            synchronized (object) {
                this.updateInProgress = true;
            }
            try {
                if (!this.reindexing) {
                    this.executeAndLog(new Start(-2L));
                }
                HashSet<String> names = new HashSet<String>(Arrays.asList(obsoleteIndexes));
                for (String indexName : names) {
                    if (!this.indexNames.contains(indexName)) continue;
                    this.executeAndLog(new DeleteIndex(this.getTransactionId(), indexName));
                }
                this.executeAndLog(new CreateIndex(this.getTransactionId(), index.getName()));
                this.executeAndLog(new AddIndex(this.getTransactionId(), index.getName()));
                for (Term id : deleted) {
                    index.removeDocument(id);
                }
                index.commit();
                if (!this.reindexing) {
                    this.executeAndLog(new Commit(this.getTransactionId()));
                }
            }
            finally {
                object = this.updateMonitor;
                synchronized (object) {
                    this.updateInProgress = false;
                    this.updateMonitor.notifyAll();
                    this.releaseMultiReader();
                }
            }
        }
        if (this.reindexing) {
            this.attemptDelete();
        }
    }

    public CachingMultiIndexReader getIndexReader() throws IOException {
        return this.getIndexReader(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CachingMultiIndexReader getIndexReader(boolean initCache) throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            if (this.multiReader != null) {
                this.multiReader.acquire();
                return this.multiReader;
            }
            while (this.updateInProgress) {
                try {
                    this.updateMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while waiting to aquire reader");
                }
            }
            if (this.multiReader == null) {
                ArrayList<ReadOnlyIndexReader> readerList = new ArrayList<ReadOnlyIndexReader>();
                for (PersistentIndex pIdx : this.indexes) {
                    if (!this.indexNames.contains(pIdx.getName())) continue;
                    readerList.add(pIdx.getReadOnlyIndexReader(initCache));
                }
                readerList.add(this.volatileIndex.getReadOnlyIndexReader());
                ReadOnlyIndexReader[] readers = readerList.toArray(new ReadOnlyIndexReader[readerList.size()]);
                this.multiReader = new CachingMultiIndexReader(readers, this.cache);
            }
            this.multiReader.acquire();
            return this.multiReader;
        }
    }

    VolatileIndex getVolatileIndex() {
        return this.volatileIndex;
    }

    ConsistencyCheck runConsistencyCheck() throws IOException {
        return ConsistencyCheck.run(this, this.handler, this.excludedIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.merger.dispose();
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            this.unscheduleFlushTask();
            try {
                this.releaseMultiReader();
            }
            catch (IOException e) {
                log.error("Exception while closing search index.", (Throwable)e);
            }
            try {
                this.flush();
            }
            catch (IOException e) {
                log.error("Exception while closing search index.", (Throwable)e);
            }
            this.volatileIndex.close();
            for (PersistentIndex index : this.indexes) {
                index.close();
            }
            this.indexingQueue.close();
            try {
                this.indexDir.close();
            }
            catch (IOException e) {
                log.error("Exception while closing directory.", (Throwable)e);
            }
        }
    }

    NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    IndexingQueue getIndexingQueue() {
        return this.indexingQueue;
    }

    Directory getDirectory() {
        return this.indexDir;
    }

    long getIndexGeneration() {
        return this.indexNames.getGeneration();
    }

    Document createDocument(NodeState node) throws RepositoryException {
        return this.handler.createDocument(node, this.nsMappings, this.version);
    }

    Document createDocument(NodeId id) throws RepositoryException {
        try {
            NodeState state = (NodeState)this.handler.getContext().getItemStateManager().getItemState(id);
            return this.createDocument(state);
        }
        catch (NoSuchItemStateException e) {
            throw new RepositoryException("Node " + id + " does not exist", (Throwable)e);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Error retrieving node: " + id, (Throwable)e);
        }
    }

    boolean getRedoLogApplied() {
        return this.redoLogApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteIndex(PersistentIndex index) {
        this.indexes.remove(index);
        this.indexNames.removeName(index.getName());
        Map<String, Long> map = this.deletable;
        synchronized (map) {
            log.debug("Moved " + index.getName() + " to deletable");
            this.deletable.put(index.getName(), System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws IOException {
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            boolean transactionStarted = false;
            if (this.volatileIndex.getNumDocuments() > 0) {
                this.executeAndLog(new Start(-1L));
                transactionStarted = true;
                this.commitVolatileIndex();
            }
            boolean indexesModified = false;
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                PersistentIndex index = this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                long gen = index.getCurrentGeneration();
                index.commit();
                if (gen != index.getCurrentGeneration()) {
                    indexesModified = true;
                    log.debug("Committed revision {} of index {}", (Object)Long.toString(index.getCurrentGeneration(), 36), (Object)index.getName());
                }
                if (index.getNumDocuments() != 0) continue;
                if (!transactionStarted) {
                    this.executeAndLog(new Start(-1L));
                    transactionStarted = true;
                }
                this.executeAndLog(new DeleteIndex(this.getTransactionId(), index.getName()));
            }
            if (transactionStarted) {
                this.executeAndLog(new Commit(this.getTransactionId()));
            }
            if (transactionStarted || indexesModified || this.redoLog.hasEntries()) {
                this.indexNames.write();
                this.indexHistory.addIndexInfos(this.indexNames);
                this.redoLog.close();
                this.redoLog = this.redoLogFactory.createRedoLog(this);
            }
            this.lastFlushTime = System.currentTimeMillis();
        }
        this.indexHistory.pruneOutdated();
        this.attemptDelete();
    }

    public void releaseMultiReader() throws IOException {
        if (this.multiReader != null) {
            try {
                this.multiReader.release();
            }
            finally {
                this.multiReader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilIndexingQueueIsEmpty() {
        IndexingQueue iq;
        IndexingQueue indexingQueue = iq = this.getIndexingQueue();
        synchronized (indexingQueue) {
            while (iq.getNumPendingDocuments() > 0 || this.indexingQueueCommitPending) {
                try {
                    log.debug("waiting for indexing queue to become empty. {} pending docs.", (Object)iq.getNumPendingDocuments());
                    iq.wait();
                    log.debug("notified");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyIfIndexingQueueIsEmpty() {
        IndexingQueue iq;
        IndexingQueue indexingQueue = iq = this.getIndexingQueue();
        synchronized (indexingQueue) {
            this.indexingQueueCommitPending = false;
            if (iq.getNumPendingDocuments() == 0) {
                iq.notifyAll();
            }
        }
    }

    private void enqueueUnusedSegments() throws IOException {
        for (String name : this.directoryManager.getDirectoryNames()) {
            long lastUse;
            if (!name.startsWith("_") || (lastUse = this.indexHistory.getLastUseOf(name)) == Long.MAX_VALUE) continue;
            if (log.isDebugEnabled()) {
                String msg = "Segment " + name + " not is use anymore. ";
                if (lastUse != Long.MIN_VALUE) {
                    Calendar cal = Calendar.getInstance();
                    DateFormat df = DateFormat.getInstance();
                    cal.setTimeInMillis(lastUse);
                    msg = msg + "Unused since: " + df.format(cal.getTime());
                } else {
                    msg = msg + "(orphaned)";
                }
                log.debug(msg);
            }
            this.deletable.put(name, lastUse);
        }
        this.indexHistory.pruneOutdated();
    }

    public void scheduleFlushTask() {
        ScheduledExecutorService executor = this.handler.getContext().getExecutor();
        this.flushTask = executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MultiIndex.this.checkIndexingQueue(false);
                MultiIndex.this.checkFlush();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void unscheduleFlushTask() {
        if (this.flushTask != null) {
            this.flushTask.cancel(false);
            this.flushTask = null;
        }
    }

    private void resetVolatileIndex() throws IOException {
        if (this.volatileIndex != null) {
            this.volatileIndex.close();
        }
        this.volatileIndex = new VolatileIndex(this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.indexingQueue);
        this.volatileIndex.setUseCompoundFile(this.handler.getUseCompoundFile());
        this.volatileIndex.setBufferSize(this.handler.getBufferSize());
    }

    public long getTransactionId() {
        return this.currentTransactionId;
    }

    public Action executeAndLog(Action a) throws IOException {
        a.execute(this);
        this.redoLog.append(a);
        if (a.getType() == 3 || a.getType() == 6) {
            this.redoLog.flush();
        }
        return a;
    }

    private boolean checkVolatileCommit() throws IOException {
        if (this.volatileIndex.getRamSizeInBytes() >= this.handler.getMaxVolatileIndexSize()) {
            this.commitVolatileIndex();
            return true;
        }
        return false;
    }

    private void commitVolatileIndex() throws IOException {
        int volatileIndexDocuments = this.volatileIndex.getNumDocuments();
        if (volatileIndexDocuments > 0) {
            long time = System.currentTimeMillis();
            CreateIndex create = new CreateIndex(this.getTransactionId(), null);
            this.executeAndLog(create);
            this.executeAndLog(new VolatileCommit(this.getTransactionId(), create.getIndexName()));
            AddIndex add = new AddIndex(this.getTransactionId(), create.getIndexName());
            this.executeAndLog(add);
            this.resetVolatileIndex();
            time = System.currentTimeMillis() - time;
            log.debug("Committed in-memory index containing {} documents in {}ms.", (Object)volatileIndexDocuments, (Object)time);
        }
    }

    public long createIndex(NodeState node, Path path, ItemStateManager stateMgr, long count) throws IOException, ItemStateException, RepositoryException {
        NodeId id = node.getNodeId();
        if (this.excludedIDs.contains(id)) {
            return count;
        }
        this.executeAndLog(new AddNode(this.getTransactionId(), id));
        if (++count % 100L == 0L) {
            DefaultNamePathResolver resolver = new DefaultNamePathResolver((NamespaceRegistry)this.handler.getContext().getNamespaceRegistry());
            log.info("indexing... {} ({})", (Object)resolver.getJCRPath(path), (Object)count);
        }
        if (count % 10L == 0L) {
            this.checkIndexingQueue(true);
        }
        this.checkVolatileCommit();
        for (ChildNodeEntry child : node.getChildNodeEntries()) {
            Path childPath = PATH_FACTORY.create(path, child.getName(), child.getIndex(), false);
            NodeState childState = null;
            try {
                childState = (NodeState)stateMgr.getItemState(child.getId());
            }
            catch (NoSuchItemStateException e) {
                this.handler.getOnWorkspaceInconsistencyHandler().handleMissingChildNode(e, this.handler, path, node, child);
            }
            catch (ItemStateException e) {
                this.handler.getOnWorkspaceInconsistencyHandler().logError(e, this.handler, childPath, node, child);
            }
            if (childState == null) continue;
            count = this.createIndex(childState, childPath, stateMgr, count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDelete() {
        Map<String, Long> map = this.deletable;
        synchronized (map) {
            Iterator<Map.Entry<String, Long>> it = this.deletable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> entry = it.next();
                String indexName = entry.getKey();
                long lastUse = entry.getValue();
                if (System.currentTimeMillis() - this.handler.getMaxHistoryAge() * 1000L <= lastUse) continue;
                if (this.directoryManager.delete(indexName)) {
                    it.remove();
                    continue;
                }
                log.debug("Unable to delete obsolete index: {}", (Object)indexName);
            }
        }
    }

    private void removeDeletable() {
        String fileName = "deletable";
        try {
            if (this.indexDir.fileExists(fileName)) {
                this.indexDir.deleteFile(fileName);
            }
        }
        catch (IOException e) {
            log.warn("Unable to remove file 'deletable'.", (Throwable)e);
        }
    }

    private synchronized void checkFlush() {
        long idleTime = System.currentTimeMillis() - this.lastFlushTime;
        if (this.handler.getVolatileIdleTime() > 0 && idleTime > (long)(this.handler.getVolatileIdleTime() * 1000)) {
            try {
                if (this.redoLog.hasEntries()) {
                    long time = System.currentTimeMillis();
                    log.debug("Flushing index after being idle for " + idleTime + " ms.");
                    this.safeFlush();
                    time = System.currentTimeMillis() - time;
                    log.debug("Index flushed in " + time + " ms.");
                }
            }
            catch (IOException e) {
                log.error("Unable to commit volatile index", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void safeFlush() throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            this.updateInProgress = true;
        }
        try {
            this.flush();
        }
        finally {
            object = this.updateMonitor;
            synchronized (object) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndexingQueue(boolean transactionPresent) {
        block17: {
            HashMap<NodeId, Document> finished = new HashMap<NodeId, Document>();
            for (Document document : this.indexingQueue.getFinishedDocuments()) {
                NodeId id = new NodeId(document.get(FieldNames.UUID));
                finished.put(id, document);
            }
            if (!finished.isEmpty()) {
                log.debug("updating index with {} nodes from indexing queue.", (Object)finished.size());
                Object object = this.getIndexingQueue();
                synchronized (object) {
                    this.indexingQueueCommitPending = true;
                }
                try {
                    for (NodeId id : finished.keySet()) {
                        this.indexingQueue.removeDocument(id.toString());
                    }
                    try {
                        if (transactionPresent) {
                            object = this;
                            synchronized (object) {
                                for (NodeId id : finished.keySet()) {
                                    this.executeAndLog(new DeleteNode(this.getTransactionId(), id));
                                }
                                for (Document document : finished.values()) {
                                    this.executeAndLog(new AddNode(this.getTransactionId(), document));
                                }
                                break block17;
                            }
                        }
                        this.update(finished.keySet(), finished.values());
                    }
                    catch (IOException e) {
                        log.warn("Failed to update index with deferred text extraction", (Throwable)e);
                    }
                }
                finally {
                    this.notifyIfIndexingQueueIsEmpty();
                }
            }
        }
    }

    public static class Start
    extends Action {
        public Start(long transactionId) {
            super(transactionId, 0);
        }

        static Start fromString(long transactionId, String arguments) {
            return new Start(transactionId);
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            index.currentTransactionId = this.getTransactionId();
        }

        @Override
        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "STR";
        }
    }

    public static abstract class Action {
        static final String START = "STR";
        public static final int TYPE_START = 0;
        static final String ADD_NODE = "ADD";
        public static final int TYPE_ADD_NODE = 1;
        static final String DELETE_NODE = "DEL";
        public static final int TYPE_DELETE_NODE = 2;
        static final String COMMIT = "COM";
        public static final int TYPE_COMMIT = 3;
        static final String VOLATILE_COMMIT = "VOL_COM";
        public static final int TYPE_VOLATILE_COMMIT = 4;
        static final String CREATE_INDEX = "CRE_IDX";
        public static final int TYPE_CREATE_INDEX = 5;
        static final String ADD_INDEX = "ADD_IDX";
        public static final int TYPE_ADD_INDEX = 6;
        static final String DELETE_INDEX = "DEL_IDX";
        public static final int TYPE_DELETE_INDEX = 7;
        public static final long INTERNAL_TRANSACTION = -1L;
        static final long INTERNAL_TRANS_REPL_INDEXES = -2L;
        private final long transactionId;
        private final int type;

        Action(long transactionId, int type) {
            this.transactionId = transactionId;
            this.type = type;
        }

        long getTransactionId() {
            return this.transactionId;
        }

        int getType() {
            return this.type;
        }

        public abstract void execute(MultiIndex var1) throws IOException;

        public void undo(MultiIndex index) throws IOException {
        }

        public abstract String toString();

        static Action fromString(String line) throws IllegalArgumentException {
            Action a;
            long transactionId;
            int endTransIdx = line.indexOf(32);
            if (endTransIdx == -1) {
                throw new IllegalArgumentException(line);
            }
            try {
                transactionId = Long.parseLong(line.substring(0, endTransIdx));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(line);
            }
            int endActionIdx = line.indexOf(32, endTransIdx + 1);
            if (endActionIdx == -1) {
                endActionIdx = line.length();
            }
            String actionLabel = line.substring(endTransIdx + 1, endActionIdx);
            String arguments = "";
            if (endActionIdx + 1 <= line.length()) {
                arguments = line.substring(endActionIdx + 1);
            }
            if (actionLabel.equals(ADD_NODE)) {
                a = AddNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(ADD_INDEX)) {
                a = AddIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(COMMIT)) {
                a = Commit.fromString(transactionId, arguments);
            } else if (actionLabel.equals(CREATE_INDEX)) {
                a = CreateIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_INDEX)) {
                a = DeleteIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_NODE)) {
                a = DeleteNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(START)) {
                a = Start.fromString(transactionId, arguments);
            } else if (actionLabel.equals(VOLATILE_COMMIT)) {
                a = VolatileCommit.fromString(transactionId, arguments);
            } else {
                throw new IllegalArgumentException(line);
            }
            return a;
        }
    }

    public static class Commit
    extends Action {
        public Commit(long transactionId) {
            super(transactionId, 3);
        }

        static Commit fromString(long transactionId, String arguments) {
            return new Commit(transactionId);
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            index.lastFlushTime = System.currentTimeMillis();
        }

        @Override
        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "COM";
        }
    }

    private static class DeleteNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "DEL".length() + new NodeId(0L, 0L).toString().length() + 2;
        private final NodeId id;

        DeleteNode(long transactionId, NodeId id) {
            super(transactionId, 2);
            this.id = id;
        }

        static DeleteNode fromString(long transactionId, String arguments) {
            return new DeleteNode(transactionId, new NodeId(arguments));
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            String uuidString = this.id.toString();
            Document doc = index.indexingQueue.removeDocument(uuidString);
            if (doc != null) {
                Util.disposeDocument(doc);
                index.notifyIfIndexingQueueIsEmpty();
            }
            Term idTerm = TermFactory.createUUIDTerm(uuidString);
            int num = index.volatileIndex.removeDocument(idTerm);
            if (num == 0) {
                for (int i = index.indexes.size() - 1; i >= 0; --i) {
                    PersistentIndex idx = (PersistentIndex)index.indexes.get(i);
                    if (!index.indexNames.contains(idx.getName()) || (num = idx.removeDocument(idTerm)) <= 0) continue;
                    return;
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL");
            logLine.append(' ');
            logLine.append(this.id);
            return logLine.toString();
        }
    }

    private static class AddNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "ADD".length() + new NodeId(0L, 0L).toString().length() + 2;
        private final NodeId id;
        private Document doc;

        AddNode(long transactionId, NodeId id) {
            super(transactionId, 1);
            this.id = id;
        }

        AddNode(long transactionId, Document doc) {
            this(transactionId, new NodeId(doc.get(FieldNames.UUID)));
            this.doc = doc;
        }

        static AddNode fromString(long transactionId, String arguments) throws IllegalArgumentException {
            return new AddNode(transactionId, new NodeId(arguments));
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            if (this.doc == null) {
                try {
                    this.doc = index.createDocument(this.id);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            if (this.doc != null) {
                index.volatileIndex.addDocuments(new Document[]{this.doc});
            }
        }

        @Override
        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD");
            logLine.append(' ');
            logLine.append(this.id);
            return logLine.toString();
        }
    }

    private static class DeleteIndex
    extends Action {
        private String indexName;

        DeleteIndex(long transactionId, String indexName) {
            super(transactionId, 7);
            this.indexName = indexName;
        }

        static DeleteIndex fromString(long transactionId, String arguments) {
            return new DeleteIndex(transactionId, arguments);
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            for (PersistentIndex idx : index.indexes) {
                if (!idx.getName().equals(this.indexName)) continue;
                idx.close();
                index.deleteIndex(idx);
                break;
            }
        }

        @Override
        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    private static class CreateIndex
    extends Action {
        private String indexName;

        CreateIndex(long transactionId, String indexName) {
            super(transactionId, 5);
            this.indexName = indexName;
        }

        static CreateIndex fromString(long transactionId, String arguments) {
            return new CreateIndex(transactionId, arguments);
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            this.indexName = idx.getName();
        }

        @Override
        public void undo(MultiIndex index) throws IOException {
            if (index.hasIndex(this.indexName)) {
                PersistentIndex idx = index.getOrCreateIndex(this.indexName);
                idx.close();
                index.deleteIndex(idx);
            }
        }

        @Override
        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("CRE_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }

        String getIndexName() {
            return this.indexName;
        }
    }

    private static class AddIndex
    extends Action {
        private String indexName;

        AddIndex(long transactionId, String indexName) {
            super(transactionId, 6);
            this.indexName = indexName;
        }

        static AddIndex fromString(long transactionId, String arguments) {
            return new AddIndex(transactionId, arguments);
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            if (!index.indexNames.contains(this.indexName)) {
                index.indexNames.addName(this.indexName, idx.getCurrentGeneration());
                index.merger.indexAdded(this.indexName, idx.getNumDocuments());
            }
        }

        @Override
        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    private static class VolatileCommit
    extends Action {
        private final String targetIndex;

        VolatileCommit(long transactionId, String targetIndex) {
            super(transactionId, 4);
            this.targetIndex = targetIndex;
        }

        static VolatileCommit fromString(long transactionId, String arguments) {
            return new VolatileCommit(transactionId, arguments);
        }

        @Override
        public void execute(MultiIndex index) throws IOException {
            VolatileIndex volatileIndex = index.getVolatileIndex();
            PersistentIndex persistentIndex = index.getOrCreateIndex(this.targetIndex);
            persistentIndex.copyIndex(volatileIndex);
            index.resetVolatileIndex();
        }

        @Override
        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("VOL_COM");
            logLine.append(' ');
            logLine.append(this.targetIndex);
            return logLine.toString();
        }
    }
}

