/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.EmptyTermDocs;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.IDField;
import org.apache.jackrabbit.core.query.lucene.SingleTermDocs;
import org.apache.jackrabbit.core.query.lucene.TermDocsCache;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ReaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingIndexReader
extends FilterIndexReader {
    private static final Logger log = LoggerFactory.getLogger(CachingIndexReader.class);
    private static final int MAX_CACHE_INIT_BATCH_SIZE = 400000;
    private static long currentTick;
    private final BitSet shareableNodes;
    private final int[] inSegmentParents;
    private final Map<Integer, DocId> foreignParentDocIds = new ConcurrentHashMap<Integer, DocId>();
    private final CacheInitializer cacheInitializer;
    private final long creationTick = CachingIndexReader.getNextCreationTick();
    private final DocNumberCache cache;
    private final Map<Integer, NodeId> docNumber2id;
    private final TermDocsCache termDocsCache;

    CachingIndexReader(IndexReader delegatee, DocNumberCache cache, boolean initCache) throws IOException {
        super(delegatee);
        this.cache = cache;
        this.inSegmentParents = new int[delegatee.maxDoc()];
        Arrays.fill(this.inSegmentParents, -1);
        this.shareableNodes = this.initShareableNodes(delegatee);
        this.cacheInitializer = new CacheInitializer(delegatee);
        if (initCache) {
            this.cacheInitializer.run();
        }
        this.docNumber2id = Collections.synchronizedMap(new LRUMap(Math.max(10, delegatee.maxDoc() / 100)));
        this.termDocsCache = new TermDocsCache(delegatee, FieldNames.PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitSet initShareableNodes(IndexReader delegatee) throws IOException {
        BitSet shareableNodes = new BitSet();
        try (TermDocs tDocs = delegatee.termDocs(new Term(FieldNames.SHAREABLE_NODE, ""));){
            while (tDocs.next()) {
                shareableNodes.set(tDocs.doc());
            }
        }
        return shareableNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocId getParent(int n, BitSet deleted) throws IOException {
        boolean existing = false;
        int parentDocNum = this.inSegmentParents[n];
        DocId parent = parentDocNum != -1 ? DocId.create(parentDocNum) : this.foreignParentDocIds.get(n);
        if (parent != null) {
            existing = true;
            if (!parent.isValid(deleted)) {
                if (log.isDebugEnabled()) {
                    log.debug(parent + " not valid anymore.");
                }
                parent = null;
            }
        }
        if (parent == null) {
            int plainDocId = -1;
            Document doc = this.document(n, FieldSelectors.UUID_AND_PARENT);
            String[] parentUUIDs = doc.getValues(FieldNames.PARENT);
            if (parentUUIDs.length == 0 || parentUUIDs[0].length() == 0) {
                parent = DocId.NULL;
            } else if (this.shareableNodes.get(n)) {
                parent = DocId.create(parentUUIDs);
            } else {
                if (!existing) {
                    Term id = TermFactory.createUUIDTerm(parentUUIDs[0]);
                    try (TermDocs docs = this.termDocs(id);){
                        while (docs.next()) {
                            if (deleted.get(docs.doc())) continue;
                            plainDocId = docs.doc();
                            parent = DocId.create(plainDocId);
                            break;
                        }
                    }
                }
                if (parent == null) {
                    parent = DocId.create(parentUUIDs[0]);
                }
            }
            if (plainDocId != -1) {
                this.inSegmentParents[n] = plainDocId;
            } else {
                this.foreignParentDocIds.put(n, parent);
                if (existing) {
                    this.inSegmentParents[n] = -1;
                }
            }
        }
        return parent;
    }

    public long getCreationTick() {
        return this.creationTick;
    }

    public IndexReader[] getSequentialSubReaders() {
        return null;
    }

    public FieldInfos getFieldInfos() {
        return ReaderUtil.getMergedFieldInfos((IndexReader)this.in);
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        if (fieldSelector == FieldSelectors.UUID) {
            Document doc;
            NodeId id = this.docNumber2id.get(n);
            if (id == null) {
                doc = super.document(n, fieldSelector);
                id = new NodeId(doc.get(FieldNames.UUID));
                this.docNumber2id.put(n, id);
            } else {
                doc = new Document();
                doc.add((Fieldable)new IDField(id));
            }
            return doc;
        }
        return super.document(n, fieldSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term != null && term.field() == FieldNames.UUID && this.cache != null) {
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && e.creationTick == this.creationTick && !this.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc);
            }
            try (TermDocs docs = this.in.termDocs(term);){
                if (docs.next()) {
                    this.cache.put(term.text(), this, docs.doc());
                    SingleTermDocs singleTermDocs = new SingleTermDocs(docs.doc());
                    return singleTermDocs;
                }
                TermDocs termDocs = EmptyTermDocs.INSTANCE;
                return termDocs;
            }
        }
        return this.termDocsCache.termDocs(term);
    }

    protected void doClose() throws IOException {
        try {
            this.cacheInitializer.waitUntilStopped();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextCreationTick() {
        Class<CachingIndexReader> clazz = CachingIndexReader.class;
        synchronized (CachingIndexReader.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentTick++;
        }
    }

    private class CacheInitializer
    implements Runnable {
        private static final String FILE_CACHE_NAME_ARRAY = "cache.inSegmentParents";
        private final IndexReader reader;
        private boolean running = false;
        private volatile boolean stopRequested = false;

        public CacheInitializer(IndexReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CacheInitializer cacheInitializer = this;
            synchronized (cacheInitializer) {
                this.running = true;
            }
            try {
                if (this.stopRequested) {
                    return;
                }
                boolean initCacheFromFile = this.loadCacheFromFile();
                if (!initCacheFromFile) {
                    log.debug("persisted cache is not available, will load directly from the repository.");
                    this.initializeParents(this.reader);
                }
            }
            catch (Exception e) {
                if (!this.stopRequested) {
                    log.warn("Error initializing parents cache.", (Throwable)e);
                }
            }
            finally {
                CacheInitializer cacheInitializer2 = this;
                synchronized (cacheInitializer2) {
                    this.running = false;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilStopped() throws InterruptedException {
            this.stopRequested = true;
            CacheInitializer cacheInitializer = this;
            synchronized (cacheInitializer) {
                while (this.running) {
                    this.wait();
                }
            }
        }

        private void initializeParents(IndexReader reader) throws IOException {
            double foreignParents = 0.0;
            long time = System.currentTimeMillis();
            final Term[] startUUID = new Term[]{TermFactory.createUUIDTerm("")};
            block0: while (true) {
                final HashMap docs = new HashMap();
                final HashMap parents = new HashMap();
                if (startUUID[0].text().length() != 0) {
                    startUUID[0] = TermFactory.createUUIDTerm(startUUID[0].text() + "_");
                }
                this.collectTermDocs(reader, startUUID[0], new TermDocsCollector(){

                    @Override
                    public boolean collect(Term term, TermDocs tDocs) throws IOException {
                        startUUID[0] = term;
                        if (docs.size() >= 400000) {
                            return false;
                        }
                        NodeId id = new NodeId(term.text());
                        while (tDocs.next()) {
                            int doc = tDocs.doc();
                            if (CachingIndexReader.this.shareableNodes.get(doc)) continue;
                            NodeInfo info = new NodeInfo(doc, id);
                            docs.put(doc, info);
                        }
                        return true;
                    }
                });
                if (docs.isEmpty()) {
                    this.saveCacheToFile();
                    break;
                }
                this.collectTermDocs(reader, new Term(FieldNames.PARENT, "0"), new TermDocsCollector(){

                    @Override
                    public boolean collect(Term term, TermDocs tDocs) throws IOException {
                        NodeId id = new NodeId(term.text());
                        while (tDocs.next()) {
                            Integer docId = tDocs.doc();
                            NodeInfo info = (NodeInfo)docs.get(docId);
                            if (info == null) continue;
                            info.parent = id;
                            docs.remove(docId);
                            docs.put(info.id, info);
                            parents.put(id, null);
                        }
                        return true;
                    }
                });
                this.collectTermDocs(reader, TermFactory.createUUIDTerm(""), new TermDocsCollector(){

                    @Override
                    public boolean collect(Term term, TermDocs tDocs) throws IOException {
                        NodeId id = new NodeId(term.text());
                        while (tDocs.next()) {
                            int doc = tDocs.doc();
                            if (!parents.containsKey(id)) continue;
                            parents.put(id, doc);
                        }
                        return true;
                    }
                });
                if (this.stopRequested) {
                    return;
                }
                Iterator iterator = docs.values().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    NodeInfo info = (NodeInfo)iterator.next();
                    int parentDocId = -1;
                    NodeInfo parent = (NodeInfo)docs.get(info.parent);
                    if (parent != null) {
                        parentDocId = parent.docId;
                    } else {
                        Integer docId = (Integer)parents.get(info.parent);
                        if (docId != null) {
                            parentDocId = docId;
                        }
                    }
                    if (parentDocId != -1) {
                        ((CachingIndexReader)CachingIndexReader.this).inSegmentParents[info.docId] = parentDocId;
                        continue;
                    }
                    if (info.parent != null) {
                        foreignParents += 1.0;
                        CachingIndexReader.this.foreignParentDocIds.put(info.docId, DocId.create(info.parent));
                        continue;
                    }
                    if (CachingIndexReader.this.shareableNodes.get(info.docId)) {
                        Document doc = reader.document(info.docId, FieldSelectors.UUID_AND_PARENT);
                        CachingIndexReader.this.foreignParentDocIds.put(info.docId, DocId.create(doc.getValues(FieldNames.PARENT)));
                        continue;
                    }
                    CachingIndexReader.this.foreignParentDocIds.put(info.docId, DocId.NULL);
                }
                break;
            }
            if (log.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getPercentInstance();
                nf.setMaximumFractionDigits(1);
                time = System.currentTimeMillis() - time;
                if (CachingIndexReader.this.inSegmentParents.length > 0) {
                    foreignParents /= (double)CachingIndexReader.this.inSegmentParents.length;
                }
                log.debug("initialized {} DocIds in {} ms, {} foreign parents", new Object[]{CachingIndexReader.this.inSegmentParents.length, time, nf.format(foreignParents)});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectTermDocs(IndexReader reader, Term start, TermDocsCollector collector) throws IOException {
            try (TermDocs tDocs = reader.termDocs();
                 TermEnum terms = reader.terms(start);){
                Term t;
                int count = 0;
                while ((t = terms.term()) != null && t.field() == start.field()) {
                    tDocs.seek(terms);
                    if (!collector.collect(t, tDocs)) {
                    } else if (++count % 10000 == 0 && this.stopRequested) {
                    } else if (terms.next()) continue;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveCacheToFile() throws IOException {
            try (IndexOutput io = null;){
                io = this.reader.directory().createOutput(FILE_CACHE_NAME_ARRAY);
                for (int parent : CachingIndexReader.this.inSegmentParents) {
                    io.writeInt(parent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadCacheFromFile() throws IOException {
            try (IndexInput ii = null;){
                long time = System.currentTimeMillis();
                ii = this.reader.directory().openInput(FILE_CACHE_NAME_ARRAY);
                for (int i = 0; i < CachingIndexReader.this.inSegmentParents.length; ++i) {
                    ((CachingIndexReader)CachingIndexReader.this).inSegmentParents[i] = ii.readInt();
                }
                log.debug("persisted cache initialized {} DocIds in {} ms", new Object[]{CachingIndexReader.this.inSegmentParents.length, System.currentTimeMillis() - time});
                boolean bl = true;
                return bl;
            }
            return false;
        }
    }

    private static final class NodeInfo {
        final int docId;
        final NodeId id;
        NodeId parent;

        public NodeInfo(int docId, NodeId id) {
            this.docId = docId;
            this.id = id;
        }
    }

    private static interface TermDocsCollector {
        public boolean collect(Term var1, TermDocs var2) throws IOException;
    }
}

