/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.ZombieHierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;

class ChangeLogBasedHierarchyMgr
extends CachingHierarchyManager {
    ZombieHierarchyManager zombieHierMgr;

    ChangeLogBasedHierarchyMgr(NodeId rootNodeId, ItemStateManager manager, ChangeLog changes) {
        super(rootNodeId, new ChangeLogItemStateManager(manager, changes));
        this.zombieHierMgr = new ZombieHierarchyManager(this, this.provider, new AtticItemStateManager(changes));
    }

    public Path getZombiePath(ItemId id) throws ItemNotFoundException, RepositoryException {
        return this.zombieHierMgr.getPath(id);
    }

    public Name getZombieName(NodeId id, NodeId parentId) throws ItemNotFoundException, RepositoryException {
        return this.zombieHierMgr.getName(id, parentId);
    }

    private static class ChangeLogItemStateManager
    implements ItemStateManager {
        private final ChangeLog changes;
        private final ItemStateManager base;

        private ChangeLogItemStateManager(ItemStateManager base, ChangeLog changes) {
            this.base = base;
            this.changes = changes;
        }

        @Override
        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            try {
                ItemState state = this.changes.get(id);
                if (state != null) {
                    return state;
                }
            }
            catch (NoSuchItemStateException noSuchItemStateException) {
                // empty catch block
            }
            return this.base.getItemState(id);
        }

        @Override
        public boolean hasItemState(ItemId id) {
            try {
                ItemState state = this.changes.get(id);
                if (state != null) {
                    return true;
                }
            }
            catch (NoSuchItemStateException noSuchItemStateException) {
                // empty catch block
            }
            return this.base.hasItemState(id);
        }

        @Override
        public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNodeReferences(NodeId id) {
            return false;
        }
    }

    private static class AtticItemStateManager
    implements ItemStateManager {
        private final Map<ItemId, ItemState> deleted = new HashMap<ItemId, ItemState>();

        private AtticItemStateManager(ChangeLog changes) {
            for (ItemState state : changes.deletedStates()) {
                this.deleted.put(state.getId(), state);
            }
        }

        @Override
        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            ItemState state = this.deleted.get(id);
            if (state != null) {
                return state;
            }
            throw new NoSuchItemStateException("Item not in the attic: " + id);
        }

        @Override
        public boolean hasItemState(ItemId id) {
            return this.deleted.containsKey(id);
        }

        @Override
        public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNodeReferences(NodeId id) {
            return false;
        }
    }
}

