/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.olap;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.impl.JobImpl;
import com.sas.metadata.remote.impl.JobImpl_Stub;
import com.sas.publicobjects.olap.UpgradeUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.rmi.RemoteException;

public class JobCube
extends Metadata
implements UpgradeInterface,
Serializable {
    public static final UsageVersion FAILED_MIGRATION_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final long serialVersionUID = 42L;
    private MetadataInterface smartCube = null;

    public JobCube() throws RemoteException {
        super(JobCube.class);
    }

    public JobCube(Job job) throws RemoteException {
        super((Object)job, JobCube.class);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    public JobCube(JobImpl job) throws RemoteException {
        super((Object)job, JobCube.class);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    public JobCube(JobImpl_Stub job) throws RemoteException {
        super((Object)job, JobCube.class);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    public String getType() throws RemoteException {
        return "Job.CubeBuild";
    }

    private void createSmartCube(Job mdoJob) throws RemoteException, MdException, ServiceException {
        ClassifierMap map;
        AssociationList cubes;
        TransformationStep step;
        AssociationList transformations;
        TransformationActivity ta;
        AssociationList steps;
        AssociationList acts;
        Cube cube = null;
        if (mdoJob != null && (acts = mdoJob.getJobActivities()).size() > 0 && (steps = (ta = (TransformationActivity)acts.get(0)).getSteps()).size() > 0 && (transformations = (step = (TransformationStep)steps.get(0)).getTransformations()).size() > 0 && (cubes = (map = (ClassifierMap)transformations.get(0)).getClassifierTargets()).size() > 0) {
            cube = (Cube)cubes.get(0);
        }
        this.smartCube = cube != null ? this._repository.factoryProcess(cube) : null;
    }

    public synchronized void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (!UpgradeUtil.isUpgradeable((MetadataInterface)this, CURRENT_VERSION)) {
            return;
        }
        Job jomaObject = (Job)this._repositoryObject;
        try {
            this.createSmartCube(jomaObject);
            if (this.smartCube == null) {
                IllegalStateException e = new IllegalStateException("Upgrade called on a Job (cube) that is not associated with a cube");
                throw new ServiceException((Throwable)e, e.getLocalizedMessage());
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        UpgradeUtil.setPublicType((PrimaryType)jomaObject, "Job.CubeBuild");
        try {
            if (UpgradeUtil.setUsageVersion((MetadataInterface)this, (PrimaryType)jomaObject, FAILED_MIGRATION_VERSION)) {
                this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        try {
            if (this.smartCube instanceof UpgradeInterface) {
                ((UpgradeInterface)this.smartCube).upgradeFromPreviousVersion();
            }
        }
        finally {
            this.smartCube.destroy();
            this.smartCube = null;
        }
    }
}

