/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.olap;

import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.impl.CubeImpl;
import com.sas.metadata.remote.impl.CubeImpl_Stub;
import com.sas.olapadmin.migration.UpgradeCubeAction;
import com.sas.publicobjects.olap.UpgradeUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.olap.CubeInterface;
import com.sas.services.information.metadata.olap.OLAPSchemaInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.services.util.XMLUtil;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;

public class Cube
extends Metadata
implements UpgradeInterface,
CubeInterface,
LocalizableProperties,
SubstitutionProperties {
    private static final long serialVersionUID = -1107133479654435095L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(3, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(5, 0);
    public static final UsageVersion MIN_NINE_THREE_VERSION = new UsageVersion(4, 0);
    private static final String CUBE_DIRECTORY = "CubePhysicalDirectory";
    private static final String CUBE_WORKPATH = "CubeWorkDirectory";
    private static final String CUBE_DATAPATH = "CubeGlobalDataDirectory";
    private static final String CUBE_INDEXPATH = "CubeGlobalIndexDirectory";
    private static final String CUBE_AGGRDATAPATH = "CubeAggregationDataDirectory";
    private static final String CUBE_AGGRINDEXPATH = "CubeAggregationIndexDirectory";
    private static final String DIRPATH = ".DirPath";
    private static final String DATAPATH = "DATAPATH";
    private static final String INDEXPATH = "INDEXPATH";
    private static final String WORKPATH = "WORKPATH";

    public Cube() throws RemoteException {
        super(Cube.class);
    }

    public Cube(com.sas.metadata.remote.Cube cube) throws RemoteException {
        super((Object)cube, Cube.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Cube(CubeImpl cube) throws RemoteException {
        super((Object)cube, Cube.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Cube(CubeImpl_Stub cube) throws RemoteException {
        super((Object)cube, Cube.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public String getType() throws RemoteException {
        return "Cube";
    }

    public OLAPSchemaInterface getOLAPSchema() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(((Object)((Object)this)).getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        com.sas.metadata.remote.Cube cube = (com.sas.metadata.remote.Cube)this._repositoryObject;
        try {
            OLAPSchema schema = cube.getAssociatedOLAPSchema();
            if (schema == null) {
                return null;
            }
            return (OLAPSchemaInterface)this._repository.factoryProcess((Object)schema);
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }

    public synchronized void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (!UpgradeUtil.isUpgradeable((MetadataInterface)this, MIN_NINE_THREE_VERSION)) {
            return;
        }
        com.sas.metadata.remote.Cube jomaObject = (com.sas.metadata.remote.Cube)this._repositoryObject;
        UpgradeUtil.setPublicType((PrimaryType)jomaObject, "Cube");
        try {
            if (UpgradeUtil.setUsageVersion((MetadataInterface)this, (PrimaryType)jomaObject, OLDEST_VERSION)) {
                this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        FolderInterface targetFolder = this.getParent();
        OLAPSchemaInterface schema = this.getOLAPSchema();
        if (targetFolder != null && FolderUtil.isDIStudioUngroupedFolder((FolderInterface)targetFolder)) {
            targetFolder = null;
        }
        if (targetFolder == null) {
            if (schema == null) {
                targetFolder = FolderUtil.makeOrphanedCubesFolder((MetadataInterface)this);
                if (targetFolder != null) {
                    targetFolder.moveMembersOnOverflow();
                }
            } else if (this.getReposId().substring(0, 8).equals(schema.getReposId().substring(0, 8))) {
                targetFolder = schema.getParent();
            }
            if (targetFolder == null) {
                String folderName = schema.getName();
                FolderInterface sharedData = FolderUtil.makeSharedDataFolder((MetadataInterface)this);
                targetFolder = sharedData.getSubfolder(folderName);
                if (targetFolder == null) {
                    targetFolder = sharedData.makeSubfolder(folderName);
                }
            }
        }
        CubeNameConstraint constraint = null;
        if (schema != null) {
            constraint = new CubeNameConstraint(this, schema);
        }
        this.validateNameAndFolder(targetFolder, constraint);
        MetadataInterface childSmartObject = this.startTransaction();
        UpgradeCubeAction upgradeCube = null;
        try {
            com.sas.metadata.remote.Cube childCube = (com.sas.metadata.remote.Cube)childSmartObject.getRepositoryEntity();
            upgradeCube = UpgradeCubeAction.getUpgradeCubeAction((com.sas.metadata.remote.Cube)childCube);
            upgradeCube.setAutoCommit(false);
            upgradeCube.upgrade();
            childSmartObject.commit();
            this.update();
        }
        catch (MdException e) {
            childSmartObject.rollback();
            throw new ServiceException((Throwable)e);
        }
        catch (RemoteException e) {
            childSmartObject.rollback();
            throw e;
        }
        catch (Exception e) {
            childSmartObject.rollback();
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        finally {
            childSmartObject.destroy();
        }
        if (upgradeCube != null) {
            upgradeCube.commitCalcMeasureTransactions(jomaObject);
        }
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        PropertyList props;
        block19: {
            props = new PropertyList();
            try {
                com.sas.metadata.remote.Cube smartCube = (com.sas.metadata.remote.Cube)this._repositoryObject;
                MdObjectStore store = smartCube.getObjectStore().getFactory().createObjectStore(null, "Cube.getSubstitutionProperties");
                try {
                    AssociationList lcustomAssociations;
                    AssociationList directories;
                    com.sas.metadata.remote.Cube mdCube = (com.sas.metadata.remote.Cube)store.getFactory().createComplexMetadataObject(store, (CMetadata)smartCube);
                    File file = mdCube.getAssociatedFile();
                    if (file != null && (directories = file.getDirectories()).size() > 0) {
                        Directory directory = (Directory)directories.get(0);
                        this.addDirectoryToSubstitutionProperties(props, directory, "CubePhysicalDirectory.DirPath");
                    }
                    if ((lcustomAssociations = mdCube.getCustomAssociations()) == null) break block19;
                    for (int i = 0; i < lcustomAssociations.size(); ++i) {
                        Directory dir;
                        Object obj;
                        int j;
                        AssociationList lassociatedObjects;
                        CustomAssociation mdcustomAssociation = (CustomAssociation)lcustomAssociations.get(i);
                        if (mdcustomAssociation.getName().equals(DATAPATH)) {
                            lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                            for (j = 0; j < lassociatedObjects.size(); ++j) {
                                obj = lassociatedObjects.get(j);
                                if (!(obj instanceof Directory)) continue;
                                dir = (Directory)obj;
                                this.addDirectoryToSubstitutionProperties(props, dir, CUBE_DATAPATH + j + DIRPATH);
                            }
                            continue;
                        }
                        if (mdcustomAssociation.getName().equals(INDEXPATH)) {
                            lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                            for (j = 0; j < lassociatedObjects.size(); ++j) {
                                obj = lassociatedObjects.get(j);
                                if (!(obj instanceof Directory)) continue;
                                dir = (Directory)obj;
                                this.addDirectoryToSubstitutionProperties(props, dir, CUBE_INDEXPATH + j + DIRPATH);
                            }
                            continue;
                        }
                        if (!mdcustomAssociation.getName().equals(WORKPATH)) continue;
                        lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                        for (j = 0; j < lassociatedObjects.size(); ++j) {
                            obj = lassociatedObjects.get(j);
                            if (!(obj instanceof Directory)) continue;
                            dir = (Directory)obj;
                            this.addDirectoryToSubstitutionProperties(props, dir, CUBE_WORKPATH + j + DIRPATH);
                        }
                    }
                    AssociationList laggrs = mdCube.getAggregations();
                    if (laggrs == null) break block19;
                    for (int i = 0; i < laggrs.size(); ++i) {
                        Aggregation aggr = (Aggregation)laggrs.get(i);
                        AssociationList lcustomAssoc = aggr.getCustomAssociations();
                        for (int j = 0; j < lcustomAssoc.size(); ++j) {
                            Directory dir;
                            Object obj;
                            int k;
                            AssociationList lassociatedObjects;
                            CustomAssociation mdcustomAssociation = (CustomAssociation)lcustomAssoc.get(j);
                            if (mdcustomAssociation.getName().equals(DATAPATH)) {
                                lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                                for (k = 0; k < lassociatedObjects.size(); ++k) {
                                    obj = lassociatedObjects.get(k);
                                    if (!(obj instanceof Directory)) continue;
                                    dir = (Directory)obj;
                                    this.addDirectoryToSubstitutionProperties(props, dir, CUBE_AGGRDATAPATH + aggr.getName() + k + DIRPATH);
                                }
                                continue;
                            }
                            if (!mdcustomAssociation.getName().equals(INDEXPATH)) continue;
                            lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                            for (k = 0; k < lassociatedObjects.size(); ++k) {
                                obj = lassociatedObjects.get(k);
                                if (!(obj instanceof Directory)) continue;
                                dir = (Directory)obj;
                                this.addDirectoryToSubstitutionProperties(props, dir, CUBE_AGGRINDEXPATH + aggr.getName() + k + DIRPATH);
                            }
                        }
                    }
                }
                catch (MdException e) {
                    throw new UnexpectedSubstitutionException((Throwable)e);
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return props;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            com.sas.metadata.remote.Cube smartCube = (com.sas.metadata.remote.Cube)this._repositoryObject;
            MdObjectStore store = smartCube.getObjectStore().getFactory().createObjectStore(null, "Cube.setSubstitutionProperties");
            try {
                AssociationList lcustomAssociations;
                AssociationList directories;
                com.sas.metadata.remote.Cube mdCube = (com.sas.metadata.remote.Cube)store.getFactory().createComplexMetadataObject(store, (CMetadata)smartCube);
                File file = mdCube.getAssociatedFile();
                if (file != null && (directories = file.getDirectories()).size() > 0) {
                    Directory directory = (Directory)directories.get(0);
                    this.setDirectoryFromSubstitutionProperties(map, directory, "CubePhysicalDirectory.DirPath");
                }
                if ((lcustomAssociations = mdCube.getCustomAssociations()) != null) {
                    int j;
                    for (int i = 0; i < lcustomAssociations.size(); ++i) {
                        Directory dir;
                        Object obj;
                        AssociationList lassociatedObjects;
                        CustomAssociation mdcustomAssociation = (CustomAssociation)lcustomAssociations.get(i);
                        if (mdcustomAssociation.getName().equals(DATAPATH)) {
                            lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                            for (j = 0; j < lassociatedObjects.size(); ++j) {
                                obj = lassociatedObjects.get(j);
                                if (!(obj instanceof Directory)) continue;
                                dir = (Directory)obj;
                                this.setDirectoryFromSubstitutionProperties(map, dir, CUBE_DATAPATH + j + DIRPATH);
                            }
                            continue;
                        }
                        if (mdcustomAssociation.getName().equals(INDEXPATH)) {
                            lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                            for (j = 0; j < lassociatedObjects.size(); ++j) {
                                obj = lassociatedObjects.get(j);
                                if (!(obj instanceof Directory)) continue;
                                dir = (Directory)obj;
                                this.setDirectoryFromSubstitutionProperties(map, dir, CUBE_INDEXPATH + j + DIRPATH);
                            }
                            continue;
                        }
                        if (!mdcustomAssociation.getName().equals(WORKPATH)) continue;
                        lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                        for (j = 0; j < lassociatedObjects.size(); ++j) {
                            obj = lassociatedObjects.get(j);
                            if (!(obj instanceof Directory)) continue;
                            dir = (Directory)obj;
                            this.setDirectoryFromSubstitutionProperties(map, dir, CUBE_WORKPATH + j + DIRPATH);
                        }
                    }
                    AssociationList laggrs = mdCube.getAggregations();
                    if (laggrs != null) {
                        for (int i = 0; i < laggrs.size(); ++i) {
                            Aggregation aggr = (Aggregation)laggrs.get(i);
                            lcustomAssociations = aggr.getCustomAssociations();
                            for (j = 0; j < lcustomAssociations.size(); ++j) {
                                Directory dir;
                                Object obj;
                                int k;
                                AssociationList lassociatedObjects;
                                CustomAssociation mdcustomAssociation = (CustomAssociation)lcustomAssociations.get(j);
                                if (mdcustomAssociation.getName().equals(DATAPATH)) {
                                    lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                                    for (k = 0; k < lassociatedObjects.size(); ++k) {
                                        obj = lassociatedObjects.get(k);
                                        if (!(obj instanceof Directory)) continue;
                                        dir = (Directory)obj;
                                        this.setDirectoryFromSubstitutionProperties(map, dir, CUBE_AGGRDATAPATH + aggr.getName() + k + DIRPATH);
                                    }
                                    continue;
                                }
                                if (!mdcustomAssociation.getName().equals(INDEXPATH)) continue;
                                lassociatedObjects = mdcustomAssociation.getAssociatedObjects();
                                for (k = 0; k < lassociatedObjects.size(); ++k) {
                                    obj = lassociatedObjects.get(k);
                                    if (!(obj instanceof Directory)) continue;
                                    dir = (Directory)obj;
                                    this.setDirectoryFromSubstitutionProperties(map, dir, CUBE_AGGRINDEXPATH + aggr.getName() + k + DIRPATH);
                                }
                            }
                        }
                    }
                }
                store.updatedMetadataAll();
            }
            catch (MdException e) {
                throw new UnexpectedSubstitutionException((Throwable)e);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void addDirectoryToSubstitutionProperties(PropertyList props, Directory mdDirectory, String dirLocationName) throws RemoteException, MdException {
        String location;
        if (mdDirectory != null && (location = mdDirectory.getDirectoryName()) != null && location.length() > 0) {
            props.addProperty(dirLocationName, location);
        }
    }

    private void setDirectoryFromSubstitutionProperties(PropertyMap map, Directory mdDirectory, String dirPath) throws RemoteException, MdException {
        String existingName;
        String newValue;
        if (!(mdDirectory == null || (newValue = map.getProperty(dirPath)) == null || (existingName = mdDirectory.getDirectoryName()) != null && existingName.equals(newValue))) {
            mdDirectory.setDirectoryName(newValue);
            mdDirectory.setName(newValue);
        }
    }

    private class CubeNameConstraint
    implements MetadataNameConstraint {
        Cube _cube;
        MetadataServerInterface _server;
        Filter _filter;
        String _schemaId;

        CubeNameConstraint(Cube cube2, OLAPSchemaInterface schema) throws ServiceException, RemoteException {
            this._cube = cube2;
            this._schemaId = schema.getReposId();
            this._filter = new Filter();
            this._filter.setType("Cube");
            this._filter.setOMRFlags(16384);
            this._server = (MetadataServerInterface)cube2.getRepository().getServer();
        }

        public boolean isNameValid(MetadataInterface object, String name) throws ServiceException, RemoteException {
            StringBuffer sb = new StringBuffer();
            sb.append("<XMLSelect search=\"*[@Name='");
            sb.append(XMLUtil.normalize((String)name));
            sb.append("'][AssociatedOLAPSchema/OLAPSchema[@Id='");
            sb.append(this._schemaId);
            sb.append("']]\"/>");
            this._filter.setExplicitSearchString("omi", sb.toString());
            int count = this._server.getCountNoSecurity(this._filter, null);
            if (count == 0) {
                return true;
            }
            if (count > 1) {
                return false;
            }
            return object.getName().equals(name);
        }
    }
}

