/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Column;
import com.sas.query.models.Expression;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.Table;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WAdminDataSourceTable;
import java.util.Hashtable;

public class WAdminSqlLogic
extends SqlLogic {
    public WAdminSqlLogic() {
        this.setQualifiedNameUsed(true);
    }

    public WAdminSqlLogic(Query query, Hashtable passwordList) {
        super(query, passwordList);
        this.setQualifiedNameUsed(true);
    }

    public WAdminSqlLogic(SqlProperties sqlProperties) {
        super(sqlProperties);
        this.setQualifiedNameUsed(true);
    }

    public String genColumnName(Column column) {
        String strColumn = "";
        String strTableName = this.checkIdentifier(column.getParent().getCorrelationName());
        if (strTableName == null || strTableName.length() == 0) {
            WAdminDataSourceTable wadst = (WAdminDataSourceTable)column.getParent().getDataSourceTable();
            strTableName = wadst.getName();
        }
        strColumn = this.genIdentifier(strTableName) + ".";
        String colName = column.getName();
        strColumn = strColumn + this.genIdentifier(colName);
        return strColumn;
    }

    public String genSelectedColumnList() {
        String strSelect = "";
        if (this.m_query.getDuplicateRowsRule() == 2) {
            strSelect = strSelect + "ALL ";
        } else if (this.m_query.getDuplicateRowsRule() == 0) {
            strSelect = strSelect + "DISTINCT ";
        }
        ResultItemList columnList = this.m_query.getResultItems();
        int cColumns = columnList.size();
        boolean bMultiColumn = false;
        for (int columnIndex = 0; columnIndex < cColumns; ++columnIndex) {
            ResultItem item = columnList.elementAt(columnIndex);
            String strColumn = this.genColumnNameInSelectList(item).trim();
            if (strColumn.length() <= 0) continue;
            if (bMultiColumn) {
                strSelect = strSelect + ", ";
            }
            bMultiColumn = true;
            strSelect = strSelect + strColumn;
            if (item.getFormat() != null) {
                strSelect = strSelect + " format=" + item.getFormat();
            }
            if (item.getAlias() == null) continue;
            strSelect = strSelect + " AS " + this.genIdentifier(item.getAlias());
        }
        return strSelect;
    }

    protected void updateResultsWithNewAlias(String oldAlias, String newAlias) {
        oldAlias = this.genIdentifier(this.checkIdentifier(oldAlias)) + ".";
        newAlias = this.genIdentifier(this.checkIdentifier(newAlias)) + ".";
        ResultItemList list = this.m_query.getResultItems();
        for (int i = 0; i < list.size(); ++i) {
            ResultItem item = list.elementAt(i);
            Expression expression = item.getExpression();
            String selectExpression = expression.getDisplayString();
            boolean found = false;
            int begloc = selectExpression.indexOf(oldAlias);
            while (begloc > -1) {
                String endString = "";
                String begString = "";
                int endloc = begloc + oldAlias.length();
                if (begloc == 0) {
                    endString = selectExpression.substring(endloc);
                    selectExpression = newAlias + endString;
                } else {
                    begString = selectExpression.substring(0, begloc);
                    endString = selectExpression.substring(endloc);
                    selectExpression = begString + newAlias + endString;
                }
                begloc = selectExpression.indexOf(oldAlias);
                found = true;
            }
            if (!found) continue;
            Expression expr = Expression.createInstance((Query)this.m_query, (String)selectExpression);
            item.setExpression(expr);
        }
    }

    protected String genSQLForTable(Table table) {
        String strName;
        String sqlString = "";
        if (table == null) {
            return "";
        }
        DataSourceContainer parent = table.getDataSourceTable().getParent();
        String schemaName = null;
        if (parent != null) {
            schemaName = parent.getName();
        }
        if (schemaName != null && schemaName.length() > 0) {
            sqlString = sqlString + this.genIdentifier(schemaName) + ".";
        }
        String tabName = table.getName();
        sqlString = sqlString + this.genIdentifier(tabName);
        String options = table.getDataSourceTable().getTableOptions();
        if (options != null && options.length() > 0) {
            sqlString = sqlString + " (" + options + ")";
        }
        if ((strName = table.getCorrelationName()) != null && strName.length() > 0) {
            sqlString = sqlString + " AS " + this.checkIdentifier(strName);
        }
        return sqlString;
    }

    public String genIdentifier(String name) {
        if (name.length() == 0) {
            return name;
        }
        if (name.equals("*")) {
            return name;
        }
        if (name.charAt(0) == '\'') {
            return name;
        }
        String strIndentifier = name;
        if (((WAQuery)this.m_query).isQuotingRequired()) {
            String strStartQuote = this.m_properties.getIdentifierQuoteStart();
            String strEndQuote = this.m_properties.getIdentifierQuoteEnd();
            strIndentifier = strStartQuote + name + strEndQuote + "n";
        }
        return strIndentifier;
    }

    public String checkIdentifier(String name) {
        if (name == null) {
            return name;
        }
        String strIndentifier = name;
        String strUnquotedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        String strStartQuote = this.m_properties.getIdentifierQuoteStart();
        String strEndQuote = this.m_properties.getIdentifierQuoteEnd();
        for (int index = 0; index < name.length(); ++index) {
            if (strUnquotedChars.indexOf(name.charAt(index)) != -1) continue;
            strIndentifier = strStartQuote + name + strEndQuote + "n";
            break;
        }
        return strIndentifier;
    }

    public String genOrderByClause() {
        String strSQL = "";
        int totalLine = 70;
        int currLine = 0;
        OrderItemList orderList = this.m_query.getOrderItems();
        for (int index = 0; index < orderList.size(); ++index) {
            if (index > 0) {
                if (currLine < totalLine) {
                    strSQL = strSQL + ", ";
                } else {
                    strSQL = strSQL + ",\n      ";
                    currLine = 0;
                }
            }
            OrderItem item = orderList.elementAt(index);
            String sOrdItem = "";
            if (item.isThisANumber()) {
                ResultItemList columnList = this.m_query.getResultItems();
                for (int resultIndex = 0; resultIndex < columnList.size(); ++resultIndex) {
                    if (!columnList.elementAt(resultIndex).equals(item.getResultItem())) continue;
                    sOrdItem = sOrdItem + resultIndex;
                    break;
                }
            } else {
                int useAlias = this.useQualifiedName ? 1 : 2;
                sOrdItem = sOrdItem + item.getExpression().generateSQL((SqlLogic)this, useAlias);
            }
            if (item.getSortingDirection() == 1) {
                sOrdItem = sOrdItem + " ASC";
            } else if (item.getSortingDirection() == 2) {
                sOrdItem = sOrdItem + " DESC";
            }
            currLine += sOrdItem.length() + 2;
            strSQL = strSQL + sOrdItem;
        }
        return strSQL;
    }

    public String genGroupByClause() {
        String strSQL = "";
        int totalLine = 70;
        int currLine = 0;
        GroupItemList groupList = this.m_query.getGroupItems();
        for (int index = 0; index < groupList.size(); ++index) {
            if (index > 0) {
                if (currLine < totalLine) {
                    strSQL = strSQL + ", ";
                } else {
                    strSQL = strSQL + ",\n      ";
                    currLine = 0;
                }
            }
            GroupItem item = groupList.elementAt(index);
            int useAlias = this.useQualifiedName ? 1 : 2;
            String sGrpItem = item.getExpression().generateSQL((SqlLogic)this, useAlias);
            currLine += sGrpItem.length() + 2;
            strSQL = strSQL + sGrpItem;
        }
        return strSQL;
    }
}

