/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.WorkTable;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.wa.WADataSourceLibrefContainer;
import com.sas.query.wa.WAdminDataSourceColumn;
import com.sas.workspace.Workspace;
import java.io.Serializable;
import java.rmi.RemoteException;

class WAdminDataSourceTable
extends DataSourceTable
implements Serializable {
    protected WADataSourceLibrefContainer m_parent;
    protected DataTable m_wTable;
    protected DataSourceColumnList m_columns;

    protected WAdminDataSourceTable(WADataSourceLibrefContainer parent, DataTable wTable) {
        this.m_parent = parent;
        this.m_wTable = wTable;
        this.m_columns = null;
    }

    public void initialize() {
    }

    public String getName() {
        try {
            String name = this.m_wTable instanceof PhysicalTable ? ((PhysicalTable)this.m_wTable).getSASTableName() : this.m_wTable.getName();
            if (name.length() == 0 && this.m_wTable instanceof WorkTable) {
                name = this.m_wTable.getFQID().replace('.', '_');
                name = name.replace('$', 'A');
            }
            return name;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public String getQualifiedName() {
        String name = "";
        if (this.m_parent != null && this.m_parent.getName().length() > 0) {
            name = name + this.m_parent.getName() + ".";
        }
        name = name + this.getName();
        return name;
    }

    public DataSourceContainer getParent() {
        return this.m_parent;
    }

    public RelationshipList getRelationships() {
        return null;
    }

    public Object getUnderlyingTable() {
        return this.m_wTable;
    }

    public int getItemCount() {
        return 0;
    }

    public String[] getItemNames() {
        return null;
    }

    public DataSourceContainerList getItems() {
        return null;
    }

    public int getColumnCount() {
        if (this.m_columns == null) {
            this._readColumnInfo();
        }
        return this.m_columns.size();
    }

    public DataSourceColumnList getColumns() {
        if (this.m_columns == null) {
            this._readColumnInfo();
        }
        return this.m_columns;
    }

    protected void _readColumnInfo() {
        try {
            this.m_columns = new DataSourceColumnList();
            AssociationList columnList = this.m_wTable.getColumns();
            for (int index = 0; index < columnList.size(); ++index) {
                Column column = (Column)columnList.get(index);
                WAdminDataSourceColumn newColumn = new WAdminDataSourceColumn(this, column);
                this.m_columns.addElement((DataSourceColumn)newColumn);
            }
        }
        catch (Exception e) {
            System.err.println("Error reading column info: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

