/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.metadata.remote.Column;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.wa.WAdminDataSource;
import com.sas.query.wa.WAdminDataSourceTable;
import com.sas.workspace.Workspace;
import java.io.Serializable;
import java.rmi.RemoteException;

class WAdminDataSourceColumn
extends DataSourceColumn
implements Serializable {
    protected WAdminDataSourceTable m_parent;
    protected Column m_wColumn;
    protected int m_type;

    public WAdminDataSourceColumn(WAdminDataSourceTable parent, Column wColumn) {
        try {
            this.m_parent = parent;
            this.m_wColumn = wColumn;
            this.m_type = WAdminDataSource.mapSasToSqlType(this.m_wColumn.getSASColumnType(), this.m_wColumn.getSASFormat());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public Object getUnderlyingColumn() {
        return this.m_wColumn;
    }

    public String getQualifiedName() {
        return this.getParent().getQualifiedName() + "." + this.getName();
    }

    public DataSourceTable getParent() {
        return this.m_parent;
    }

    public int getLength() {
        try {
            return this.m_wColumn.getSASColumnLength();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return 0;
        }
    }

    public String getName() {
        try {
            return this.m_wColumn.getSASColumnName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public int getSqlType() {
        return this.m_type;
    }

    public String getLabel() {
        return null;
    }

    public String getFormat() {
        try {
            return this.m_wColumn.getSASFormat();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public String getInformat() {
        try {
            return this.m_wColumn.getSASInformat();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public boolean isNullable() {
        try {
            return this.m_wColumn.getIsNullable() == 1;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }
}

