/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.VerticalHeader;
import com.sas.query.visuals.WindowUtil;
import com.sas.query.wa.WATablesAndRelsView;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WATablesAndRelsSection
extends StandardView {
    public static final String DATA_CHANGED_PROPERTY = "DataChanged";
    protected boolean m_bDataChanged = false;
    protected boolean m_bListeningForChanges = true;
    private cPanelListener m_PanelListener = new cPanelListener();
    protected transient WATablesAndRelsView m_columnListView;
    protected transient JScrollPane m_scrollPane;
    private WAdminResource bundle = WAdminResource.getBundle(WATablesAndRelsSection.class);
    protected static final long NO_COLUMN_LIST_OPTIONS = 0L;
    protected static final long NO_VERTICAL_HEADER = 1L;

    public WATablesAndRelsSection(Query query) {
        this(query, 0L);
    }

    public WATablesAndRelsSection(Query query, long optionFlags) {
        super(query);
        this.m_scrollPane = new JScrollPane();
        WindowUtil.fixupJScrollPane((JScrollPane)this.m_scrollPane);
        this.m_columnListView = new WATablesAndRelsView(this.m_query, this.m_scrollPane);
        this.listenForDataChangesTo(this.m_columnListView);
        this.m_scrollPane.getViewport().setView(this.m_columnListView);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        topPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 3;
        gbc.anchor = 18;
        if ((optionFlags & 1L) != 0L) {
            VerticalHeader label = new VerticalHeader(this.bundle.getString("columnList.Section.Title.txt"));
            gbl.setConstraints((Component)label, gbc);
            topPanel.add((Component)label);
        }
        gbc.gridx = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(this.m_scrollPane, gbc);
        topPanel.add(this.m_scrollPane);
        this.add(topPanel);
    }

    public void closing() {
        this.m_columnListView.closing();
    }

    public void resizeTableHeights() {
        this.m_columnListView.resizeTableHeights();
    }

    protected void listenForDataChangesTo(WATablesAndRelsView pnl) {
        pnl.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_PanelListener);
    }

    public void setListeningForChanges(boolean bListeningForChanges) {
        this.m_bListeningForChanges = bListeningForChanges;
    }

    public boolean isListeningForChanges() {
        return this.m_bListeningForChanges;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            this.m_columnListView.setDataChanged(bDataChanged);
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    private class cPanelListener
    implements PropertyChangeListener {
        private cPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (WATablesAndRelsSection.this.isListeningForChanges() && ((Boolean)e.getNewValue()).booleanValue()) {
                WATablesAndRelsSection.this.setDataChanged(true);
            }
        }
    }
}

