/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnList;
import com.sas.query.models.ColumnStar;
import com.sas.query.models.Expression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.OrderItem;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.ResultItem;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.JReferableTreeView;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WAQueryDefiner;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public class WAJReferableTreeView
extends JReferableTreeView {
    protected WAQueryDefiner m_parent;
    protected ArrayList m_alTables = new ArrayList();
    protected ArrayList m_alColumns = new ArrayList();
    private static WAdminResource bundle2 = WAdminResource.getBundle(WAJReferableTreeView.class);

    public WAJReferableTreeView(WAQueryDefiner parent, Query query) {
        super(query);
        this.m_parent = parent;
        this.addQueryTablesToMetadataTableList();
    }

    public void onAction(TreePath path) {
        if (this.m_processingAction) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (node == null) {
            return;
        }
        this.busyOn();
        this.m_processingAction = true;
        this.m_alColumns.clear();
        try {
            ColumnList colList;
            ColumnExpression expression = null;
            if (node instanceof Column) {
                expression = new ColumnExpression((Column)node);
                this.m_alColumns.add(this.getMetadataColumn((Column)node));
            } else if (node instanceof ResultItem && (colList = (expression = ((ResultItem)node).getExpression()).getReferencedColumns()) != null) {
                for (int c = 0; c < colList.size(); ++c) {
                    Column col = colList.elementAt(c);
                    this.m_alColumns.add(this.getMetadataColumn(col));
                }
            }
            if (expression != null) {
                if (this.m_defaultAction == 1 || this.m_defaultAction == 2) {
                    if (expression instanceof ColumnExpression && expression.getColumn() instanceof ColumnStar) {
                        this.m_query.getMessageHandler().addError(bundle.getString("JReferableTreeView.cantFilteronColumnStar.txt"));
                    } else {
                        FilterNode newNode = new FilterNode(this.m_query, (Expression)expression);
                        String sExpr = expression.getDisplayString();
                        int iFormatLoc = sExpr.indexOf("format=");
                        if (iFormatLoc != -1) {
                            sExpr = sExpr.substring(0, iFormatLoc);
                        }
                        ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(this.m_alColumns, this.m_alTables, true);
                        tabExpressionBuilder.setExpression(sExpr);
                        tabExpressionBuilder.setUseQuotes(((WAQuery)this.m_query).isQuotingRequired());
                        tabExpressionBuilder.setColumnGroupNodeName(bundle2.getString("ExpressionBuilder.ExpColsNode.txt"));
                        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle2.getString("ExpressionBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
                        dialog.setResizable(true);
                        dialog.show();
                        if (dialog.getReturnValue() == 1) {
                            String strExpr = tabExpressionBuilder.getExpression();
                            Parser parse = new Parser();
                            Expression expr = parse.parseExpression(this.m_query, strExpr);
                            newNode.setNodeData(expr);
                            if (this.m_defaultAction == 1) {
                                FilterTree whereNodeWent = this.m_query.addAndFilter(newNode);
                                whereNodeWent.setSelectedNode(newNode);
                            } else {
                                this.m_query.addHavingAndFilter(newNode);
                                this.m_query.getHavingFilterTree().setSelectedNode(newNode);
                            }
                            this.m_query.isValidSql();
                        }
                    }
                } else if (this.m_defaultAction == 3) {
                    this.m_query.addResultItem((Expression)expression);
                } else if (this.m_defaultAction == 4) {
                    this.m_query.addGroupItem((Expression)expression);
                } else if (this.m_defaultAction == 5) {
                    OrderItem orderItem = this.m_query.addOrderItem((Expression)expression);
                    orderItem.setSortingDirection(1);
                }
                this.m_query.getPropertyChangeHandler().firePropertyChanges();
                MessageUtil.displayMessages((MessageHandler)this.m_query.getMessageHandler());
                this.m_parent.setDataChanged(true);
            }
        }
        catch (Exception e) {
            this.m_query.getMessageHandler().addInternalError(bundle.messageString("Message.ReferableTreeView.AddFilterFailed.fmt.txt", (Object)e));
            e.printStackTrace(System.err);
        }
        this.m_processingAction = false;
        this.busyOff();
    }

    protected com.sas.metadata.remote.Column getMetadataColumn(Column col) {
        com.sas.metadata.remote.Column metaCol = (com.sas.metadata.remote.Column)((PhysicalColumn)col).getDataSourceColumn().getUnderlyingColumn();
        return metaCol;
    }

    public void addQueryTablesToMetadataTableList() {
        this.m_alTables.clear();
        TableList tblList = this.m_query.getTables();
        for (int i = 0; i < tblList.size(); ++i) {
            Table table = tblList.elementAt(i);
            this.m_alTables.add(table.getDataSourceTable().getUnderlyingTable());
        }
    }
}

