/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.VerticalHeader;
import com.sas.query.visuals.WindowUtil;
import com.sas.query.wa.WAFilterTreeView;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WAQueryDefiner;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class WAGroupFilterSection
extends JPanel
implements QueryComponentInterface {
    public static final String DATA_CHANGED_PROPERTY = "DataChanged";
    protected boolean m_bListeningForChanges = true;
    private cPanelListener m_PanelListener = new cPanelListener();
    protected WAQueryDefiner m_parent;
    protected static final long NO_GROUP_FILTER_OPTIONS = 0L;
    protected static final long NO_VERTICAL_HEADER = 1L;
    WAQuery m_query;
    WAFilterTreeView m_filterTreeView;
    private static WAdminResource bundle = WAdminResource.getBundle(WAGroupFilterSection.class);

    public WAGroupFilterSection(Query query) {
        this(null, query, 0L);
    }

    public WAGroupFilterSection(WAQueryDefiner parent, Query query, long optionFlags) {
        this.m_parent = parent;
        this.m_query = (WAQuery)query;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 3;
        c.anchor = 18;
        if ((optionFlags & 1L) == 0L) {
            VerticalHeader label = new VerticalHeader(bundle.getString("groupFilters.Section.Title.txt"));
            gbl.setConstraints((Component)label, c);
            this.add((Component)label);
        }
        JScrollPane scrollPane = new JScrollPane(20, 30);
        WindowUtil.fixupJScrollPane((JScrollPane)scrollPane);
        JViewport viewPort = scrollPane.getViewport();
        this.m_filterTreeView = new WAFilterTreeView(this.m_query, query.getHavingFilterTree(), scrollPane);
        this.listenForDataChangesTo(this.m_filterTreeView);
        viewPort.add((Component)((Object)this.m_filterTreeView));
        c.fill = 1;
        c.gridx = -1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.anchor = 14;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gbl.setConstraints(scrollPane, c);
        this.add(scrollPane);
    }

    public WAFilterTreeView getFilterTree() {
        return this.m_filterTreeView;
    }

    public void closing() {
        this.m_filterTreeView.closing();
    }

    public boolean validateInput() {
        return true;
    }

    public void doDataExchange(boolean bSaveToModel) {
    }

    protected void listenForDataChangesTo(WAFilterTreeView pnl) {
        pnl.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_PanelListener);
    }

    public void setListeningForChanges(boolean bListeningForChanges) {
        this.m_bListeningForChanges = bListeningForChanges;
    }

    public boolean isListeningForChanges() {
        return this.m_bListeningForChanges;
    }

    public void setDataChanged(boolean bDataChanged) {
        this.m_filterTreeView.setDataChanged(bDataChanged);
    }

    private class cPanelListener
    implements PropertyChangeListener {
        private cPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (WAGroupFilterSection.this.isListeningForChanges() && ((Boolean)e.getNewValue()).booleanValue()) {
                WAGroupFilterSection.this.m_parent.setDataChanged(true);
            }
        }
    }
}

