/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.Expression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.FilterNodeView;
import com.sas.query.visuals.FilterTreeView;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.wa.WAJReferableTreeView;
import com.sas.query.wa.WAQuery;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class WAFilterTreeView
extends FilterTreeView {
    public static final String DATA_CHANGED_PROPERTY = "DataChanged";
    protected boolean m_bDataChanged = false;
    protected ArrayList m_alTables = new ArrayList();
    protected ArrayList m_alColumns = new ArrayList();
    private static WAdminResource bundle2 = WAdminResource.getBundle(WAJReferableTreeView.class);

    public WAFilterTreeView(Query query, FilterTree filterTree, JScrollPane scrollPane) {
        super(query, filterTree, scrollPane);
        this.addQueryTablesToMetadataTableList();
    }

    public void onAction() {
        this.showExpressionBuilder();
    }

    protected void _dropNode(MouseEvent event) {
        super._dropNode(event);
        this.setDataChanged(true);
    }

    public void onEdit() {
        this.showExpressionBuilder();
        this.setDataChanged(true);
    }

    public void onDelete() {
        if (!this.ensureNodeIsSelected()) {
            return;
        }
        if (QueryConfiguration.getConfigurationBoolean((String)"DeleteFilterWarningDialogEnabled.notrans", (boolean)true)) {
            Object[] options = new Object[]{bundle.getString("Standard.ButtonLabel.Yes.txt"), bundle.getString("Standard.ButtonLabel.No.txt")};
            int annoyedUserSays = JOptionPane.showOptionDialog(null, bundle.messageString("FilterTree.Label.DeleteFilter.txt"), bundle.messageString("Title.Confirm.txt"), 0, 3, null, options, options[0]);
            if (annoyedUserSays != 0) {
                this.requestFocus();
                return;
            }
        }
        this.setDataChanged(true);
        this.setSelectedNode(this.removeNode(this.getSelectedNode()));
        this.requestFocus();
        this.update();
        this.firePropertyChanges();
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    public void showExpressionBuilder() {
        FilterNodeView view = this.getSelectedNode();
        if (view != null && !this.isProcessingNodeAction()) {
            this.startProcessingNodeAction();
            FilterNode item = view.getNode();
            Expression expr = item.getNodeData();
            this.m_alColumns.clear();
            ColumnList colList = expr.getReferencedColumns();
            if (colList != null) {
                for (int c = 0; c < colList.size(); ++c) {
                    Column col = colList.elementAt(c);
                    this.m_alColumns.add(this.getMetadataColumn(col));
                }
            }
            ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(this.m_alColumns, this.m_alTables, true);
            tabExpressionBuilder.setExpression(item.generateSQLforThisNodeOnly());
            tabExpressionBuilder.setUseQuotes(((WAQuery)this.m_query).isQuotingRequired());
            tabExpressionBuilder.setColumnGroupNodeName(bundle2.getString("ExpressionBuilder.ExpColsNode.txt"));
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle2.getString("ExpressionBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                String strExpr = tabExpressionBuilder.getExpression();
                Parser parse = new Parser();
                Expression rtnExpr = parse.parseExpression(this.m_query, strExpr);
                item.setNodeData(rtnExpr);
                this.setDataChanged(true);
            }
            this.getQuery().isValidSql();
            view.reComputePreferredSize();
            this.update();
            this.endProcessingNodeAction();
            this.getQuery().getMessageHandler().firePropertyChanges();
            MessageUtil.displayMessages((MessageHandler)view.getTreeView().getQuery().getMessageHandler());
        }
    }

    protected com.sas.metadata.remote.Column getMetadataColumn(Column col) {
        com.sas.metadata.remote.Column metaCol = (com.sas.metadata.remote.Column)((PhysicalColumn)col).getDataSourceColumn().getUnderlyingColumn();
        return metaCol;
    }

    public void addQueryTablesToMetadataTableList() {
        this.m_alTables.clear();
        TableList tblList = this.m_query.getTables();
        for (int i = 0; i < tblList.size(); ++i) {
            Table table = tblList.elementAt(i);
            this.m_alTables.add(table.getDataSourceTable().getUnderlyingTable());
        }
    }

    private boolean ensureNodeIsSelected() {
        return this.m_model.getSelectedNode() != null;
    }
}

