/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.Expression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.DataFilterBarView;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WASummaryView;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.Frame;
import java.util.ArrayList;

public class WADataFilterBarView
extends DataFilterBarView {
    protected WASummaryView m_parent;
    protected ArrayList m_alTables = new ArrayList();
    protected ArrayList m_alColumns = new ArrayList();
    private WAdminResource bundle2 = WAdminResource.getBundle(WADataFilterBarView.class);

    public WADataFilterBarView(WASummaryView parent, Query query) {
        super(query);
        this.m_parent = parent;
        this.addQueryTablesToMetadataTableList();
    }

    public void onEdit() {
        this.busyOn();
        try {
            FilterNode item = this.getSelectedItem();
            Expression expr = item.getNodeData();
            ColumnList colList = expr.getReferencedColumns();
            this.m_alColumns.clear();
            if (colList != null) {
                for (int c = 0; c < colList.size(); ++c) {
                    Column col = colList.elementAt(c);
                    this.m_alColumns.add(this.getMetadataColumn(col));
                }
            }
            ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(this.m_alColumns, this.m_alTables, true);
            tabExpressionBuilder.setExpression(item.generateSQLforThisNodeOnly());
            tabExpressionBuilder.setUseQuotes(((WAQuery)this.m_query).isQuotingRequired());
            tabExpressionBuilder.setColumnGroupNodeName(this.bundle2.getString("ExpressionBuilder.ExpColsNode.txt"));
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), this.bundle2.getString("ExpressionBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                String strExpr = tabExpressionBuilder.getExpression();
                Parser parse = new Parser();
                Expression rtnExpr = parse.parseExpression(this.m_query, strExpr);
                item.setNodeData(rtnExpr);
                this.m_parent.setDataChanged(true);
            }
            this.m_query.isValidSql();
        }
        catch (Throwable t) {
            this.busyOff();
            this.m_query.getMessageHandler().addInternalError(t);
        }
        this.busyOff();
        this.firePropertyChanges();
        this.displayMessages();
    }

    protected com.sas.metadata.remote.Column getMetadataColumn(Column col) {
        com.sas.metadata.remote.Column metaCol = (com.sas.metadata.remote.Column)((PhysicalColumn)col).getDataSourceColumn().getUnderlyingColumn();
        return metaCol;
    }

    public void addQueryTablesToMetadataTableList() {
        this.m_alTables.clear();
        TableList tblList = this.m_query.getTables();
        for (int i = 0; i < tblList.size(); ++i) {
            Table table = tblList.elementAt(i);
            this.m_alTables.add(table.getDataSourceTable().getUnderlyingTable());
        }
    }

    public void onDelete() {
        super.onDelete();
        this.m_parent.setDataChanged(true);
    }
}

