/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.Table;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.WindowUtil;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class SqlTextPanel
extends JPanel
implements SqlTextHelperConstants {
    private WAdminResource bundle = WAdminResource.getBundle(SqlTextPanel.class);
    SqlTextHelper myfield = null;
    JTextComponent mywidget = null;
    JButton bExpBuild;
    DocumentListener m_panelTextListener = null;
    Vector m_panelTextListenerList = null;

    @Override
    public void setEnabled(boolean val) {
        if (this.mywidget != null) {
            this.mywidget.setEnabled(val);
        }
    }

    public SqlTextPanel(Query q) {
        this();
        this.setQuery(q);
    }

    public SqlTextPanel() {
        this(1);
    }

    public SqlTextPanel(int widgetType) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.mywidget = this.newCore(widgetType);
        this.attachHelper();
        this.myfield.setVisible(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        if (this.wrapCoreWithScrollPanel(widgetType)) {
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().setView(this.mywidget);
            WindowUtil.fixupJScrollPane((JScrollPane)scrollPane);
            ((GridBagLayout)this.getLayout()).setConstraints(scrollPane, gbc);
            this.add(scrollPane);
        } else {
            ((GridBagLayout)this.getLayout()).setConstraints(this.mywidget, gbc);
            this.add(this.mywidget);
        }
        this.bExpBuild = new JButton(this.bundle.getString("CommonUI.threeDotsForMore.txt"));
        ImageIcon defaultIcon = this.bundle.getImageIcon("dotsIconFile.image");
        this.bExpBuild = new JButton(defaultIcon);
        this.bExpBuild.setMargin(new Insets(0, 0, 0, 0));
        this.bExpBuild.setFocusPainted(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.bExpBuild, gbc);
        this.add(this.bExpBuild);
        this.bExpBuild.setVisible(false);
        this.setBehavior(16);
        SymAction aSymList = new SymAction();
        this.bExpBuild.addActionListener(aSymList);
    }

    protected JTextComponent newCore(int widgetType) {
        if (widgetType == 1) {
            return new JTextField();
        }
        JTextArea myNewWidget = new JTextArea("", 3, 25);
        return myNewWidget;
    }

    protected boolean wrapCoreWithScrollPanel(int widgetType) {
        return widgetType != 1;
    }

    public void attachHelper() {
        this.myfield = new SqlTextHelper(this.mywidget);
    }

    public void setTableContext(Table newTableContext) {
        this.myfield.setTableContext(newTableContext);
    }

    public void setQuery(Query newquery) {
        this.myfield.setQuery(newquery);
    }

    public Query getQuery() {
        return this.myfield.getQuery();
    }

    public int getExpectedType() {
        return this.myfield.getExpectedType();
    }

    public void detachFromParent() {
        this.myfield.detachFromParent();
    }

    public void attachToParent() {
        this.myfield.attachToParent();
        this.updatedDisplay();
    }

    public void replaceSelectedWith(Expression newExp) {
        this.myfield.replaceSelectedWith(newExp);
    }

    public void setBehavior(int flags) {
        this.myfield.setBehavior(flags);
    }

    public void clearBehavior(int flags) {
        if (this.hasBehavior(16) && (flags & 0x10) != 0) {
            this.myfield.clearBehavior(flags);
            this.bExpBuild.setVisible(false);
            this.validate();
        }
        this.myfield.clearBehavior(flags);
    }

    public boolean hasBehavior(int flags) {
        return this.myfield.hasBehavior(flags);
    }

    public void addExpressionToCurrentText(Expression exp) {
        this.myfield.addExpressionToCurrentText(exp);
    }

    public void setExpression(Expression exp) {
        this.myfield.setExpression(exp);
        this.updatedDisplay();
    }

    public void setEditable(boolean newVal) {
        this.myfield.setEditable(newVal);
    }

    public Expression getExpression() {
        Expression current = this.myfield.getExpression();
        if (current instanceof UnparsedExpression && !this.hasBehavior(1024)) {
            Expression reparsed;
            Parser p = new Parser();
            current = reparsed = p.parseExpression(this.getQuery(), current.generateSQL(this.getQuery().getSqlLogic(), this.getHelper().hasBehavior(2048) ? 2 : 1));
        }
        return current;
    }

    public Expression getSelectedExpression() {
        return this.myfield.getSelectedExpression();
    }

    public void recomputeDisplay() {
        this.myfield.recomputeDisplay();
        this.updatedDisplay();
    }

    public SqlTextHelper getHelper() {
        return this.myfield;
    }

    public JTextComponent getWidget() {
        return this.mywidget;
    }

    public void setText(String str) {
        this.getWidget().setText(str);
        this.getWidget().setCaretPosition(0);
    }

    public void checkPoint() {
        this.getHelper().checkPoint();
    }

    public String getSelectedText() {
        return this.getWidget().getSelectedText();
    }

    public void setSelection(int ibegin, int iend) {
        this.getHelper().setSelection(ibegin, iend);
    }

    @Override
    public void firePropertyChange(String str, Object obj1, Object obj2) {
        super.firePropertyChange(str, obj1, obj2);
    }

    public void showRevertPopmenu(JComponent comp) {
        this.getHelper().showRevertPopmenu(comp);
    }

    public void showColumnPopmenu(JComponent comp) {
        this.getHelper().showColumnPopmenu(comp);
    }

    public void setExpression(Query query, Expression exp) {
        this.myfield.setExpression(query, exp);
        this.updatedDisplay();
    }

    public void deleteExpression(Expression exp) {
        this.myfield.deleteExpression(exp);
    }

    public boolean isContentReplaceable() {
        return this.myfield.isContentReplaceable();
    }

    public boolean isEmpty() {
        return this.myfield.isEmpty();
    }

    public boolean isJustAMarkerToken() {
        return this.myfield.isJustAMarkerToken();
    }

    public void setExpectedType(int expType) {
        this.myfield.setExpectedType(expType);
        this.updatedDisplay();
    }

    private void updatedDisplay() {
    }

    public void setParentExpression(CompoundExpression myParent, int myPositionInParent, Query myquery) {
        this.myfield.setParentExpression(myParent, myPositionInParent, myquery);
    }

    public void addTextListener(TextListener t) {
        if (this.m_panelTextListener == null) {
            this.m_panelTextListener = new PanelTextChange();
            this.mywidget.getDocument().addDocumentListener(this.m_panelTextListener);
            this.m_panelTextListenerList = new Vector();
        }
        this.m_panelTextListenerList.addElement(t);
    }

    public String getText() {
        return this.myfield.getText();
    }

    public int getSelectionStart() {
        return this.myfield.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.myfield.getSelectionEnd();
    }

    public void setCaretPosition(int i) {
        this.myfield.setCaretPosition(i);
    }

    public boolean isCommaList() {
        return this.myfield.isCommaList();
    }

    protected class SymAction
    implements ActionListener {
        protected SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == SqlTextPanel.this.bExpBuild) {
                this.bExpBuild_Dialog(event);
            }
        }

        void bExpBuild_Dialog(ActionEvent event) {
            WindowUtil.busyOn((JComponent)SqlTextPanel.this.bExpBuild);
            try {
                SqlTextPanel.this.myfield.runExpressionBuilder();
                SqlTextPanel.this.myfield.requestFocus();
            }
            catch (Throwable t) {
                WindowUtil.busyOff((JComponent)SqlTextPanel.this.bExpBuild);
                SqlTextPanel.this.myfield.getQuery().getMessageHandler().addInternalError(t);
            }
            WindowUtil.busyOff((JComponent)SqlTextPanel.this.bExpBuild);
        }
    }

    class PanelTextChange
    implements DocumentListener {
        PanelTextChange() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textValueChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textValueChanged(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textValueChanged(e);
        }

        public void textValueChanged(DocumentEvent event) {
            TextEvent passUpEvent = new TextEvent(SqlTextPanel.this, 900);
            for (int i = 0; i < SqlTextPanel.this.m_panelTextListenerList.size(); ++i) {
                ((TextListener)SqlTextPanel.this.m_panelTextListenerList.elementAt(i)).textValueChanged(passUpEvent);
            }
        }
    }
}

