/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.FilterNode;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.visuals.StandardView;
import com.sas.query.wa.SqlTextPanel;
import com.sas.query.wa.SqlTextPanelPlus;
import com.sas.query.wa.WAQuery;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;

public class SqlPanel
extends StandardView {
    public static final String DATA_CHANGED_PROPERTY = "DataChanged";
    protected boolean m_bDataChanged = false;
    protected static final int AUTOMATIC = 1;
    protected static final int MANUAL = 2;
    protected int m_refreshType = 2;
    protected FilterNode m_finalWhereNode = null;
    protected FilterNode m_finalHavingNode = null;
    protected SqlTextPanelPlus m_textPanel;
    protected JButton m_editButton;
    protected JButton m_resetButton;
    protected JButton m_applyButton;
    protected boolean m_bhaveUnappliedSql = false;
    protected boolean m_bModelRefreshedToScreen = false;
    protected String m_previousGoodSQL;
    protected String m_previousPreviousGoodSQL = null;
    protected String m_previouslyAppliedSQL;
    private WAdminResource bundle = WAdminResource.getBundle(SqlPanel.class);

    public SqlPanel(Query query) {
        this(query, null, null);
        this.m_editButton.setVisible(true);
        this.m_resetButton.setVisible(true);
        this.m_applyButton.setVisible(true);
        this.m_refreshType = 1;
    }

    public SqlPanel(Query query, FilterNode finalWhereNode, FilterNode finalHavingNode) {
        super(query);
        this.m_finalWhereNode = finalWhereNode;
        this.m_finalHavingNode = finalHavingNode;
        this.m_query.addPropertyListener((ModelChangeListener)this, 65535);
        this._createWidgets();
        this._layoutWidgets();
        if (query.canResultsBeGotten()) {
            this.refresh();
        }
        this._setState();
    }

    public void closing() {
        this.m_query.removePropertyListener((ModelChangeListener)this);
    }

    protected void _createWidgets() {
        this.m_textPanel = new SqlTextPanelPlus(2);
        this.m_textPanel.setQuery(this.m_query);
        this.m_textPanel.clearBehavior(16);
        this.m_textPanel.setBehavior(1024);
        this.m_editButton = new JButton(this.bundle.getString("Common.Edit....txt"));
        this.m_editButton.setToolTipText(this.bundle.getString("SqlPanel.EditToolTip.txt"));
        this.m_applyButton = new JButton(this.bundle.getString("Common.Apply.txt"));
        this.m_applyButton.setToolTipText(this.bundle.getString("SqlPanel.ApplyToolTip.txt"));
        this.m_resetButton = new JButton(this.bundle.getString("Common.Reset.txt"));
        this.m_resetButton.setToolTipText(this.bundle.getString("SqlPanel.ResetToolTip.txt"));
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(this.m_textPanel, gbc);
        this.add(this.m_textPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 8, 0, 12);
        gridBagLayout.setConstraints(this.m_editButton, gbc);
        this.add(this.m_editButton);
        this.m_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SqlPanel.this.onEdit();
            }
        });
        this.m_editButton.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 8, 0, 12);
        gridBagLayout.setConstraints(this.m_applyButton, gbc);
        this.add(this.m_applyButton);
        this.m_applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SqlPanel.this.onApply();
            }
        });
        this.m_applyButton.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 8, 8, 12);
        gridBagLayout.setConstraints(this.m_resetButton, gbc);
        this.add(this.m_resetButton);
        this.m_resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SqlPanel.this.onReset();
            }
        });
        this.m_resetButton.setEnabled(false);
        this.m_resetButton.setVisible(false);
        this.m_textPanel.getHelper().addPropertyChangeListener((PropertyChangeListener)new HelperListener());
    }

    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        try {
            if (bVisible) {
                this.refresh();
                this.setPreviousGoodSQL(this.m_textPanel.getText());
                this.m_previouslyAppliedSQL = this.m_textPanel.getText();
                this.m_bhaveUnappliedSql = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._setState();
    }

    public void onEdit() {
        this.busyOn();
        this.m_textPanel.getHelper().showExpressionBuilder();
        String afterText = this.m_textPanel.getHelper().getText();
        if (!this.m_previouslyAppliedSQL.equals(afterText)) {
            this.setDirty(true);
        }
        this.setDataChanged(true);
        this.busyOff();
    }

    public void setDirty(boolean v) {
        this.m_bhaveUnappliedSql = v;
        if (!v) {
            this.m_previouslyAppliedSQL = this.m_textPanel.getText();
            if (this.m_query.canResultsBeGotten()) {
                this.setPreviousGoodSQL(this.m_textPanel.getText());
            }
        }
        this._setState();
    }

    private void setPreviousGoodSQL(String str) {
        if (this.m_previousGoodSQL == null) {
            this.m_previousGoodSQL = str;
        } else {
            if (this.m_previousGoodSQL.equals(str)) {
                return;
            }
            if (this.m_previousPreviousGoodSQL == null) {
                this.m_previousPreviousGoodSQL = this.m_previousGoodSQL;
            } else if (!this.m_previousPreviousGoodSQL.equals(this.m_previousGoodSQL)) {
                this.m_previousPreviousGoodSQL = this.m_previousGoodSQL;
            }
            this.m_previousGoodSQL = str;
        }
    }

    public void discardPendingChanges() {
        this.m_textPanel.getWidget().setText(this.m_previouslyAppliedSQL);
        this.setDirty(false);
    }

    private boolean hasPreviousGoodSQLToRevertTo() {
        if (this.m_previousGoodSQL == null) {
            return false;
        }
        if (this.m_previousPreviousGoodSQL == null) {
            return false;
        }
        return !this.m_previousPreviousGoodSQL.equals(this.m_previousGoodSQL);
    }

    public void onApply() {
        String strSql = null;
        this.busyOn();
        try {
            strSql = this.m_textPanel.getText();
            this.m_query.setSQL(strSql);
        }
        catch (Exception e) {
            this.m_query.getMessageHandler().addInternalError(e);
        }
        if (this.m_query.isParsable()) {
            this.m_query.isValidSql();
        }
        com.sas.query.visuals.MessageUtil.displayMessages((MessageHandler)this.m_query.getMessageHandler());
        this._setState();
        this.busyOff();
        this.setDataChanged(true);
        this.firePropertyChanges();
        this.setDirty(false);
    }

    public void onReset() {
        if (this.m_query instanceof WAQuery) {
            WAQuery query = (WAQuery)this.m_query;
            try {
                int choice = MessageUtil.displayDetailsMessage((String)this.bundle.getString("SASJoin.ResetWarningTitle.txt"), (int)0, (int)2, (String)this.bundle.getString("SASJoin.ResetWarning.txt"));
                if (choice == 0) {
                    query.m_select.getSourceSpecifications().flushAll();
                    query.reloadModelFromMetadata();
                    this.refresh();
                    this._setState();
                    this.firePropertyChanges();
                    this.setDataChanged(true);
                }
            }
            catch (Exception ex) {
                query.getMessageHandler().addInternalError(ex.getMessage());
            }
        }
    }

    public void refresh() {
        String strSql = null;
        try {
            strSql = this.m_query.getSql(this.m_finalWhereNode, this.m_finalHavingNode);
            this.m_textPanel.setText(QueryUtils.formatSql((String)strSql, (DataSource)this.m_query.getDataSource()));
            this.setPreviousGoodSQL(this.m_textPanel.getText());
            this.m_previouslyAppliedSQL = this.m_textPanel.getText();
            this.m_bhaveUnappliedSql = false;
        }
        catch (Exception e) {
            if (strSql != null) {
                this.m_textPanel.setText(e.getMessage() + "\n\n" + strSql);
            }
            this.m_textPanel.setText(e.getMessage());
        }
        com.sas.query.visuals.MessageUtil.displayMessagesLater((MessageHandler)this.m_query.getMessageHandler());
        this.m_bModelRefreshedToScreen = true;
    }

    public void refresh(String strSql) {
        this.m_textPanel.setText(strSql);
        this._setState();
    }

    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.isStructureChange() && event.didOnlyThisStructureTypeChange(8)) {
            return;
        }
        this.m_bModelRefreshedToScreen = false;
        if (this.m_refreshType == 1) {
            this.refresh();
        }
        this._setState();
    }

    protected void _setState() {
        try {
            WAQuery query = (WAQuery)this.m_query;
            TextStore text = null;
            for (int ii = 0; ii < query.m_select.getSourceSpecifications().size(); ++ii) {
                Root obj = (Root)query.m_select.getSourceSpecifications().get(ii);
                if (!(obj instanceof TextStore) || !obj.getName().equals("SQL")) continue;
                text = (TextStore)obj;
            }
            this.m_resetButton.setEnabled(text != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hasPreviousGoodSQLToRevertTo();
        this.m_applyButton.setEnabled(this.hasPendingChanges());
        this.repaint();
    }

    public boolean hasPendingChanges() {
        return this.m_bhaveUnappliedSql;
    }

    public SqlTextPanel getTextPanel() {
        return this.m_textPanel;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    protected class HelperListener
    implements PropertyChangeListener {
        protected HelperListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String t;
            if (e.getPropertyName().equals("HelperExpressionChanged") && !(t = SqlPanel.this.m_textPanel.getText()).equals(SqlPanel.this.m_previouslyAppliedSQL)) {
                SqlPanel.this.setDirty(true);
                SqlPanel.this._setState();
            }
        }
    }
}

