/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.models.Join;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.visuals.JoinTreeView;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import com.sas.query.wa.WAJoinPropertyView;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class AdvancedJoinPropertyView
extends StandardView
implements QueryComponentInterface,
PropertyChangeListener {
    protected WAJoinPropertyView m_joinProperties;
    protected JoinTreeView m_joinTree;
    protected JoinList m_joinList;
    protected JoinRelationshipList m_joinRelationshipList;
    private static WAdminResource bundle = WAdminResource.getBundle(AdvancedJoinPropertyView.class);

    public AdvancedJoinPropertyView(Query query) {
        super(query);
        JSplitPane joins = new JSplitPane();
        joins.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 0));
        JScrollPane scroll = new JScrollPane();
        this.m_joinTree = new JoinTreeView(query, this.m_joinList, this.m_joinRelationshipList, scroll);
        scroll.setViewportView((Component)this.m_joinTree);
        WindowUtil.fixupJScrollPane((JScrollPane)scroll);
        joins.setLeftComponent(scroll);
        this.m_joinProperties = new WAJoinPropertyView(query, this.m_joinList, this.m_joinRelationshipList);
        joins.setRightComponent((Component)((Object)this.m_joinProperties));
        joins.setDividerLocation(170);
        this.setLayout(new BorderLayout());
        this.add(joins);
        this.m_joinTree.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_joinProperties.addPropertyChangeListener(this);
    }

    public void closing() {
        this.m_joinTree.removePropertyChangeListener((PropertyChangeListener)this);
        this.getQuery().getMessageHandler().firePropertyChanges();
    }

    public boolean validateInput() {
        Join join = this.m_joinList.getFirstTableWithNoRelationships();
        if (join != null) {
            int nChoice = JOptionPane.showConfirmDialog(null, bundle.messageString("AdvancedJoinDialog.Message.NeedToReorder.fmt", (Object)join.getTable().getDisplayName()), bundle.getString("AdvancedJoinDialog.Title.Reorder.txt"), 0, 2);
            if (nChoice == 0) {
                this.m_joinList.groupJoinsFromList(this.m_joinRelationshipList);
            } else {
                this.m_joinTree.setSelectedJoin(join);
                return false;
            }
        }
        return true;
    }

    public void doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.getQuery().setJoinsAndRelationships(this.m_joinList, this.m_joinRelationshipList);
        } else {
            try {
                this.m_joinList = (JoinList)this.getQuery().getJoins().deepClone();
                this.m_joinRelationshipList = (JoinRelationshipList)this.getQuery().getJoinRelationships().deepClone();
                this.m_joinList.setAllRelationships(this.m_joinRelationshipList);
            }
            catch (Exception e) {
                this.addInternalError(e);
            }
            this.m_joinTree.setJoinLists(this.m_joinList, this.m_joinRelationshipList);
            this.m_joinProperties.setJoinLists(this.m_joinList, this.m_joinRelationshipList);
        }
    }

    public void setSelectedJoinReleationship(JoinRelationship joinRel) {
        block0: for (int index = 0; index < this.m_joinList.size(); ++index) {
            Join join = this.m_joinList.elementAt(index);
            JoinRelationshipList relList = join.getRelationships();
            for (int relIndex = 0; relList != null && relIndex < relList.size(); ++relIndex) {
                if (!relList.elementAt(relIndex).toString().equals(joinRel)) continue;
                this.m_joinTree.setSelectedJoin(join);
                this.m_joinProperties.setSelectedJoinReleationship(joinRel);
                continue block0;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("selected")) {
            this.m_joinProperties.setJoin((Join)e.getNewValue());
        }
        if (propertyName.equals("joins")) {
            this.m_joinProperties.setJoinLists(this.m_joinList, this.m_joinRelationshipList);
        }
        if (propertyName.equals("joins")) {
            this.m_joinTree.setJoinLists(this.m_joinList, this.m_joinRelationshipList);
        }
    }
}

