/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.client;

import com.sas.svcs.security.authentication.client.CredentialCachingCallbackHandler;
import com.sas.svcs.security.authentication.client.LogonFailureException;
import com.sas.svcs.security.authentication.client.LogoutFailureException;
import com.sas.svcs.security.authentication.client.TicketCreationException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

public class AuthenticationClient {
    private static final Logger logger = LogManager.getLogger(AuthenticationClient.class);
    protected static final String REST_ENDPOINT = "/v1/tickets";
    protected static final String LOGON_ENDPOINT = "/login";
    protected static final String DECRIPTTGC_ENDPOINT = "/retrieveTGT";
    protected String LOGON_EXECUTION = "execution=aa39aab1-26b2-4ef5-8f54-d2cecd33c4b9_ZXlKaGJHY2lPaUpJVXpVeE1pSXNJblI1Y0NJNklrcFhWQ0lzSW10cFpDSTZJbVkyTVRBMFl6SmxMV1V6TlRjdE5EZGpNaTA1TkRJd0xXUmtZVEZrTTJZMk5qWTBZU0o5LmtEaVQ1TTM4VXZYS1Q3dlNYUDdDX0dJck1uSGIxR1JnZy1ka3IxRDFTQ0NMRmZNMXFMeFdfUElkaWZLQnFudzdfSDhKSFRiWEhIMENFQjJWZGU2ZzNJQU9HcjV2WTV1QVFJc0pROVNybTZkN3BtaXdJaXVQWElyM1VCMkprT3lQNGp6ZlQ3Snhtd1o0cURUdjdxd0U2TFhMZUt5MVNnbDlWUklkQU8tSXJlNTNBdjV6bk82Q2FXRkNRMDdBYmJlTWtZcG5fNEpyWWt6LVRVU3pBc0ZOY1U1U2habkdublJmazRRZW9VbnpzMHg3bmc3NHNjRGl1b28xX0Y5VXg3R0wxemJndlZkbEl0ZXJncjJYX2d1VjhCRDE2TTZ0VlJGSVlCZThRb1lBY01UamdyVWhIajl0MDlVZHYwTTNkaVBEQll0TElBb2lMYVZhV3lDU09BQ19sQ2t3YTQ0dURfcmoxZWVHZndFWm9PRlVsR05xOUd3VDRka3JlQ0FKX2xnbjRRM1RSR3JuTVpSbVNGTzAtR3FlbU1hTVFtZmNUdWs2YTFnRi0weldCRFVxZmVTMGVfNUpBc1hJQ0dnR0lqeDVRcW0xa2hlanFuZDFVUE9uNm9wZXU3WHEyeWdEeC1jZ3psNE9aNUF5QWhOUlFxanpPNXpiQVhNNTJDdTBfa3BiSTJHOGlPTjh3WlJVRWtPOF9UczJxV09RN1RVVVZSRnVaeHdLN2JsNVl1NnlXWnpjN0ZubE9MRlpjTElYbzRMSkltTXVJWkpLeXpCS09sSVA0YkVIXzJ1Q2ZNOVc5NHphWDhmbWZlVWNnTGNfbWFEalN6amR6NXVHZXRoZnhMakdSZUY4TXI0a19ibVFfejZUX0Y5aEdiUC01cUtSZE5JZkhqblJsQXJQTTJfcUMwc2V3VTZ2bS16RnA3NVphUlFpTm51eUhUc01URmxCTUpMTlNHbWhzeEFackUzM2xlb1pRVnhGNnBuVW9YRTdnanZibjhVdWprMTlORjhWMWxpdGlMY3hlRVVEUU9sQy1lRFU3WUhieEV6WVlvaVJUOW5DOUF4cUI4Qm1DQzJOMDV4ckdGZXBZTF9KZVRBQUcxRkFVNnRxTzJydnNDZnNDM3p6WjBxY0NPVEZRenRkT0tfUXM4SWRfOG0zVUN5WFQyS3htRHkyUTZFYV9HQ1N1eG9oUWxpV0RsQU1LZWtmczlEMmxCcHpJMUtRV3BiYXd2djFsN29tamFYTUZNeTF3emR5UUx1LTVmbjBJalRfRm9mb0Rhcm5OOTdQN29LTGFYakJiYTdObENPTTNKNnlOanktUkVDbkFKekRsa2ljZG8wQ252am80dWZaazJhLTd3TE91a2J1TWEzV25qV1dSaUVFSVdRek1DRHRwbUZvS1lNTHk2Q1NwLWdscTFfQ2JqdlE2elBsZ3lRSUpObjlYS1h2Qm5TTENyQzZxQ0lYSFQ3dnJySEpfWWdyRnlXc0xRWHhmVU90aVl3VktXN3J5aVYzLTRFNjJMOUJ2a2tLZkVxMzEwdVlMb0xuLVNtVjRhWENfSTFNRkNOYW5mZGY4YV9wMXN6YXZMTktReUJDaU0yM2hCWXFMbmF5LWFYZTY1OVBWRnhNaDhaTU5CVXBmUU9Jb2ZQWmwzY3E4YzdvaGlFdjBGb0FrcjVLLlZqdGFEVWdnRkwwNjAybDFIQWZVQmxRX1lkV1pBdEllUlh0OG5LQ3h4a3pLTjU5enFsUjVYaU1OUmpsTm9jeUIwTS1OcHhJcnBhZ0VBdG1UdUdCa3VR&_eventId=submit&fallback=true&";
    private String mfaExecution;
    private String SIMPLEMFA_EXECUTION = "5d9adf0b-d69b-40db-bf1e-310d682bf254_ZXlKaGJHY2lPaUpJVXpVeE1pSXNJblI1Y0NJNklrcFhWQ0lzSW10cFpDSTZJamN4TTJNeE56Y3lMVFV6TlRrdE5EazRZUzA1TURaakxXSm1ZbU5tTlRnd1lUVTJaU0o5LmtEaVQ1TTM4VXZYS1Q1TzhtQjM2WGk4bV8zV1hWYjFqOHhiaFhpckNuMDVFTkRfVDdUdjdzdHhONnREX2xrUzUydDhIOXlLUGFBaF9JN1FReFhienM2VlUydUdKX2tSUnNrNlVwSkRLc0dMeDltdUJHSXNjRG1wZlpuYjFvaG9wWTNCZURDT3JFRDhIX0F2SjU5QkNSRzBORGk4a3JLUFZKM3dBalJVQU5wSG5Lb3NtQjNta3dhbzBlR0xuWGRxcFI1ZE0tdTNGWkhjR3EyMXpuTmw2cXR2Qk5qeE9aSTFLUGNkSjgtYjZ4R3lTLURTcjdBUkxzN1p0OTRrVmx1SGtCaTVXMDVjeUxoRDdBVzVFYmtCM3U2YXpURGRMZ1c5WEFLNDNYVFNnd1JTamZDZklWMVlRZk5hMUpmekZ1TWdHMWFuVGRKV3pJbzV3ajEyeFA2cnJ6MlJiVDc4aFhUdHBaODBJMHJHYmkzN3NHc0pmaHdhQnhGS1BaWjBGRnBXME9Kamw2UjBaRXlJNkdWSTdENWFZcDhNOWVxODd4bzl0Uk1zVUpiWU9PWThyRWhTMzF0NmhIZWFtTnJDY0NqVFpTZWwza2JhTUl3bFAzR2pEOGpnOVpQYi1kYks5akZxajFMUGtiSFRtRXRHVWNnTHpCdEFObkk2Vy1rQzc4T1REaHQ2WmlDRGJ6TXJOVjE0dU0wOUtTTDFiUVFIajVEaVZmQUd6cUF5Y05YNkNhWnlDVjFSUU9YWUE1ZmtNakFwcXJTd0M1bF90RVhzamE4eVRxYlJBVDdPWG83THNPdlVXQkJmN1A2WE1YRms5S1pScmsxUEZfZG1sak5jR2tmYU1ZeWVtdTFzOHZrYlczYkl0WVNUV3JubEhESk1iUFRrVm5CTjVubDRpQ1ZHT05SX0lmMG1SOHg5bTV1QzJNRnJ4b3FxeENrVnJWeUNMS3NDd2RPbFEtMm9mT28xaDRXekJJeXc1eEVtS2pPT3VUUDROdWo1cVRCQ1lLV3F6NThldVFHNm0ydmZoTjYwTFFlV0d4YVFxNHE2M29FSExYc1hZZlR4UDZVSzd4WHN4ZTFOeGJCb0VpTjBNLS1Bc1ZCb0JTRkpkYjNSQXRkLVNzN2xqZGJlZ0RHWUNOZUZ4cWtKaGRMSVNXZEppR0dUTnI5a19LODFwNzF2aHVRZUlJOFl2Q1dMSzF2ZDkyTjhQc2p1d2UzYWY5VTRPV0t1SnJERDF6SDdIdGZzTlFCdmZSSmJKdDhHcG96MW5ubXNJZnZ2QzRkWmlEMkE0d2YxamdCNXhZZDN2SWF5Q3NvbDZKUUZfVUsycWhnWlBTWVVMVlJFejhFNTZySW50R2JkcHl6WXhLb1VkaVEza0xRbURabmNFTXlSdTV1WldZVjBQYXNSWXBYQTVqd3pycXdQd2xjV0lIX1JsVXZkSnYzN1NKLUZEdDFIZ09heWRTbW5yWElUMFNXd1hDbE9jOUtPcXN2MnB1bDdWSk93V2FKemlQUTlRQ3lBUlhSVS1uNVl4ZHBTVUtheUlxeTE4WHJuZU9wamhZek12NElDeVMwdmljQ0dmYzkwd2Mwb2lLWEZUOFlmWDluZG0wYnlHZ1o2T0VKMExGVHNjcUR6X1hCaFpnRG4wRDVOYjUtS1VWNlU5U0t6NGNPYnd0NkZ6UTg4LTJqWVpQdlZhQW90MnBoajdpWDc0Wl9hdHhBUHUweVBIVGFUNDZIRDZnd0Q3RmZUN1M0VWhGcDFLX3h0dEdIOHJ1cmw2cXJUMURnUENZVTR0ODBGcVFTWWM0Si1SUE0zbEdxYUFNcjlfNTlZekVscjU1UVFmTloxQy1KT2k2MUd5bUxBd2psMElsV3lnZmloaFN1TDhQaG1KZEl2Umd0NG1vc1BqenpuV29JcklxclJRQjJYb2NMYXl3WjRFbUxNYzF1MXlyaWVBdkJnWjlvTTdlSEFlOXpRSzJHWDJmQ3RYWnExUmk1WDhkNDFCVC1haElDTmdDNmtEYmxTdzRlQUJrSWxHeUFpa2RyYWV5bEtER01MVEgydlN1a0I3elMzRGFHRlA3NzhvdDUxYzY2dzZUdzEzWmNpTlVSMVJHVVFJT2U0Mk9WMHlKWHdQNXNaUWlhY28tQVFuRDlhanRqTXhVMXNsWnZzZ3NhdE4zRFJMaVhqbk53SkFKQmhZV2VxRmplNHJ3aTVacjVsWGdoamxXSkJod20tcWtlNTluaHZEVDRKTGJlOE1memxfQ28tV2pydkdHY0hPNUZKY1g3RnllUUdmVFNhZmZsS1JGWXRQM0F5M3BtTGYzbXltQXZwaW1yS0MxWkNtbnRoSmRaTE9tNk1fSlI4blVkVkZ6cmFyUEZaRmhvdGMxSXF5UEFCc0I4bzF6OGw1NlV2WWVEanJVWW9YYkFLbUFnTmZPRFNnQ2w2Ri1pazJuWFQtMXcxdWxWNGkyNmtCakZ2dkJ2TWY2UzUxQ0VpcUNuSlV2ZDN1T1NLSzAxbUU0V0tDVmhUTmxUWHU2dlFjMkpNZ1E0VjJzanFyUGJaMFhvQ3p0QTBlLWxVUkF3dXdZNHMyWExJSjdTWTZQYmI3eVh2WUkzbE1sV0ZCNFBXX1U0OFFUWUFVZ2dSUmFFRW94RjRzdTNsdEJmSmNTUGtMbEIxVzhhanQzLVAzcVEwZGlfYXBfVHYzZ2dnX1dNd0txTHhMTkM3SFZoVXVRcldtZHdRdVVzUHdWRERSUXZNMEl1cEJBSFpmNW1KckJYeDEtRW9GOTRxUGhsV0FOYVhGeVRKTmtqamVZRmd1ZEozOWI3NkpWaHg4VEdQeUo4d2R0S1JJanlaLVkybnJuSW5hN3MwVDhyUVkxSzZKZGFpQXotN1ZiY2VhNkhCcG1wYjZYcm5USkdFUkJ0SEppNm0tTjdJN3h4TGRwYXJCOTM5WTlmQWU5UlhlR2FOUnZHRFlydm5nSGsxNXNOMURaajlPVDVOYnVxd2V4aUs2ckZFRkFnOHk5WkVKdU56MnVkZXpyaWlsVHo0RzNoQjZ4aDNwS3AyVGZ2UUZhX1U1enFzLUpnU2NrdWcyamVJT0RBcGFNYjhYa0c4TFA2T0hQWk5CTU5lTkQxRnZWaE9yc0hkTkFGOHhnUXNIU3FsWlo0YWJqaWJ5aUwwVHI0ZGh6czBxNnRqellMeE9EaXhFTnlQZmhXRWE5VE1wb3hudHI4UE83MHlZS2xVN21zenlqT2NfLThVYkJGdlRILVFDNGo5d0RmTXlNNHhXSkUzZ1ZYZUpmTVFDR2pwNkt1bDJFekpZejJxVTlpbWFLZXkwYlRMZlJ0VHJUblc1VlFuaTdzWDBoS2lMaTUyNDk2NDFVZWJlX190TFcydHVqREhlYXl3Vmx6NXRDdWJrUnRUcDdETlhzeEJoeUdubG5HQzhtVmdLTDEwN01CNHh5LWc4UnZOTXVPQXlJUnVwbThpMGM4T1RmZ2ZMTUJmTkM5U2hLYjU5eWJockxFRG9NR1ZhTlA4ZDJ2dzJZUWwzc1lZdXl1WEE5SnVmaTFUQUE0MERsVGZ5WVlkN3p0dGpXTUZyT1lNZGN6Zlo2VTRKcVFQTS0zeERHcHBUQVZWOWhDY3hlWlZRV29GTFRrZ3N3NEJnd0w5RmxQLVpzY2tTd1BvWFczVGpsMnZOSElaZ0JIQzVfdFVMRlBwRHctQkZpUUstWjd3SXh6Y1NsU1dULW1IMXlHUDBhSTlKVGZHTV9sTE5jTHhzaXh0c09nYWQ2VlkzOFpNVnFmOFQ1ZG85R21zX2pkX0l3SWV0WU91a3dwTDJ2RzJ5aUp3M0ZTWVJNVXE1OXpXSl9TbEc4ZUdjcklucUZWTC02cDF1d0o4TTJtX2hackNSTldfRDVsUkl6bGJ6Qlc3RDl3MGgwYl9aaWozdk5BR1FMQlNVQUlnYXlhM3MwV3lmdlZLZ2VNWmdUbTJpaGpMR3oxMG5aRWRIZDFuWVA5N2dOZExGeVRtbE5aZzAzNFJBY1JHRDkzQUxhSlNIMnNkdlZLTk5hQjNWU1FsVTR5bmUtWllsNG5OQ2d5SGNLTnV0V01aamxYVVhFaTR6VkhaN1ZsVXR6dVZIOGFKX1BxRzRfaDd3SFBlUDk5X1NiUVlfLU9BZmltMDByVVNhSWtnUXpJczYxbzV6bWpYN3d0VG5Zcy1rVlZoX1pzX0gxeW01LVJDN2I5WkNoQ09TanhfZEhFZ3BjTHB5Tkg0SE9FbXN1LURJSXQ1b0kxbk9NckcwdFVaUUNYLU5XRHNMSXVUMkFOY2RRc0R6bTh1a1Z5TFgxc19sYkdVXzlLMG1uMF9HcmpvWXVEcGc0cUEyRWZ5UHRub29zd29HeEJqVVRPaTIzMjRlNDBCVVltQ2pXX2pRcnBSRUJueE80NUV1SVBSMDJIQTN6bDQxQUp3LXpkcW9RbnpyUFZ4RXRocDZibnZYMVRRRVp2VERhLXkyZWJqRzZUUC1CbGtCdkhyM3c1WU9sTUd3dXV1WGluaXRJdGY4RzQzMTFCNUFqd040SnoxaEpQdzVaWjBjazVMNHFiZlRweWlMZFdJaDdSSFVoc1BBc1FzNVVCbS1iRGV3RnpoakFHRlN4OXhOTGdvQVQ4SGZTd3phUFdPWTJsRnhqN0lXam5yVUhkNjJPdlpvM3FmSkk5MGJ5SjBjQ20zdml6VkMwNVJudW9XcHBBeEhLTnUxcXR0Q3NhZnlfMTBNUXh2VEk4TU9SYkNUNFY4TlVlZTVublVVZi14OUROdHNQel9SOTY2eVhEeUFxb3dYNmNqclBGdXhxcVZpYk5OZzJEZkViNjdPenhNNC1vWHV0UlNzd2tjOXdrblJkUHd5LU0yem8wUnlaX3VWTU9HQWNzSEZPSHo4ZnFoZzg3UzZsU29UV1QtQXR5N0xLSl9KTEhYRVkzY0Vid0o3c2dXRTI3VTdoNlRPQVJ3UGxUM2NPMDZRSThXdEVWckVVUEtSZDlIYjQ0OHhNT3hUWDVmSmR5bWdiaVllRGpQUWRJdm1GeTNOOG9JTWlIQUp6dG9Ha25mWklTY2NlX3RTUWJaUUZBUFp5LXZxcmlYREJVUzZIMWRtb0VlLWZ5YzZ2SHk3TkNadGJTTUJsME02QUtIUG83Z2NhdU5BcXh5emJQX0pDNU12Z1BUQ3dpbWFaM2xyRjZhRDl4WDY3TEVISHV0NDlsZlk4MnVuelFnelM3d29qejR5MU9qZWhfQmdqa0hOSGpfbnYzWVJybmVZeUtrZFc3UjVWSkRtbXNOWXVSdE5NTEtNN1RVZlhpdnNJMm81OE9sZEZwRDh3Tk1WM2NqOEVWM2xJTTFUUHFOVlkwYzFFYU9zUm9XSWFYRDFpVXYzckJWempHOVNNQU4zNUlINEF5MDY4TE1zNGtKWnRudE1xbW1HTWZvalphVU9lTWU2OHR6VkxITkJqdWNwYUFRQy1KeEduQl95d3NPbFFmakIwbVZNd1lUckRTNWlQUUphcE9ENTFCMmd5WEhIVGx1Um11ZjJVblpFTEI1M0MzM1lPZWY5aVhPLUoxX2VsTmpjQ2VBVnBlVGFscUFOVi1meVVxd0lxYWZrdDNuX3ZEVnZYOUZWLW5RdjZqOXF1eXZGclNZOW1mRXpJQURsSW5OUUFXX185NXBFaFdZMlJfdGtBTDhQSkUtRkhYOUNyR21JN3FUQzVQdC1LVXBtLUI5V09zWVUtc2pKTDdJc3lXQnQ5d2F1Sm1ZaExEY25ZdkptYWl5RUhNRnhpLTFMQ0ZuZDM5QTZINWxNVkZLYkttWGxwd1lMRHRLaHpTQjhIcThhTDMwVF9UYXlFbWdPRE90X1RlQXhQYWM5SjBQb3g2cExKSFR2QWtMTnYtemQ1T0Z3OU1mUzF6NGdQWXlPN1F0X3NOdnpmbURpVmg5SC1LNnQ2TlBDbE0wVFl0MDFyZlVUOWxBVUJLMmd0eUlfOWZmUmE2dzJvNnNKaFFsaUFESzh3ZThOSzE2aHVYek1jelRUT1YtLWpKcUYzcnRFU1QyUTZqdGd0d3Q4ck0zUDA4aE1ZM2d6OFFBYWFSUFdjZ2RqSzdjZFpDY3hWeGhUZC03QTZKc2JfUXVTSGhDTVAzUjZMRnpodTRMMU9xWU1jQjE2X3FMQmhZa0NucnNWc1hxS1Q5d3paaTBGQV92Q2pNcDE0WFAwSEVvYS1IZE9xWWhHbFBwRDJPalVmYUxYRDR0bEJfTGV3MHU5ZEItZDhjcTZYdU03REUyYXlQWEpYVm9GZGpFcl9iMGdrR3VOUUxyZlJmR2ZDdl9pX3dMQ09ZUnZ2RGFBbDY5SkJ0LVc3Ynd0SjdhNnkwQmc5X3RZMmpNaGRJVU5VOUJNNmwxQUx1eHprTTJJVlp1SW1iRlFPcVhBeUFHUUNqUTkxTVdNMF82YkhuMHBxWHMwaWh1Y1hPSnVnZndqdmR6MHUzZnNKcGFEclBnZWlFS2JCYkpLUHZHSHZETlFCMVM3ZGktcnI5VE9mOS1xRW9zQXdvVTJaa3ZiemtBQ0dJblQwQkJvdzltLUpCS0RrTklacDA1cGd4STVIQ3lTWXgwa01NbjdyNlNmMi1uRW9qbnBDNl92ZDlZN1d2WGt6TXg1SlVvbHlrY0dhZ3Voczk5WThPdFBIVkpjVklBa19ldndObndyazJRRXpqOUdyVTZUZ0phUGZ3NHJhbXNGaW42a2luUVU1MGFGZEQyNTd0LVc5WGFuX3FqZXFhdUR2OGU2NkpEb0JCVDFIbG1DSkdTZnFYY1RFYW95U2FzRU1UdWhiZENJMFFnT1RpZVl1cmJVQzA2SmRPZHl1QVI4aU0yTmIySElhN29QOEVLUEtZTmtobWFMTUFCcEQ0X1E0X2k3UkRadDE3bUVhbXQ0QUZsN2xkWFFodjBCclFyRVJkMzhqTmYteXlNWDdqVjRoOXlIa0N4Zy1lRXBKbjNRR3VFV0RxTGJWd28ySzdTbURiZ2s5UF9RclgwYWk4NDhTODhHUExGNHZYcC1hZmVxVHAwNUZvNmZSVUU0b195N3JnN2ZVTnhIcGlRMldYSXNYQ0w3UVl1Yko1ZlZ4bURkcXVmcGU3X3ZnempJdHJGRFN3Yl9MTGUxNGx0ay14TC1NbUxSMnF5bmstR3VZc1dWYllfbFp2akVXSmtkNlFMaDR1bGFMWWNjbmViNXNTREE1WjNOY2RRQnFYZjlYNy1ObzktVUV0VmtOZjRtWjhDZ0pGVzZRelFTUmI3T3JIN19GLVdIM3hnUWRmOEI5MGxJQUpFSmpCdWlYal9GWFJ3R1pSYy03R1JfZlAta216SncwR2xUMkFZX2ZibFRtbFFfbUlZeGVCOHJuRTVZTjhud3RMWkZKejdHVGtLQUU1Y25GS29nUXN2aVFFMkFIeHJjck4yczEyQ0stVFh3eTVLbklqY0xmY1JaZmtnX1NnMEhzbmZ1Xy1XelcydEJBYmdPTWpSNHVHS2tRNVh6Q1FvZkxXS012OVg0anpMeXhCTW94X1J1eVNKU3I4V2xpMmlyaXNKQkQyT2ltQWdUZy1PUl9hakpCQ3JldTAtSnViMWtqZURneWU1YzBXRlF6a2FMQzV1UlI4dWdwOWc4RmRlZUppVjVnUlZVNUNvaDhPZkJvdzB6SXNKWkg5M3pCbUw0WFJzazlmVkNBTnFLYWdIR0lTMjBpbzNCZk1BWVZZdURncXJJcXBkMkZ1aHZHN0xOXzViUTh6eTRzWTREWmlWaVVvR0NpREdIcXY2VXpJMnhKRkYwR0J0SWZSMGx5d0xGdWhaMENLanplbGNnaU1idXpQMEJQWkpfQlpyd19ocXV5Q1loajZNMndxcklnbmtERXN4YkpRc2pFUEVHeHhZQWxnWExiNENwUlY2ampLTHRRT1JpUEFqemdKZzN0QzQ2WUp1SDAyMUpjcGtzYVhjR1JCY3VLOVIwR0l1MVdLWVQwTGRvT1l2OGk5TUk0cFVzT09ua1hMemd3YU9RcnhybE1YUXIwWlpyTUhiSVF6NHpoX0MwVXU4NHZYN3U4THdiNUc5OXE0QXhVdXk1eVdsbDRtdEp1WW0tN3pNUFhjZ2l2Z1VmTWFIcllqeGZNdU42MFVDS2ZYMkxaYlhfN1VWR1hvZlZCU2N1c01Qb3lxdVk0cXFSQ1FiRXVyQjAyWTQ5RUVWN1Y3NXZtTjhGMm0zRG5feHJCc3lrUFI4ZmpmXzZzaW50d2FRbjB3UW5feXJFMlJoT0tJbTVwSmdHMGRpaGVlMjhMVTZUY2RWajJvaWdOblE1V0Q3Y25QLVZ6U2VZNFhPcVcxOXVCajRtbmtvWjd6SkJ2U2xWWndwa29ENkowMGEzRnZQTHdfQ1Ytb2xibEhzTWpkVFQ5b19sTTJmZHJuXzZEQ1B1d3RyNFBXYWpuNG1XNUpBTXJnV05lc1Y4YzEyYWZTUjFiMm5Ja1FBRHhUZ1RRZzFiVnBTVkFxbTJ1cktoMDZBd1ExZEhKYTNwMjdWekJoaklERnZxMGNCekxyMW00dW1KRkJYc2RTc1V2Skl3d1k5WTFIYTUyS2l4S08zNktMaUdrUVFfVTVnSDVRemw2aUdhTUNaNkVsRUxWSmRUbGQ1cC1rYXFiMXgwSkZUdjRvVVFDYUtoOE54cWlvQjY2VDc5UjNuZy5jcTZ0NDlaYXBaRnRadEJZNVdqZXdjZEJFd1RZQWlWYkt4UDRYTFZRVk96QWphYkFIV3R0bGdMaDlDTzdnMlI3OG5FbFBOdDJ1YTF3aUV2M3V0bXU3Zw%3D%3D";
    private boolean serverMfaEnabled;
    private boolean participateMfa;
    private String mfaProvider;
    private String registeredAccountIds;
    private boolean needToRegister;
    private String qrCode;
    private String secretKey;
    private String accountId;
    private String deviceName;
    private String registrationDate;
    private String selectDeviceExecutionId;
    private CallbackHandler handler;
    RestTemplate template;
    String casUrl;
    String ticketGrantingTicket;
    String ticketGrantingTicketUrl;
    boolean scrubUrl = true;
    boolean appendAuthClientParameter;
    private String[] scratchCodes;

    public AuthenticationClient(String casUrl, ClientHttpRequestFactory requestFactory) {
        this.casUrl = casUrl;
        this.template = null != requestFactory ? new RestTemplate(requestFactory) : new RestTemplate();
        this.template.setErrorHandler((ResponseErrorHandler)new ErrorHandler());
    }

    public AuthenticationClient(String casUrl, String ticketGrantingTicket, ClientHttpRequestFactory requestFactory) {
        this(casUrl, requestFactory);
        this.setTicketGrantingTicket(ticketGrantingTicket);
    }

    public AuthenticationClient(String casUrl) {
        this(casUrl, (ClientHttpRequestFactory)null);
    }

    public AuthenticationClient(String casUrl, String ticketGrantingTicket) {
        this(casUrl, ticketGrantingTicket, null);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.template.setRequestFactory(requestFactory);
    }

    public void setScrubUrl(boolean scrubUrl) {
        this.scrubUrl = scrubUrl;
    }

    public void setAppendAuthClientParameter(boolean appendAuthClientParameter) {
        this.appendAuthClientParameter = appendAuthClientParameter;
    }

    public void logon(String userid, String password) {
        this.logon(userid, password, true);
    }

    public void logon(CallbackHandler handler) {
        NameCallback name = new NameCallback("Userid");
        PasswordCallback pwcb = new PasswordCallback("Password", false);
        try {
            handler.handle(new Callback[]{name, pwcb});
        }
        catch (IOException e) {
            logger.error("Error retrieving username/password from callback '" + handler.getClass().getName() + "'", (Throwable)e);
            throw new LogonFailureException("Error obtaining userid and password from handler to log on", (Throwable)e);
        }
        catch (UnsupportedCallbackException e) {
            logger.error("Error retrieving username/password from callback '" + handler.getClass().getName() + "'", (Throwable)e);
            throw new LogonFailureException("Error obtaining userid and password from handler to log on", (Throwable)e);
        }
        String userid = name.getName();
        if (null == userid) {
            logger.error("Handler '" + handler.getClass().getName() + "' did not provide userid to log on");
            throw new LogonFailureException("Could not obtain userid to log on");
        }
        if (this.whetherParticipateMfa()) {
            this.doLogonWithMFA(userid, new String(pwcb.getPassword()));
        } else {
            this.doLogon(userid, new String(pwcb.getPassword()));
        }
        this.handler = handler;
    }

    protected void doLogon(String userid, String password) {
        userid = this.encodeQueryParameter(userid);
        password = this.encodeQueryParameter(password);
        String parameters = "username=" + userid + "&password=" + password;
        if (this.appendAuthClientParameter) {
            parameters = parameters + "&authClientRequest=true";
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        org.springframework.http.HttpEntity request = new org.springframework.http.HttpEntity((Object)parameters, (MultiValueMap)requestHeaders);
        ResponseEntity response = this.template.exchange(this.casUrl + REST_ENDPOINT, HttpMethod.POST, request, String.class, new Object[0]);
        HttpStatusCode statusCode = response.getStatusCode();
        if (statusCode instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)statusCode;
            if (HttpStatus.CREATED != httpStatus) {
                LogonFailureException.Status status;
                String message = "Unable to logon user: " + userid;
                switch (httpStatus) {
                    case BAD_REQUEST: 
                    case UNAUTHORIZED: {
                        message = message + " (bad credentials) ";
                        status = LogonFailureException.Status.BAD_REQUEST;
                        break;
                    }
                    case NOT_FOUND: {
                        message = message + " (server not responding) ";
                        status = LogonFailureException.Status.NOT_FOUND;
                        break;
                    }
                    case INTERNAL_SERVER_ERROR: {
                        message = message + " (error occurred on server) ";
                        status = LogonFailureException.Status.SERVER_ERROR;
                        break;
                    }
                    default: {
                        message = message + " (unrecognized error " + response.getStatusCode() + ") ";
                        status = LogonFailureException.Status.UNRECOGNIZED_ERROR;
                    }
                }
                throw new LogonFailureException(status, message + (String)response.getBody());
            }
        } else {
            throw new LogonFailureException("Type of status code is not correct: " + statusCode + (String)response.getBody());
        }
        HttpHeaders headers = response.getHeaders();
        this.ticketGrantingTicketUrl = this.scrubUrl(headers.getLocation().toString());
        int tgtLoc = this.ticketGrantingTicketUrl.lastIndexOf("/");
        if (tgtLoc > -1 && tgtLoc + 1 < this.ticketGrantingTicketUrl.length()) {
            this.ticketGrantingTicket = this.ticketGrantingTicketUrl.substring(tgtLoc + 1);
        }
        logger.debug("Created ticket granting ticket: " + this.ticketGrantingTicketUrl);
    }

    public boolean isServerEnabled(String userid, String password) {
        userid = this.encodeQueryParameter(userid);
        password = this.encodeQueryParameter(password);
        String parameters = this.LOGON_EXECUTION + "username=" + userid + "&password=" + password;
        if (this.appendAuthClientParameter) {
            parameters = parameters + "&authClientRequest=true";
        }
        HttpPost httpPost = new HttpPost(this.casUrl + LOGON_ENDPOINT);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            HttpEntity entity;
            String string;
            StringEntity requestEntity = new StringEntity(parameters);
            httpPost.setEntity((HttpEntity)requestEntity);
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String message = "Unable to logon user: " + userid;
                this.logonFailureException(statusCode, message);
            }
            if ((string = EntityUtils.toString((HttpEntity)(entity = httpResponse.getEntity()), (String)"utf-8")) == null) {
                throw new LogonFailureException(LogonFailureException.Status.UNRECOGNIZED_ERROR, "Response content is null!");
            }
            EntityUtils.consume((HttpEntity)entity);
            if (string.indexOf("javascript:window.location.href='logout'") < 0 && string.indexOf("id=\"mfa-provider\"") > -1) {
                this.setServerMfaEnabled(true);
                this.getMfaExecutionId(string);
                if (string.indexOf("value=\"mfa-gauth\"") > -1) {
                    this.setMfaProvider("mfa-gauth");
                } else if (string.indexOf("value=\"mfa-simple\"") > -1) {
                    this.setMfaProvider("mfa-simple");
                    logger.info("Sent out MFA token!");
                }
            } else {
                this.setServerMfaEnabled(false);
            }
        }
        catch (Exception e) {
            throw new LogonFailureException("Unable to logon user: " + userid + "! Error messages: " + e.getLocalizedMessage());
        }
        return this.isServerMfaEnabled();
    }

    protected void doLogonWithMFA(String userid, String password) {
        userid = this.encodeQueryParameter(userid);
        password = this.encodeQueryParameter(password);
        String parameters = this.LOGON_EXECUTION + "username=" + userid + "&password=" + password;
        if (this.appendAuthClientParameter) {
            parameters = parameters + "&authClientRequest=true";
        }
        HttpPost httpPost = new HttpPost(this.casUrl + LOGON_ENDPOINT);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setHeader("Accept-Encoded-Password", "Yes");
        try {
            HttpEntity entity;
            String string;
            StringEntity requestEntity = new StringEntity(parameters);
            httpPost.setEntity((HttpEntity)requestEntity);
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String message = "Unable to logon user: " + userid;
                this.logonFailureException(statusCode, message);
            }
            if ((string = EntityUtils.toString((HttpEntity)(entity = httpResponse.getEntity()), (String)"utf-8")) == null) {
                throw new LogonFailureException(LogonFailureException.Status.UNRECOGNIZED_ERROR, "Response content is null!");
            }
            EntityUtils.consume((HttpEntity)entity);
            if (string.indexOf("javascript:window.location.href='logout'") < 0 && string.indexOf("id=\"mfa-provider\"") > -1) {
                this.setServerMfaEnabled(true);
                this.getMfaExecutionId(string);
                if (string.indexOf("value=\"mfa-gauth\"") > -1) {
                    this.setMfaProvider("mfa-gauth");
                    if (string.indexOf("name=\"_eventId_submit\" value=\"Confirm\"") > -1) {
                        this.setNeedToRegister(true);
                        this.setSecretKeyForRegister(string);
                        this.setQrCodeForRegister(string);
                        this.setScratchCodesForRegister(string);
                        logger.debug("Need to register your device with secretk key: " + this.getSecretKey() + " to user id " + userid);
                    } else {
                        this.enabledAccountIds(client);
                    }
                } else if (string.indexOf("value=\"mfa-simple\"") > -1) {
                    this.setMfaProvider("mfa-simple");
                    logger.info("Sent out MFA token!");
                }
            } else {
                this.setServerMfaEnabled(false);
                this.retrieveTGT(client);
            }
        }
        catch (Exception e) {
            throw new LogonFailureException("Unable to logon user: " + userid + "! Error messages: " + e.getLocalizedMessage());
        }
    }

    private void getMfaExecutionId(String string) {
        string = string.substring(string.indexOf("name=\"execution\"") + 16);
        string = string.substring(string.indexOf("value=\"") + 7);
        string = string.substring(0, string.indexOf("\""));
        this.setMfaExecution(string);
    }

    private void setSecretKeyForRegister(String string) {
        String secretKey = string.substring(string.indexOf("<pre>") + 5, string.indexOf("</pre>"));
        this.setSecretKey(secretKey);
    }

    private void setQrCodeForRegister(String string) {
        String qrCode = string.substring(string.indexOf("id=\"imageQRCode\" src=\"data:image/jpeg;base64,") + 45, string.indexOf("\" alt=\"QR code\""));
        this.setQrCode(qrCode);
    }

    private void setScratchCodesForRegister(String string) {
        ArrayList<String> scratchCodesList = new ArrayList<String>();
        String scratchCodesString = string.substring(string.indexOf("id=\"scratchcodes\"") + 18);
        scratchCodesString = scratchCodesString.substring(0, scratchCodesString.indexOf("<div class=\"content\">"));
        scratchCodesString = scratchCodesString.substring(scratchCodesString.indexOf("<span class=\"") + 13);
        scratchCodesString = scratchCodesString.substring(scratchCodesString.indexOf("\">") + 2);
        scratchCodesList.add(scratchCodesString.substring(0, scratchCodesString.indexOf("</span>")));
        while (scratchCodesString.indexOf("<span class=\"") > -1) {
            scratchCodesString = scratchCodesString.substring(scratchCodesString.indexOf("</span>") + 7);
            scratchCodesString = scratchCodesString.substring(scratchCodesString.indexOf("<span class=\"") + 13);
            scratchCodesString = scratchCodesString.substring(scratchCodesString.indexOf("\">") + 2);
            scratchCodesList.add(scratchCodesString.substring(0, scratchCodesString.indexOf("</span>")));
        }
        this.scratchCodes = scratchCodesList.toArray(new String[0]);
    }

    private void enabledAccountIds(CloseableHttpClient client) {
        if (this.mfaProvider != null && this.mfaProvider.equalsIgnoreCase("mfa-gauth") && this.mfaExecution != null) {
            String parameters = "execution=" + this.mfaExecution + "&_eventId=select";
            HttpPost httpPost = new HttpPost(this.casUrl + LOGON_ENDPOINT);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                StringEntity requestEntity = new StringEntity(parameters);
                httpPost.setEntity((HttpEntity)requestEntity);
                CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    throw new LogonFailureException("Failed to get Authentication IDs! " + httpResponse.getStatusLine().getReasonPhrase());
                }
                HttpEntity entity = httpResponse.getEntity();
                String string = EntityUtils.toString((HttpEntity)entity);
                int start = string.indexOf("id=\"deviceList\"");
                int end = string.indexOf("<div class=\"border-bottom py-4\">");
                String value = string.substring(start + 23, end - 3);
                this.setRegisteredAccountIds(value);
                String id = value.substring(value.indexOf("id=") + 3);
                id = id.substring(0, id.indexOf(","));
                this.setAccountId(id);
                String name = value.substring(value.indexOf(", name=") + 7);
                name = name.substring(0, name.indexOf(","));
                this.setDeviceName(name);
                String date = value.substring(value.indexOf("registrationDate=") + 17);
                date = date.substring(0, date.indexOf(","));
                this.setRegistrationDate(date);
                String execution = string.substring(string.indexOf("name=\"execution\"") + 16);
                execution = execution.substring(execution.indexOf("value=\"") + 7);
                execution = execution.substring(0, execution.indexOf("\""));
                this.setSelectDeviceExecutionId(execution);
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Exception e) {
                throw new LogonFailureException("Failed to get Authentication IDs! Error messages: " + e.getLocalizedMessage());
            }
        }
    }

    private void logonFailureException(int statusCode, String message) {
        LogonFailureException.Status status;
        switch (statusCode) {
            case 400: 
            case 401: {
                message = message + " (bad credentials) ";
                status = LogonFailureException.Status.BAD_REQUEST;
                break;
            }
            case 404: {
                message = message + " (server not responding) ";
                status = LogonFailureException.Status.NOT_FOUND;
                break;
            }
            case 500: {
                message = message + " (error occurred on server) ";
                status = LogonFailureException.Status.SERVER_ERROR;
                break;
            }
            default: {
                message = message + " (unrecognized error " + statusCode + ") ";
                status = LogonFailureException.Status.UNRECOGNIZED_ERROR;
            }
        }
        throw new LogonFailureException(status, message);
    }

    public void registerDevice(String accountName, String token) {
        String parameters = "execution=" + this.mfaExecution + "&_eventId_submit=Confirm&geolocation=&accountName=" + accountName + "&token=" + token + "&registerButton";
        HttpPost httpPost = new HttpPost(this.casUrl + LOGON_ENDPOINT);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            StringEntity requestEntity = new StringEntity(parameters);
            httpPost.setEntity((HttpEntity)requestEntity);
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new LogonFailureException("Device register failed: " + accountName + "!" + httpResponse.getStatusLine().getReasonPhrase());
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            logger.info("Registered your device as " + accountName + "!");
        }
        catch (Exception e) {
            throw new LogonFailureException("Device register failed: " + accountName + "! Error messages: " + e.getLocalizedMessage());
        }
    }

    public void deleteDevice(String accountId) {
        String parameters = "execution=" + this.mfaExecution + "&accountId=" + accountId + "&_eventId=delete";
        if (this.selectDeviceExecutionId != null) {
            parameters = "execution=" + this.selectDeviceExecutionId + "&accountId=" + accountId + "&_eventId=delete";
        }
        HttpPost httpPost = new HttpPost(this.casUrl + LOGON_ENDPOINT);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            StringEntity requestEntity = new StringEntity(parameters);
            httpPost.setEntity((HttpEntity)requestEntity);
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new LogonFailureException("Failed to delete device for accountId: " + accountId + "!" + httpResponse.getStatusLine().getReasonPhrase());
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            this.setAccountId(null);
            this.setDeviceName(null);
            this.setRegisteredAccountIds(null);
            this.setSelectDeviceExecutionId(null);
            this.setRegistrationDate(null);
            logger.info("Deleted device for accountId: " + accountId + "!");
        }
        catch (Exception e) {
            throw new LogonFailureException("Failed to delete device for accountId: " + accountId + "!" + e.getLocalizedMessage());
        }
    }

    private void retrieveTGT(CloseableHttpClient client) throws IOException, ClientProtocolException {
        HttpGet get = new HttpGet(this.getCasUrl() + DECRIPTTGC_ENDPOINT);
        CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)get);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String message = "Unable to retrieve TGT from TGC: ";
            this.logonFailureException(statusCode, message);
        }
        if (null != httpResponse.getEntity()) {
            String responseEntityString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            if (responseEntityString.indexOf("\"") > -1) {
                String ticket = responseEntityString.substring(responseEntityString.indexOf("\"") + 1, responseEntityString.lastIndexOf("\""));
                this.setTicketGrantingTicket(ticket);
            } else {
                this.setTicketGrantingTicket(responseEntityString);
            }
        }
    }

    public void resendMFAToken() {
        if (this.mfaProvider.equalsIgnoreCase("mfa-simple")) {
            if (this.mfaExecution == null) {
                this.mfaExecution = this.SIMPLEMFA_EXECUTION;
            }
            String parameters = "execution=" + this.mfaExecution + "&_eventId=resend&geolocation=&token=&resend=";
            HttpPost httpPost = new HttpPost(this.casUrl + LOGON_ENDPOINT);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                StringEntity requestEntity = new StringEntity(parameters);
                httpPost.setEntity((HttpEntity)requestEntity);
                CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();
                CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    throw new LogonFailureException("Failed to resend MFA token!");
                }
            }
            catch (Exception e) {
                throw new LogonFailureException("Failed to resend MFA token! Error messages: " + e.getLocalizedMessage());
            }
        }
    }

    public void validateMFAToken(String token) {
        this.validateMFAToken(this.getAccountId(), token);
    }

    public void validateMFAToken(String accountId, String token) {
        token = this.encodeQueryParameter(token);
        String parameters = "";
        if (this.mfaExecution == null && this.mfaProvider.equalsIgnoreCase("mfa-simple")) {
            this.mfaExecution = this.SIMPLEMFA_EXECUTION;
        }
        if (this.mfaExecution != null) {
            if (this.mfaProvider != null && this.mfaProvider.equalsIgnoreCase("mfa-gauth")) {
                if (accountId == null && this.getAccountId() != null) {
                    accountId = this.getAccountId();
                }
                parameters = "execution=" + this.mfaExecution + "&_eventId=submit&geolocation=&accountId=" + accountId + "&token=" + token;
            } else {
                parameters = "execution=" + this.mfaExecution + "&_eventId=submit&geolocation=&token=" + token;
            }
            if (this.appendAuthClientParameter) {
                parameters = parameters + "&authClientRequest=true";
            }
            HttpPost httpPost = new HttpPost(this.casUrl + LOGON_ENDPOINT);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                StringEntity requestEntity = new StringEntity(parameters);
                httpPost.setEntity((HttpEntity)requestEntity);
                CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();
                CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    throw new LogonFailureException("Failed to get TGT with MFA token: " + token + "!" + httpResponse.getStatusLine().getReasonPhrase());
                }
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                this.retrieveTGT(client);
            }
            catch (Exception e) {
                throw new LogonFailureException("Failed to get TGT with MFA token: " + token + "! Error messages: " + e.getLocalizedMessage());
            }
        }
    }

    private String scrubUrl(String value) {
        if (!this.scrubUrl) {
            return value;
        }
        try {
            URL cas = new URL(this.casUrl);
            URL locationUrl = new URL(value);
            URL returnedUrl = new URL(cas.getProtocol(), cas.getHost(), cas.getPort(), locationUrl.getFile());
            return returnedUrl.toString();
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return value;
        }
    }

    public void logon(String userid, String password, boolean cacheCredentials) {
        if (cacheCredentials) {
            this.logon(new CredentialCachingCallbackHandler(userid, password));
        } else if (this.whetherParticipateMfa()) {
            this.doLogonWithMFA(userid, password);
        } else {
            this.doLogon(userid, password);
        }
    }

    public String acquireTicket(String service) {
        return this.acquireTicket(service, true);
    }

    public String acquireTicket(String service, boolean retry) {
        service = this.encodeQueryParameter(service);
        if (null == this.ticketGrantingTicketUrl) {
            throw new IllegalStateException("Cannot attempt to acquire service ticket '" + service + "', user has already been logged out");
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        org.springframework.http.HttpEntity request = new org.springframework.http.HttpEntity((Object)("service=" + service), (MultiValueMap)requestHeaders);
        ResponseEntity response = this.template.exchange(this.ticketGrantingTicketUrl, HttpMethod.POST, request, String.class, new Object[0]);
        HttpStatusCode statusCode = response.getStatusCode();
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            if (HttpStatus.OK != status) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Non OK response encountered when acquiring ticket for service '" + service + "'");
                }
                if (null != this.handler && status.value() >= 400 && status.value() < 500 && retry) {
                    block12: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Ticket acquisition failed. Trying to log off then log on again with cached credentials");
                        }
                        try {
                            this.logout(true);
                        }
                        catch (Throwable t) {
                            if (!logger.isDebugEnabled()) break block12;
                            logger.debug("Exception logging out during ticket reacquisition", t);
                        }
                    }
                    try {
                        this.logon(this.handler);
                        return this.acquireTicket(service, false);
                    }
                    catch (LogonFailureException e) {
                        logger.error("Error trying to log on again with cached credentials.", (Throwable)e);
                        throw new TicketCreationException("Unable to acquire ticket, and could not log on again with cached credentials: " + response, e);
                    }
                }
                throw new TicketCreationException("Unable to acquire ticket: " + response);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Type of status code is not correct:" + statusCode);
            }
            throw new TicketCreationException("Unable to acquire ticket: " + response);
        }
        String body = (String)response.getBody();
        return body;
    }

    public void logout() {
        this.logout(false);
    }

    private void logout(boolean preserveHandler) {
        if (null != this.ticketGrantingTicketUrl) {
            ResponseEntity response = this.template.exchange(this.ticketGrantingTicketUrl, HttpMethod.DELETE, null, Object.class, new Object[0]);
            HttpStatusCode statusCode = response.getStatusCode();
            if (statusCode instanceof HttpStatus) {
                HttpStatus status = (HttpStatus)statusCode;
                if (HttpStatus.OK != status && HttpStatus.NOT_FOUND != status) {
                    throw new LogoutFailureException("Failed to logout: " + response);
                }
            } else {
                throw new LogoutFailureException("Failed to logout: " + response);
            }
        }
        if (!preserveHandler) {
            this.handler = null;
        }
        this.ticketGrantingTicketUrl = null;
        this.ticketGrantingTicket = null;
    }

    public String getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public void setTicketGrantingTicket(String ticketGrantingTicket) {
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.ticketGrantingTicketUrl = this.casUrl + REST_ENDPOINT + "/" + ticketGrantingTicket;
    }

    public String getCasUrl() {
        return this.casUrl;
    }

    private String encodeQueryParameter(String parameter) {
        String encodedValue = UriUtils.encodeQueryParam((String)parameter, (String)"UTF-8");
        if (encodedValue != null && encodedValue.indexOf("+") > -1) {
            encodedValue = encodedValue.replace("+", "%2B");
        }
        return encodedValue;
    }

    public String getMfaExecution() {
        return this.mfaExecution;
    }

    public void setMfaExecution(String mfaExecution) {
        this.mfaExecution = mfaExecution;
    }

    public boolean whetherParticipateMfa() {
        return this.participateMfa;
    }

    public void participateMfa(boolean participateMfa) {
        this.participateMfa = participateMfa;
    }

    public boolean isServerMfaEnabled() {
        return this.serverMfaEnabled;
    }

    public void setServerMfaEnabled(boolean serverMfaEnabled) {
        this.serverMfaEnabled = serverMfaEnabled;
    }

    public String getMfaProvider() {
        return this.mfaProvider;
    }

    public void setMfaProvider(String mfaProvider) {
        this.mfaProvider = mfaProvider;
    }

    public String getRegisteredAccountIds() {
        return this.registeredAccountIds;
    }

    public void setRegisteredAccountIds(String registeredAccountIds) {
        this.registeredAccountIds = registeredAccountIds;
    }

    public boolean isNeedToRegister() {
        return this.needToRegister;
    }

    public void setNeedToRegister(boolean needToRegister) {
        this.needToRegister = needToRegister;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getQrCode() {
        return this.qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String[] getScratchCodes() {
        return this.scratchCodes;
    }

    public void setScratchCodes(String[] scratchCodes) {
        this.scratchCodes = scratchCodes;
    }

    public String getSelectDeviceExecutionId() {
        return this.selectDeviceExecutionId;
    }

    public void setSelectDeviceExecutionId(String selectDeviceExecutionId) {
        this.selectDeviceExecutionId = selectDeviceExecutionId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(String registrationDate) {
        this.registrationDate = registrationDate;
    }

    static class ErrorHandler
    extends DefaultResponseErrorHandler {
        ErrorHandler() {
        }

        protected boolean hasError(HttpStatusCode statusCode) {
            return statusCode.value() >= 500;
        }
    }
}

