/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.time;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatePeriod
implements Comparable<DatePeriod> {
    private int year;
    private int month;
    private int day;
    private Unit unit;
    private static final Pattern DATE = Pattern.compile("([0-9]{4})(-(0[1-9]|1[0-2]|Q[1-4])(-(0[1-9]|[1-2][0-9]|3[0-1]|W[1-5]))?)?");

    public DatePeriod(long l, Unit unit) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(l).atZone(ZoneOffset.UTC);
        this.year = zonedDateTime.get(ChronoField.YEAR);
        if (unit == Unit.QUARTER) {
            this.month = zonedDateTime.get(IsoFields.QUARTER_OF_YEAR);
        } else if (unit != Unit.YEAR) {
            this.month = zonedDateTime.get(ChronoField.MONTH_OF_YEAR);
            if (unit == Unit.WEEK) {
                this.day = zonedDateTime.get(ChronoField.ALIGNED_WEEK_OF_MONTH);
            } else if (unit == Unit.DAY) {
                this.day = zonedDateTime.get(ChronoField.DAY_OF_MONTH);
            }
        }
        this.unit = unit;
    }

    private DatePeriod(DatePeriod datePeriod) {
        this.year = datePeriod.year;
        this.month = datePeriod.month;
        this.day = datePeriod.day;
        this.unit = datePeriod.unit;
    }

    public long getTimestamp() {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(this.year, this.unit == Unit.QUARTER ? (this.month - 1) * 3 + 1 : (this.month == 0 ? 1 : this.month), this.unit == Unit.WEEK ? (this.day - 1) * 7 + 1 : (this.day == 0 ? 1 : this.day), 12, 0, 0, 0, ZoneOffset.UTC.normalized());
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public DatePeriod convert(Unit unit) {
        DatePeriod datePeriod = new DatePeriod(this);
        if (unit.compareTo(this.unit) < 0) {
            if (unit == Unit.WEEK) {
                datePeriod.day = (this.day - 1) / 7 + 1;
            } else {
                datePeriod.day = 0;
                if (unit == Unit.QUARTER) {
                    datePeriod.month = (this.month - 1) / 3 + 1;
                } else if (unit == Unit.YEAR) {
                    datePeriod.month = 0;
                }
            }
            datePeriod.unit = unit;
        }
        return datePeriod;
    }

    @Override
    public int compareTo(DatePeriod datePeriod) {
        int n = this.year - datePeriod.year;
        if (n == 0 && (n = (this.unit == Unit.QUARTER ? (this.month - 1) * 3 + 1 : this.month) - (datePeriod.unit == Unit.QUARTER ? (datePeriod.month - 1) * 3 + 1 : datePeriod.month)) == 0 && (n = (this.unit == Unit.WEEK ? (this.day - 1) * 7 + 1 : this.day) - (datePeriod.unit == Unit.WEEK ? (datePeriod.day - 1) * 7 + 1 : datePeriod.day)) == 0) {
            n = this.unit.compareTo(datePeriod.unit);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof DatePeriod) {
            DatePeriod datePeriod = (DatePeriod)object;
            return this.year == datePeriod.year && this.month == datePeriod.month && this.day == datePeriod.day && this.unit == datePeriod.unit;
        }
        return false;
    }

    public int hashCode() {
        return (this.year * 100 + this.month) * 100 + this.day;
    }

    public boolean isBefore(DatePeriod datePeriod) {
        if (datePeriod != null) {
            DatePeriod datePeriod2 = this.convert(datePeriod.unit);
            if (datePeriod2.unit == datePeriod.unit) {
                return datePeriod2.year < datePeriod.year || datePeriod2.year == datePeriod.year && (datePeriod2.month < datePeriod.month || datePeriod2.month == datePeriod.month && datePeriod2.day < datePeriod.day);
            }
        }
        return false;
    }

    public boolean isAfter(DatePeriod datePeriod) {
        if (datePeriod != null) {
            DatePeriod datePeriod2 = this.convert(datePeriod.unit);
            if (datePeriod2.unit == datePeriod.unit) {
                return datePeriod2.year > datePeriod.year || datePeriod2.year == datePeriod.year && (datePeriod2.month > datePeriod.month || datePeriod2.month == datePeriod.month && datePeriod2.day > datePeriod.day);
            }
        }
        return false;
    }

    public boolean isWithin(DatePeriod datePeriod) {
        if (datePeriod != null) {
            DatePeriod datePeriod2 = this.convert(datePeriod.unit);
            if (datePeriod2.unit == datePeriod.unit) {
                return datePeriod2.year == datePeriod.year && datePeriod2.month == datePeriod.month && datePeriod2.day == datePeriod.day;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.year));
        if (this.unit != Unit.YEAR) {
            stringBuilder.append("-");
            if (this.unit == Unit.QUARTER) {
                stringBuilder.append("Q").append(String.valueOf(this.month));
            } else {
                stringBuilder.append(String.format("%02d", this.month));
                if (this.unit != Unit.MONTH) {
                    stringBuilder.append("-");
                    if (this.unit == Unit.WEEK) {
                        stringBuilder.append("W").append(String.valueOf(this.day));
                    } else {
                        stringBuilder.append(String.format("%02d", this.day));
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public static DatePeriod fromString(String string) {
        DatePeriod datePeriod = null;
        Matcher matcher = DATE.matcher(string);
        if (matcher.matches()) {
            datePeriod = new DatePeriod(0L, Unit.YEAR);
            datePeriod.year = Integer.parseInt(matcher.group(1));
            if (matcher.group(2) == null) {
                datePeriod.unit = Unit.YEAR;
            } else if (matcher.group(3).charAt(0) == 'Q') {
                datePeriod.month = matcher.group(3).charAt(1) - 48;
                datePeriod.unit = Unit.QUARTER;
            } else {
                datePeriod.month = Integer.parseInt(matcher.group(3));
                if (matcher.group(4) == null) {
                    datePeriod.unit = Unit.MONTH;
                } else if (matcher.group(5).charAt(0) == 'W') {
                    datePeriod.day = matcher.group(5).charAt(1) - 48;
                    datePeriod.unit = Unit.WEEK;
                } else {
                    datePeriod.day = Integer.parseInt(matcher.group(5));
                    datePeriod.unit = Unit.DAY;
                }
            }
        }
        return datePeriod;
    }

    public static enum Unit {
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY;

    }
}

