/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.thread;

import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.LogEvent;
import MITI.util.log.MIRLogger;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleThreadLogger
extends MIRLogger {
    private MIRLogger mainLogger;
    private BufferedLogEventHandler handler;
    private boolean useInfoForStatus;
    private static ConcurrentLinkedQueue<SimpleThreadLogger> loggers = new ConcurrentLinkedQueue();

    SimpleThreadLogger(MIRLogger mIRLogger) {
        this(mIRLogger, new BufferedLogEventHandler());
    }

    protected SimpleThreadLogger(MIRLogger mIRLogger, BufferedLogEventHandler bufferedLogEventHandler) {
        super(bufferedLogEventHandler);
        this.mainLogger = mIRLogger;
        this.handler = bufferedLogEventHandler;
    }

    public void setUseInfoForStatus(boolean bl) {
        this.useInfoForStatus = bl;
    }

    @Override
    public synchronized void log(LogEvent logEvent) {
        if (this.useInfoForStatus) {
            logEvent.useInfoForStatus();
        }
        if (this.handler != null) {
            logEvent.setThreadId(Thread.currentThread().getName());
            super.log(logEvent);
        } else {
            this.mainLogger.log(logEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.handler != null) {
            MIRLogger mIRLogger = this.mainLogger;
            synchronized (mIRLogger) {
                for (LogEvent logEvent : this.handler.getEvents()) {
                    this.mainLogger.log(logEvent);
                }
                this.handler.clear();
            }
        }
    }

    public static SimpleThreadLogger wrap(MIRLogger mIRLogger) {
        if (!(mIRLogger instanceof SimpleThreadLogger)) {
            mIRLogger = new SimpleThreadLogger(mIRLogger, null);
            MIRLogger.setLogger(mIRLogger);
        }
        loggers.add((SimpleThreadLogger)mIRLogger);
        return (SimpleThreadLogger)mIRLogger;
    }

    public static MIRLogger unwrap(SimpleThreadLogger simpleThreadLogger) {
        loggers.remove(simpleThreadLogger);
        simpleThreadLogger.flush();
        MIRLogger.setLogger(simpleThreadLogger.mainLogger);
        return simpleThreadLogger.mainLogger;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (SimpleThreadLogger simpleThreadLogger : loggers) {
                    simpleThreadLogger.flush();
                }
            }
        });
    }
}

