/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.os;

import MITI.util.ProcessBuilder;
import MITI.util.os.MacAddress;
import MITI.util.os.OsInfo;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MachineInfo {
    private static String hostId = null;
    private static final String PROCESSOR_IDENTIFIER = "PROCESSOR_IDENTIFIER";
    private static final String USER_LANGUAGE = "user.language";
    private static final String FILE_ENCODING = "file.encoding";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String JAVA_VERSION = "java.version";
    private static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    private static final String JAVA_HOME = "java.home";
    private static OsInfo osInfo = null;

    public static String getMacAddress() {
        return MacAddress.getMacAddress();
    }

    public static List<String> getMacAddresses(boolean bl) {
        return MacAddress.getMacAddresses(bl);
    }

    public static String getHostId() {
        if (hostId == null) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder();
                Pattern pattern = null;
                if (MachineInfo.isWindows()) {
                    processBuilder.setArguments("cmd", "/c", "vol", "%SystemDrive%");
                    pattern = Pattern.compile("[0-9A-F]+-[0-9A-F]+", 2);
                } else {
                    processBuilder.setArguments("hostid");
                    pattern = Pattern.compile("[0-9a-f]+", 2);
                }
                processBuilder.exec();
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = processBuilder.getStdOut();
                if (string != null) {
                    for (String string2 : string.split("(\\\r)?\\\n")) {
                        Matcher matcher = pattern.matcher(string2);
                        if (!matcher.find()) continue;
                        String string3 = matcher.group();
                        arrayList.add(string3.toLowerCase().replace("-", ""));
                    }
                }
                if (arrayList.size() == 1) {
                    hostId = (String)arrayList.get(0);
                } else if (arrayList.size() == 2 && MachineInfo.isWindows()) {
                    hostId = (String)arrayList.get(1);
                }
                if ("00000000".equals(hostId)) {
                    hostId = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hostId;
    }

    public static String getHostName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    public static String getHardware() {
        return MachineInfo.getHardwareProcessorId() + ", " + MachineInfo.getAvailableProcessors() + " CPU(s)/Core(s), " + MachineInfo.getHardwareMemory() + " MB RAM accessible";
    }

    public static int getAvailableProcessors() {
        return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }

    public static String getHardwareMemory() {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String string = "unknown";
        try {
            long l = ((OperatingSystemMXBean)operatingSystemMXBean).getTotalPhysicalMemorySize();
            if (l != Long.MAX_VALUE) {
                string = String.valueOf(l / 1024L / 1024L);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return string;
    }

    public static String getHardwareProcessorId() {
        String string = System.getenv(PROCESSOR_IDENTIFIER);
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    public static String getSoftware() {
        Locale locale = new Locale(System.getProperty(USER_LANGUAGE));
        return MachineInfo.getOsInfo().toString() + ", " + locale.getDisplayLanguage();
    }

    public static String getEncoding() {
        String string = System.getProperty(FILE_ENCODING);
        Charset charset = Charset.forName(string);
        if (charset != null) {
            return charset.displayName();
        }
        return string;
    }

    public static String getJavaVersion() {
        String string = System.getProperty(JAVA_RUNTIME_VERSION);
        if (string == null || string.isEmpty()) {
            string = System.getProperty(JAVA_VERSION);
        }
        return "Java " + System.getProperty(JAVA_VENDOR) + " version " + string;
    }

    public static String getJavaMemory() {
        String string = "unlimited";
        long l = Runtime.getRuntime().maxMemory();
        if (l != Long.MAX_VALUE) {
            string = String.valueOf(l / 1024L / 1024L);
        }
        return string + " MB RAM";
    }

    public static String getJavaHome() {
        return System.getProperty(JAVA_HOME);
    }

    public static String getJavaOptions() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String string = "";
        for (String string2 : runtimeMXBean.getInputArguments()) {
            String string3;
            if (!string2.startsWith("-X") && !string2.startsWith("-D") || (string3 = string2.split("=")[0].substring(2).toLowerCase()).startsWith("mimb") || string3.contains("user") || string3.contains("password")) continue;
            if (!string.isEmpty()) {
                string = string + ", ";
            }
            string = string + string2;
        }
        return string;
    }

    public static String getJavaInfo() {
        return "" + MachineInfo.getJavaVersion() + " using " + MachineInfo.getJavaMemory();
    }

    public static long getJavaProcessId() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String string = runtimeMXBean.getName();
        int n = string.indexOf(64);
        if (n == -1) {
            return 0L;
        }
        String string2 = string.substring(0, n);
        try {
            return Long.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static OsInfo getOsInfo() {
        if (osInfo == null) {
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            osInfo = new OsInfo(operatingSystemMXBean.getName(), operatingSystemMXBean.getVersion(), operatingSystemMXBean.getArch());
        }
        return osInfo;
    }

    public static boolean isWindows() {
        return MachineInfo.getOsInfo().getType() == OsInfo.OSType.Windows;
    }

    public static boolean is64Bits() {
        return MachineInfo.getOsInfo().getArch().contains("64");
    }

    public static String getUsername() {
        if (MachineInfo.isWindows()) {
            return System.getenv().get("USERDOMAIN") + "\\" + System.getenv().get("USERNAME");
        }
        return System.getProperty("user.name");
    }
}

