/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.os;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class MacAddress
implements Comparable<MacAddress> {
    private String name;
    private String displayName;
    private String address;
    private String virtual;
    private boolean isUp;
    private static final HashMap<String, String> vmMacs = new HashMap();
    private static TreeSet<MacAddress> addresses;

    public static String getMacAddress() {
        for (MacAddress macAddress : MacAddress.getMacAddresses()) {
            if (!macAddress.isUp) continue;
            return macAddress.get();
        }
        return null;
    }

    public static String getMacAddress(String string) {
        for (MacAddress macAddress : MacAddress.getMacAddresses()) {
            if (!macAddress.name.equals(string) && !macAddress.displayName.equals(string)) continue;
            return macAddress.get();
        }
        return null;
    }

    public static List<String> getMacAddresses(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MacAddress macAddress : MacAddress.getMacAddresses()) {
            if (bl && !macAddress.isUp) continue;
            arrayList.add(macAddress.get());
        }
        return arrayList;
    }

    private MacAddress(NetworkInterface networkInterface) throws SocketException {
        this.name = networkInterface.getName();
        this.displayName = networkInterface.getDisplayName();
        this.isUp = networkInterface.isUp();
        byte[] byArray = networkInterface.getHardwareAddress();
        if (byArray != null && byArray.length == 6) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(":");
                }
                stringBuilder.append(String.format("%02x", byArray[i]));
            }
            this.address = stringBuilder.toString();
            this.virtual = vmMacs.get(this.address.substring(0, 8));
            if (this.virtual == null) {
                this.virtual = vmMacs.get(this.address.substring(0, 5));
            }
        }
    }

    private String get() {
        return this.address + (this.virtual != null ? "(" + this.virtual + "?)" : "");
    }

    @Override
    public int compareTo(MacAddress macAddress) {
        if (this.virtual == null && macAddress.virtual != null) {
            return -1;
        }
        if (this.virtual != null && macAddress.virtual == null) {
            return 1;
        }
        return this.address.compareTo(macAddress.address);
    }

    private static synchronized TreeSet<MacAddress> getMacAddresses() {
        if (addresses == null) {
            addresses = new TreeSet();
            Enumeration<NetworkInterface> enumeration = null;
            try {
                enumeration = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException socketException) {
                enumeration = Collections.emptyEnumeration();
            }
            while (enumeration.hasMoreElements()) {
                try {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    if (networkInterface.isLoopback() || networkInterface.isPointToPoint() || networkInterface.isVirtual()) continue;
                    MacAddress macAddress = new MacAddress(networkInterface);
                    if (macAddress.address == null) continue;
                    addresses.add(new MacAddress(networkInterface));
                }
                catch (SocketException socketException) {}
            }
        }
        return addresses;
    }

    static {
        vmMacs.put("00:50:56", "VMware");
        vmMacs.put("00:0c:29", "VMware");
        vmMacs.put("00:05:69", "VMware");
        vmMacs.put("00:03:ff", "Microsoft");
        vmMacs.put("00:15:5d", "Microsoft");
        vmMacs.put("00:1c:42", "Parallels");
        vmMacs.put("00:0f:4b", "VirtualIron");
        vmMacs.put("00:16:3e", "Xen");
        vmMacs.put("00:ff:", "VirtualAdapter");
        vmMacs.put("02:42", "Docker");
        vmMacs.put("08:00:27", "VirtualBox");
        vmMacs.put("0a:00:27", "VirtualBox");
        addresses = null;
    }
}

