/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.net;

import MITI.util.file.FileUtil;
import MITI.util.net.HttpMessage;
import MITI.util.ssl.SSLUtil;
import MITI.util.ssl.TrustLocalhostVerifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpUtil {
    public static HttpURLConnection openConnection(URL uRL) throws IOException, GeneralSecurityException {
        return HttpUtil.openConnection(uRL, null);
    }

    public static HttpURLConnection openConnection(URL uRL, Proxy proxy) throws IOException, GeneralSecurityException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)(proxy != null ? uRL.openConnection(proxy) : uRL.openConnection());
        if (httpURLConnection instanceof HttpsURLConnection) {
            SSLContext sSLContext = SSLUtil.getSslContext(uRL, proxy, true, false);
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
            if ("localhost".equalsIgnoreCase(uRL.getHost())) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(new TrustLocalhostVerifier());
            }
        }
        return httpURLConnection;
    }

    public static boolean testConnection(URL uRL) {
        boolean bl = false;
        HttpURLConnection httpURLConnection = null;
        try {
            Throwable throwable;
            InputStream inputStream;
            httpURLConnection = HttpUtil.openConnection(uRL, null);
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setDoOutput(false);
            bl = HttpUtil.isOkReponseCode(httpURLConnection.getResponseCode());
            try {
                inputStream = httpURLConnection.getInputStream();
                throwable = null;
                try {
                    if (inputStream != null) {
                        while (inputStream.read() != -1) {
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                inputStream = httpURLConnection.getErrorStream();
                throwable = null;
                try {
                    if (inputStream != null) {
                        while (inputStream.read() != -1) {
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }
        catch (IOException | GeneralSecurityException exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return bl;
        }
    }

    public static final void download(File file, HttpURLConnection httpURLConnection, Method method, HttpMessage httpMessage) throws IOException, RemoteException {
        try (InputStream inputStream = HttpUtil.open(httpURLConnection, method, httpMessage);){
            FileUtil.copy(inputStream, file);
        }
    }

    public static final String get(HttpURLConnection httpURLConnection, Method method, HttpMessage httpMessage) throws IOException, RemoteException {
        try (InputStream inputStream = HttpUtil.open(httpURLConnection, method, httpMessage);){
            String string = FileUtil.readContent(inputStream, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static final InputStream open(HttpURLConnection httpURLConnection, Method method, HttpMessage httpMessage) throws IOException, RemoteException {
        int n = HttpUtil.send(httpURLConnection, method, httpMessage);
        if (!HttpUtil.isOkReponseCode(n)) {
            String string = httpURLConnection.getResponseMessage();
            String string2 = HttpUtil.getErrorMessage(httpURLConnection);
            String string3 = String.join((CharSequence)" ", String.valueOf(n), string != null ? string : "", string2);
            throw new RemoteException(string3);
        }
        return httpURLConnection.getInputStream();
    }

    public static boolean isOkReponseCode(int n) {
        return n == 200 || n == 201 || n == 202 || n == 204;
    }

    public static final int send(HttpURLConnection httpURLConnection, Method method, HttpMessage httpMessage) throws IOException {
        httpURLConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        httpURLConnection.setRequestMethod(method.name());
        if (method == Method.POST || method == Method.PUT) {
            httpURLConnection.setDoOutput(true);
        }
        if (httpMessage != null && !httpMessage.isEmpty()) {
            httpURLConnection.setRequestProperty("Content-Charset", httpMessage.getCharset().name());
            if (httpMessage.getContentType() == HttpMessage.ContentType.WWW_FORM_URLENCODED || httpMessage.getContentType() == HttpMessage.ContentType.JSON) {
                httpURLConnection.setRequestProperty("Content-Type", httpMessage.getContentType().getType());
                httpURLConnection.setRequestProperty("Content-Length", String.valueOf(httpMessage.getPayload().length));
                httpMessage.print(httpURLConnection.getOutputStream());
            } else if (httpMessage.getContentType() == HttpMessage.ContentType.MULTIPART_FORM_DATA) {
                httpURLConnection.setRequestProperty("Content-Type", httpMessage.getContentType().getType() + "; boundary=" + httpMessage.getBoundary());
                httpMessage.print(httpURLConnection.getOutputStream());
            }
        } else if (method == Method.POST || method == Method.PUT) {
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(0));
            httpURLConnection.getOutputStream().flush();
        }
        return httpURLConnection.getResponseCode();
    }

    public static String getErrorMessage(HttpURLConnection httpURLConnection) throws IOException {
        try (InputStream inputStream = httpURLConnection.getErrorStream();){
            if (inputStream != null) {
                String string = FileUtil.readContent(inputStream, StandardCharsets.UTF_8);
                return string;
            }
        }
        return "";
    }

    public static enum Method {
        DELETE,
        GET,
        POST,
        PUT;

    }
}

