/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.log;

import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.log.LogEvent;
import MITI.util.log.LogEventHandler;
import MITI.util.log.MimbLogOutputStream;
import MITI.util.text.MessageLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlLogEventHandler
extends LogEventHandler {
    private PrintStream out;
    private Document eventDoc;

    public XmlLogEventHandler(OutputStream outputStream) {
        try {
            this.eventDoc = XmlUtil.getDocumentBuilder().newDocument();
            this.out = new PrintStream(outputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    @Override
    public void log(LogEvent logEvent) {
        if (this.out != null) {
            this.writeLogEventXml(logEvent);
            this.out.flush();
        }
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        this.out = null;
    }

    private void writeLogEventXml(LogEvent logEvent) {
        try {
            Element element = this.eventDoc.createElement("Message");
            if (logEvent.getThreadId() != null) {
                element.setAttribute("threadId", logEvent.getThreadId());
            }
            element.setAttribute("type", MessageLiteral.convertLevelToText(logEvent.getLevel()));
            element.setAttribute("code", logEvent.getCode());
            element.setAttribute("timestamp", DateUtil.formatUtcDate(logEvent.getTime()));
            if (logEvent.getStackTrace() != null) {
                element.setAttribute("stackTrace", logEvent.getStackTrace());
            }
            XmlUtil.setElementValue(element, logEvent.getText());
            StringBuffer stringBuffer = new StringBuffer();
            XmlUtil.printXml(element, stringBuffer, null, false);
            byte[] byArray = stringBuffer.toString().getBytes("UTF-8");
            this.out.write(MimbLogOutputStream.MIR_LOG_EVENT_HEADER_START);
            String string = Integer.toString(byArray.length) + "        ";
            string = string.substring(0, 8);
            this.out.write(string.getBytes("UTF-8"));
            this.out.write(MimbLogOutputStream.MIR_LOG_EVENT_HEADER_END);
            this.out.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

