/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.MandatoryOption;
import MITI.util.cmd.TypedOption;
import MITI.util.file.FileUtil;
import MITI.util.log.LogEvent;
import MITI.util.log.MIRLogger;
import MITI.util.log.XmlLogEventHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Zip {
    private static final int BUFSIZE = 32768;
    private static final int MAX_ZIP_ENTRIES = 1000000;
    private static final long MAX_ZIP_SIZE = 4000000000L;
    private static final double COMPRESSION_RATIO = 50.0;
    private static HelpOption helpOption = new HelpOption();
    private static MandatoryOption runXmlOption = new MandatoryOption(new String[]{"-r", "--runXml"}, "", TypedOption.Type.FILE);
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, runXmlOption};

    private static String makeRelative(String string) {
        return string.replaceAll("^/*", "");
    }

    public static void unzip(File file, File file2) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));){
            Zip.safeUnzip(zipInputStream, file2, ZipOptions.DEFAULT);
        }
    }

    public static void unzip(File file, File file2, ZipOptions zipOptions) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));){
            Zip.safeUnzip(zipInputStream, file2, zipOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safeUnzip(ZipInputStream zipInputStream, File file, ZipOptions zipOptions) throws IOException {
        int n = 0;
        long l = 0L;
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            try {
                if (++n > 1000000) {
                    throw new IOException("Maximum number of entries reached");
                }
                File file2 = zipOptions.getFile(file, zipEntry);
                if (file2 == null) continue;
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                file2.getParentFile().mkdirs();
                FileUtil.copy(zipInputStream, file2);
                long l2 = file2.length();
                if ((double)(l2 / zipEntry.getCompressedSize()) > 50.0) {
                    throw new IOException("Invalid compression ratio for " + zipEntry.getName() + " : " + String.valueOf(l2 / zipEntry.getCompressedSize()));
                }
                if ((l += l2) <= 4000000000L) continue;
                throw new IOException("Maximum zip file size reached");
            }
            finally {
                zipInputStream.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zipOutputStream, String string, File file) throws IOException {
        String string2 = Zip.makeRelative(string + "/" + file.getName());
        ZipEntry zipEntry = new ZipEntry(string2);
        zipEntry.setTime(file.lastModified());
        zipOutputStream.putNextEntry(zipEntry);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            int n = 0;
            byte[] byArray = new byte[32768];
            do {
                if ((n = bufferedInputStream.read(byArray)) <= 0) continue;
                zipOutputStream.write(byArray, 0, n);
            } while (n > 0);
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    public static void zip(ZipOutputStream zipOutputStream, String string, File ... fileArray) throws IOException {
        for (File file : fileArray) {
            if (file.isDirectory()) {
                Zip.zip(zipOutputStream, string + "/" + file.getName(), file.listFiles());
                continue;
            }
            Zip.zip(zipOutputStream, string, file);
        }
    }

    public static void zip(ZipOutputStream zipOutputStream, File ... fileArray) throws IOException {
        Zip.zip(zipOutputStream, "", fileArray);
    }

    public static void zip(File file, File ... fileArray) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));){
            Zip.zip(zipOutputStream, "", fileArray);
        }
    }

    public static void zip(File file, String string, String string2, File ... fileArray) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));){
            zipOutputStream.setComment(string);
            Zip.zip(zipOutputStream, string2, fileArray);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        MIRLogger.init(new XmlLogEventHandler(System.err));
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
        }
        String string = null;
        File file = null;
        File file2 = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            object = documentBuilderFactory.newDocumentBuilder();
            Document document = ((DocumentBuilder)object).parse(runXmlOption.getFileValue());
            Element element = document.getDocumentElement();
            string = element.getAttribute("action");
            file = new File(element.getAttribute("zip"));
            file2 = new File(element.getAttribute("dir"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException(sAXException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        try {
            if (string.equals("zip")) {
                Zip.zip(file, file2);
            } else if (string.equals("unzip")) {
                Zip.unzip(file, file2);
            }
        }
        catch (IOException iOException) {
            object = new LogEvent("Fatal error", 1, "");
            ((LogEvent)object).setStackTrace(iOException);
            MIRLogger.getLogger().log((LogEvent)object);
            System.exit(1);
        }
        System.exit(0);
    }

    public static class ZipOptions {
        public static final ZipOptions DEFAULT = new ZipOptions("", true, null);
        private String prefix;
        private boolean recursive;
        private Predicate<String> filter;

        public ZipOptions(Predicate<String> predicate) {
            this("", true, predicate);
        }

        public ZipOptions(String string2, boolean bl, Predicate<String> predicate) {
            this.prefix = string2 != null ? string2 : "";
            this.recursive = bl;
            this.filter = predicate != null ? predicate : string -> true;
        }

        private File getFile(File file, ZipEntry zipEntry) {
            String string = Zip.makeRelative(zipEntry.getName());
            if (string.startsWith(this.prefix) && this.filter.test(string) && FileUtil.isSubPath(file, string = Zip.makeRelative(string.substring(this.prefix.length())))) {
                File file2 = new File(file, string);
                if (this.recursive || file2.getParentFile().equals(file)) {
                    return file2;
                }
            }
            return null;
        }
    }
}

