/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import MITI.util.thread.SimpleTask;
import MITI.util.thread.SimpleThreadPool;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class FilesWatcher {
    private File rootDir;
    private boolean isFile;
    private boolean isRecursive;
    private WatchService watcher;
    private Map<WatchKey, Path> watchDirs;
    private SimpleThreadPool pool;

    protected FilesWatcher(File file, boolean bl) {
        this.isFile = !file.isDirectory();
        this.rootDir = file;
        this.isRecursive = bl && !this.isFile;
    }

    public void start() {
        if (this.watcher == null) {
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
                this.watchDirs = new HashMap<WatchKey, Path>();
                this.register(this.isFile ? this.rootDir.getParentFile() : this.rootDir, this.isRecursive);
                this.pool = new SimpleThreadPool("FilesWatcher", 1, true);
                this.pool.submit(new SimpleTask(){

                    @Override
                    protected Boolean internalCall() throws Exception {
                        while (true) {
                            HashSet<File> hashSet = new HashSet<File>();
                            try {
                                WatchKey watchKey = FilesWatcher.this.watcher.take();
                                while (watchKey != null) {
                                    Path path = (Path)FilesWatcher.this.watchDirs.get(watchKey);
                                    if (path != null) {
                                        Thread.sleep(1000L);
                                        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                                            WatchEvent.Kind<?> kind = watchEvent.kind();
                                            WatchEvent<?> watchEvent2 = watchEvent;
                                            File file = path.resolve((Path)watchEvent2.context()).toFile();
                                            if (!FilesWatcher.this.isFile || FilesWatcher.this.rootDir.getName().equals(file.getName())) {
                                                hashSet.add(file);
                                            }
                                            if (kind != StandardWatchEventKinds.ENTRY_CREATE || !file.isDirectory() || !FilesWatcher.this.isRecursive) continue;
                                            FilesWatcher.this.register(file, FilesWatcher.this.isRecursive);
                                        }
                                    }
                                    if (!watchKey.reset()) {
                                        FilesWatcher.this.watchDirs.remove(watchKey);
                                    }
                                    watchKey = FilesWatcher.this.watcher.poll();
                                }
                                if (hashSet.isEmpty()) continue;
                                FilesWatcher.this.updateFiles(hashSet);
                            }
                            catch (InterruptedException interruptedException) {
                                return true;
                            }
                        }
                    }
                });
                this.pool.shutdown();
            }
            catch (IOException iOException) {
                System.err.println("Reloading profiles is not available");
            }
        }
    }

    public void stop() {
        for (WatchKey watchKey : this.watchDirs.keySet()) {
            watchKey.cancel();
        }
        this.watchDirs.clear();
        if (this.watcher != null) {
            try {
                this.watcher.close();
                this.watcher = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.pool != null) {
                this.pool.close();
                this.pool = null;
            }
        }
    }

    protected abstract void updateFiles(Collection<File> var1);

    private void register(File file, boolean bl) throws IOException {
        Path path = file.toPath();
        WatchKey watchKey = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watchDirs.put(watchKey, path);
        if (bl) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory() || ".svn".equalsIgnoreCase(file2.getName())) continue;
                this.register(file2, bl);
            }
        }
    }
}

