/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class FileUtil {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int DEFAULT_BUFFER_SIZE = 10240;

    public static boolean copy(InputStream inputStream, File file) {
        try {
            if (inputStream != null) {
                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static boolean copy(File file, File file2) {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            for (File file3 : FileUtil.list(file)) {
                FileUtil.copy(file3, new File(file2, file3.getName()));
            }
        } else {
            try {
                Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public static boolean move(File file, File file2) {
        try {
            Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException iOException) {
            return FileUtil.copy(file, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(File var0, File var1_1) {
        block34: {
            block33: {
                block32: {
                    if (var0.length() != var1_1.length()) {
                        return false;
                    }
                    var2_2 = null;
                    var3_3 = null;
                    try {
                        var2_2 = new FileInputStream(var0);
                        var3_3 = new FileInputStream(var1_1);
                        var4_4 = var2_2.getChannel();
                        var5_6 = var3_3.getChannel();
                        var6_8 = ByteBuffer.allocateDirect(8192);
                        var7_11 = ByteBuffer.allocateDirect(8192);
                        while (true) {
                            var6_8.clear();
                            var8_12 = var4_4.read(var6_8);
                            var6_8.flip();
                            var7_11.clear();
                            var9_13 = var5_6.read(var7_11);
                            var7_11.flip();
                            if (var8_12 == -1 && var9_13 == -1) {
                                var10_14 = true;
                                if (var2_2 == null) break block32;
                            }
                            ** GOTO lbl-1000
                            break;
                        }
                    }
                    catch (IOException var4_5) {
                        var5_7 = false;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (IOException var6_9) {
                                // empty catch block
                            }
                        }
                        if (var3_3 == null) return var5_7;
                        try {
                            var3_3.close();
                            return var5_7;
                        }
                        catch (IOException var6_10) {
                            // empty catch block
                        }
                        return var5_7;
                    }
                    catch (Throwable var12_23) {
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (IOException var13_24) {
                                // empty catch block
                            }
                        }
                        if (var3_3 == null) throw var12_23;
                        try {
                            var3_3.close();
                            throw var12_23;
                        }
                        catch (IOException var13_25) {
                            // empty catch block
                        }
                        throw var12_23;
                    }
                    try {
                        var2_2.close();
                    }
                    catch (IOException var11_17) {
                        // empty catch block
                    }
                }
                if (var3_3 == null) return var10_14;
                try {
                    var3_3.close();
                    return var10_14;
                }
                catch (IOException var11_18) {
                    // empty catch block
                }
                return var10_14;
lbl-1000:
                // 1 sources

                {
                    if (var8_12 != -1 && var9_13 != -1) ** GOTO lbl-1000
                    var10_15 = false;
                    if (var2_2 == null) break block33;
                }
                try {
                    var2_2.close();
                }
                catch (IOException var11_19) {
                    // empty catch block
                }
            }
            if (var3_3 == null) return var10_15;
            try {
                var3_3.close();
                return var10_15;
            }
            catch (IOException var11_20) {
                // empty catch block
            }
            return var10_15;
lbl-1000:
            // 1 sources

            {
                if (var6_8.equals(var7_11)) ** continue;
                var10_16 = false;
                if (var2_2 == null) break block34;
            }
            try {
                var2_2.close();
            }
            catch (IOException var11_21) {
                // empty catch block
            }
        }
        if (var3_3 == null) return var10_16;
        try {
            var3_3.close();
            return var10_16;
        }
        catch (IOException var11_22) {
            // empty catch block
        }
        return var10_16;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readContent(InputStream inputStream, Charset charset) {
        if (inputStream == null) return null;
        int n = -1;
        char[] cArray = new char[10240];
        StringBuilder stringBuilder = new StringBuilder(10240);
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);){
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String readContent(File file, Charset charset) {
        ByteBuffer byteBuffer = FileUtil.read(file);
        if (byteBuffer != null) {
            return charset.decode(byteBuffer).toString();
        }
        return null;
    }

    public static byte[] readContent(File file) {
        ByteBuffer byteBuffer = FileUtil.read(file);
        if (byteBuffer != null) {
            if (byteBuffer.hasArray()) {
                return byteBuffer.array();
            }
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer read(File file) {
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)fileChannel.size() + 1);
            while ((n = fileChannel.read(byteBuffer)) >= 0) {
            }
            byteBuffer.flip();
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        catch (IOException iOException) {
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeContent(File file, String string, Charset charset) {
        FileUtil.write(file, charset.encode(string));
    }

    public static void writeContent(File file, byte[] byArray) {
        FileUtil.write(file, ByteBuffer.wrap(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, ByteBuffer byteBuffer) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            while (byteBuffer.hasRemaining()) {
                fileChannel.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean delete(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (FileUtil.delete(file2)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean isSubPath(File file, String string) {
        if (string != null) {
            File file2 = new File(string);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string);
            }
            try {
                return file2.getCanonicalPath().startsWith(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static Collection<File> list(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            return Arrays.asList(fileArray);
        }
        return Collections.emptyList();
    }

    public static String getName(File file) {
        String string = file.getName();
        if (string.isEmpty() && file.getParentFile() == null && (string = file.getAbsolutePath().replace(File.separator, "")).isEmpty()) {
            string = "/";
        }
        return string;
    }

    public static String getValidFileName(File file, String string) throws IOException {
        try {
            Path path;
            if (file == null || !file.isDirectory()) {
                throw new IOException("Invalid parent directory");
            }
            String string2 = FileUtil.getValidFileName(string);
            Path path2 = file.toPath();
            if (!path2.equals((path = path2.resolve(string2)).getParent())) {
                throw new IOException("Invalid file name: " + string2);
            }
            if (string2.length() < 5 && !Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
                Files.delete(path);
            }
            return string2;
        }
        catch (IOException | InvalidPathException exception) {
            throw new IOException("Cannot compute a valid file name: " + exception.getMessage(), exception);
        }
    }

    public static String getValidFileName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Empty file name");
        }
        return string.replaceAll("[/\\\\:\\*\\?\"<>|\u0000]", "_");
    }
}

