/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.csv;

import MITI.util.csv.SimpleCsv;
import MITI.util.csv.SimpleCsvOptions;
import MITI.util.file.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleCsvReader
extends SimpleCsv {
    private BufferedReader reader;
    private Pattern pattern;

    public SimpleCsvReader(File file, SimpleCsvOptions simpleCsvOptions) throws IOException {
        this(file, simpleCsvOptions, FileUtil.UTF8);
    }

    public SimpleCsvReader(File file, SimpleCsvOptions simpleCsvOptions, Charset charset) throws IOException {
        super(file, simpleCsvOptions, charset);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        this.reader.mark(2);
        if (this.reader.read() != 65279) {
            this.reader.reset();
        }
        String string = this.getSimpleRegexp(true);
        String string2 = this.regexp(simpleCsvOptions.getQuote(), simpleCsvOptions.getEscape());
        String string3 = this.regexp(simpleCsvOptions.getQuote()) + "([^" + string2 + "]*+(?:" + this.regexp(simpleCsvOptions.getEscape()) + "[" + string2 + "][^" + string2 + "]*+)*+)" + this.regexp(simpleCsvOptions.getQuote());
        this.pattern = Pattern.compile("(?:" + this.regexp(simpleCsvOptions.getSeparator()) + ")(?:" + string + "|" + string3 + ")(" + this.regexp(simpleCsvOptions.getSeparator()) + "|$)", 8);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public List<String> getNextLine() throws IOException {
        if (!this.reader.ready()) {
            return null;
        }
        ++this.lineNumber;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(2);
        stringBuilder2.append(this.options.getSeparator());
        int n = 0;
        while (this.reader.ready()) {
            this.readLine(stringBuilder, stringBuilder2);
            Matcher matcher = this.pattern.matcher(stringBuilder);
            while (n < stringBuilder.length() && matcher.find(n) && matcher.start() == n) {
                arrayList.add(matcher.group(1) != null ? matcher.group(1) : matcher.group(2).replaceAll(this.regexp(this.options.getEscape()) + "([" + this.regexp(this.options.getQuote(), this.options.getEscape()) + "])", "$1"));
                n = matcher.end() - matcher.group(3).length();
            }
            if (stringBuilder.length() > n) continue;
        }
        if (this.columnCount != 0) {
            while (arrayList.size() < this.columnCount) {
                arrayList.add("");
            }
            return arrayList.subList(0, this.columnCount);
        }
        return arrayList;
    }

    private void readLine(StringBuilder stringBuilder, StringBuilder stringBuilder2) throws IOException {
        int n;
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder2.setLength(0);
        while ((n = this.reader.read()) != -1) {
            if (n == 10) {
                stringBuilder2.append((char)n);
                break;
            }
            if (n == 13) {
                stringBuilder2.append((char)n);
                this.reader.mark(1);
                n = this.reader.read();
                if (n == 10) {
                    stringBuilder2.append((char)n);
                    break;
                }
                if (n == -1) break;
                this.reader.reset();
                break;
            }
            stringBuilder.append((char)n);
        }
    }
}

