/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.csv;

import MITI.util.csv.SimpleCsvReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class SimpleCsvOptions {
    public static final SimpleCsvOptions EXCEL_US = new SimpleCsvOptions(',', '\"', '\"');
    public static final SimpleCsvOptions EXCEL_EU = new SimpleCsvOptions(';', '\"', '\"');
    private char separator;
    private char quote;
    private char escape;

    public SimpleCsvOptions(char c, char c2, char c3) {
        this.separator = c;
        this.quote = c2;
        this.escape = c3;
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuote() {
        return this.quote;
    }

    public char getEscape() {
        return this.escape;
    }

    public static SimpleCsvOptions detect(File file) {
        return SimpleCsvOptions.detect(file, StandardCharsets.UTF_8);
    }

    public static SimpleCsvOptions detect(File file, Charset charset) {
        Throwable throwable;
        SimpleCsvReader simpleCsvReader;
        List<Object> list = Collections.emptyList();
        List<Object> list2 = Collections.emptyList();
        try {
            simpleCsvReader = new SimpleCsvReader(file, EXCEL_US, charset);
            throwable = null;
            try {
                list = simpleCsvReader.getNextLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (simpleCsvReader != null) {
                    if (throwable != null) {
                        try {
                            simpleCsvReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        simpleCsvReader.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            simpleCsvReader = new SimpleCsvReader(file, EXCEL_EU, charset);
            throwable = null;
            try {
                list2 = simpleCsvReader.getNextLine();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (simpleCsvReader != null) {
                    if (throwable != null) {
                        try {
                            simpleCsvReader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        simpleCsvReader.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (list2.size() > list.size()) {
            return EXCEL_EU;
        }
        return EXCEL_US;
    }
}

