/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.config;

import MITI.util.file.FileCache;
import MITI.util.file.FileUtil;
import MITI.util.file.PropertyFile;
import MITI.util.os.MachineInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class MitiConfig {
    private static FileCache<MitiConfig> cache = new FileCache();
    private File mitiHomeDir;
    private File mitiDataDir;
    private File mitiDownloadDir;
    private File mitiScriptDir;
    private String javaExe;
    private HashMap<String, String> properties;
    private static final String DATA_DIRECTORY = "M_DATA_DIRECTORY";
    private static final String DOWNLOAD_DIRECTORY = "M_DOWNLOAD_DIRECTORY";
    private static final String BROWSE_PATH = "M_BROWSE_PATH";
    private static final String SCRIPT_PATH = "M_SCRIPT_PATH";
    private static final String JAVA_HOME = "M_JAVA_HOME";
    private static final String JAVA_OPTIONS = "M_JAVA_OPTIONS";
    private static final String XML_VERSION = "M_XML_VERSION";
    private static final String CONVERSATION_DIRECTORY = "M_CONVERSATION_DIRECTORY";
    private static final String LOG_LEVEL = "MIR_LOG_LEVEL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MitiConfig loadConfig(File file) {
        File file2 = new File(file, "conf/conf.properties");
        FileCache<MitiConfig> fileCache = cache;
        synchronized (fileCache) {
            MitiConfig mitiConfig = cache.get(file2);
            if (mitiConfig == null) {
                mitiConfig = new MitiConfig(file);
                cache.add(file2, mitiConfig);
            }
            return mitiConfig;
        }
    }

    private MitiConfig(File file) {
        this.mitiHomeDir = new File(FileUtil.getCanonicalPath(file));
        this.properties = new HashMap();
        this.load();
    }

    protected MitiConfig(MitiConfig mitiConfig) {
        this.mitiHomeDir = mitiConfig.mitiHomeDir;
        this.mitiDataDir = mitiConfig.mitiDataDir;
        this.javaExe = mitiConfig.javaExe;
        this.properties = new HashMap();
        this.properties.putAll(mitiConfig.properties);
        this.mitiDownloadDir = mitiConfig.mitiDownloadDir;
        this.mitiScriptDir = mitiConfig.mitiScriptDir;
    }

    private void load() {
        System.getenv(DATA_DIRECTORY);
        PropertyFile propertyFile = new PropertyFile(new File(this.mitiHomeDir, "conf/conf.properties"));
        this.properties.putAll(propertyFile.getProperties());
        String string = this.properties.get(DATA_DIRECTORY);
        this.mitiDataDir = string == null || string.isEmpty() ? new File(this.mitiHomeDir, "data") : new File(string);
        File file = null;
        try {
            file = File.createTempFile("test", null, this.mitiDataDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file == null) {
            this.mitiDataDir = new File(System.getProperty("java.io.tmpdir"), "MetaIntegration/data");
        } else {
            file.delete();
        }
        String string2 = this.properties.get(DOWNLOAD_DIRECTORY);
        this.mitiDownloadDir = string2 == null || string2.isEmpty() ? new File(this.mitiDataDir, "download/MIMB") : new File(string2);
        String string3 = this.properties.get(SCRIPT_PATH);
        this.mitiScriptDir = string3 == null || string3.isEmpty() ? new File(this.mitiHomeDir, "bin") : new File(string3);
        String string4 = this.properties.get(JAVA_HOME);
        String string5 = "bin" + File.separator + (MachineInfo.isWindows() ? "java.exe" : "java");
        if (string4 == null || string4.isEmpty()) {
            string4 = new File(this.mitiHomeDir, "jre").getPath();
            if (!(new File(string4, string5).exists() || new File(string4 = new File(this.mitiHomeDir.getParentFile(), "jre").getPath(), string5).exists() || new File(string4 = new File(this.mitiHomeDir.getParentFile(), "jdk/jre").getPath(), string5).exists())) {
                string4 = MachineInfo.getJavaHome();
            }
        } else {
            File file2 = new File(string4);
            if (!file2.isAbsolute()) {
                string4 = new File(this.mitiHomeDir, string4).getPath();
            }
        }
        this.properties.put(JAVA_HOME, string4);
        this.javaExe = string4 + File.separator + string5;
        if (!this.properties.containsKey(JAVA_OPTIONS)) {
            this.properties.put(JAVA_OPTIONS, "");
        }
        if (!this.properties.containsKey(CONVERSATION_DIRECTORY)) {
            this.properties.put(CONVERSATION_DIRECTORY, "");
        }
        if (!this.properties.containsKey(LOG_LEVEL)) {
            this.properties.put(LOG_LEVEL, "");
        }
    }

    public String getBrowsePath() {
        return this.properties.get(BROWSE_PATH);
    }

    public String getJavaHome() {
        return this.properties.get(JAVA_HOME);
    }

    public String getJavaExecutable() {
        return this.javaExe;
    }

    public String getJavaOptions() {
        return this.properties.get(JAVA_OPTIONS);
    }

    public String getXmlVersion() {
        return this.properties.get(XML_VERSION);
    }

    public String getModelBridgeXmlConversationDirectory() {
        return this.properties.get(CONVERSATION_DIRECTORY);
    }

    public String getLogLevel() {
        return this.properties.get(LOG_LEVEL);
    }

    public File getHomeDirectory() {
        return this.mitiHomeDir;
    }

    public File getDataDirectory() {
        return this.mitiDataDir;
    }

    public File getDownloadDirectory() {
        return this.mitiDownloadDir;
    }

    public File getScriptDir() {
        return this.mitiScriptDir;
    }
}

