/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.cmd;

import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.TypedOption;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public abstract class CommandLineParser {
    public static void process(String[] stringArray, int n, CommandLineOption[] commandLineOptionArray) {
        LinkedHashSet<CommandLineOption> linkedHashSet = new LinkedHashSet<CommandLineOption>();
        for (int i = n; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CommandLineOption commandLineOption = CommandLineParser.get(commandLineOptionArray, string);
            if (commandLineOption == null) {
                throw new IllegalArgumentException("Unsupported option: " + string);
            }
            if (!commandLineOption.canRepeat() && linkedHashSet.contains(commandLineOption)) {
                throw new IllegalArgumentException("Option \"" + commandLineOption.getDisplayKeys() + "\" was already defined.");
            }
            linkedHashSet.add(commandLineOption);
            i += commandLineOption.processOption(string, stringArray, i + 1);
            if (!commandLineOption.isHelpOption()) continue;
            return;
        }
        for (CommandLineOption commandLineOption : commandLineOptionArray) {
            if (!commandLineOption.isMandatory() || linkedHashSet.contains(commandLineOption)) continue;
            throw new IllegalArgumentException("Missing mandatory option: " + commandLineOption.getDisplayKeys());
        }
    }

    public static CommandLineOption get(CommandLineOption[] commandLineOptionArray, String string) {
        for (CommandLineOption commandLineOption : commandLineOptionArray) {
            if (!commandLineOption.isSupportedKey(string)) continue;
            return commandLineOption;
        }
        return null;
    }

    public static void printUsage(CommandLineOption[] commandLineOptionArray, PrintStream printStream) {
        int n = 0;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (CommandLineOption commandLineOption : commandLineOptionArray) {
            if (commandLineOption.isHiddenOption()) continue;
            String string = commandLineOption.getDisplayKeys();
            if (commandLineOption instanceof TypedOption) {
                string = string + " <" + ((TypedOption)commandLineOption).type.toString() + ">";
            }
            if (string.length() > n) {
                n = string.length();
            }
            arrayList.add(new String[]{string, commandLineOption.getDescription()});
        }
        String string = "%-" + String.valueOf(n) + "s %s";
        for (String[] stringArray : arrayList) {
            printStream.printf(string, stringArray[0], stringArray[1]).println();
        }
    }
}

