/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    private int major = 0;
    private int minor = 0;
    private int release = 0;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?");

    public VersionNumber(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.release = n3;
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        return this.compare(versionNumber, true);
    }

    public int compare(VersionNumber versionNumber, boolean bl) {
        if (this.major > versionNumber.major) {
            return 1;
        }
        if (this.major < versionNumber.major) {
            return -1;
        }
        if (this.minor > versionNumber.minor) {
            return 1;
        }
        if (this.minor < versionNumber.minor) {
            return -1;
        }
        if (bl) {
            if (this.release > versionNumber.release) {
                return 1;
            }
            if (this.release < versionNumber.release) {
                return -1;
            }
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRelease() {
        return this.release;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + String.valueOf(this.minor) + "." + String.valueOf(this.release);
    }

    public boolean equals(Object object) {
        if (object instanceof VersionNumber) {
            VersionNumber versionNumber = (VersionNumber)object;
            return this.major == versionNumber.major && this.minor == versionNumber.minor && this.release == versionNumber.release;
        }
        return false;
    }

    public int hashCode() {
        return (this.major * 100 + this.minor) * 100 + this.release;
    }

    public static VersionNumber parse(String string) {
        Matcher matcher;
        if (string != null && !string.isEmpty() && (matcher = VERSION_PATTERN.matcher(string)).find()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = 0;
            int n3 = 0;
            if (matcher.group(2) != null) {
                n2 = Integer.parseInt(matcher.group(2));
                if (matcher.group(3) != null) {
                    n3 = Integer.parseInt(matcher.group(3));
                }
            }
            return new VersionNumber(n, n2, n3);
        }
        return null;
    }
}

