/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.util.ArrayList;

public class EscapedStringTokenizer {
    public static final char DEFAULT_DELIMITER_CHAR = ';';
    public static final char DEFAULT_ESCAPE_CHAR = '\\';
    private String list;
    private char delim;
    private char esc;
    private int currPosition = 0;

    public EscapedStringTokenizer() {
        this(';', '\\');
    }

    public EscapedStringTokenizer(String string) {
        this(string, ';', '\\');
    }

    public EscapedStringTokenizer(char c, char c2) {
        this("", c, c2);
    }

    public EscapedStringTokenizer(String string, char c, char c2) {
        this.list = string;
        this.delim = c;
        this.esc = c2;
    }

    public String[] getAllTokens() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        while ((string = this.getNextToken()) != null) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getNextToken() {
        int n;
        if (this.currPosition < 0 || this.currPosition >= this.list.length()) {
            this.currPosition = -1;
            return null;
        }
        for (n = this.currPosition; n < this.list.length(); ++n) {
            char c = this.list.charAt(n);
            if (c == this.esc) {
                if (++n < this.list.length()) continue;
                n = this.list.length();
                break;
            }
            if (c == this.delim) break;
        }
        String string = EscapedStringTokenizer.unescapeChar(this.list.substring(this.currPosition, n), this.delim, this.esc);
        this.currPosition = n >= this.list.length() ? -1 : n + 1;
        return string;
    }

    public void addLastToken(String string) {
        if (this.list.length() > 0) {
            this.list = this.list + this.delim;
        }
        this.list = this.list + string;
    }

    public static String escapeChar(String string) {
        return EscapedStringTokenizer.escapeChar(string, ';', '\\');
    }

    public static String escapeChar(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.1));
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == c2) {
                stringBuffer.append(c2).append(c2);
                continue;
            }
            if (c3 == c) {
                stringBuffer.append(c2).append(c);
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static String unescapeChar(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == c2 && i < string.length() - 1) {
                c3 = string.charAt(++i);
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public int getCurrentPosition() {
        return this.currPosition;
    }
}

