/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final TimeZone LOCALE = TimeZone.getDefault();
    private static final DateTimeFormatter SIMPLE_LOCALE = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(LOCALE.toZoneId());
    private static final DateTimeFormatter SIMPLE_UTC = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(UTC.toZoneId());
    private static final DateTimeFormatter ISO_LOCALE = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'G'").withZone(LOCALE.toZoneId());
    private static final DateTimeFormatter ISO_LOCALE_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'G'").withZone(LOCALE.toZoneId());
    private static final DateTimeFormatter ISO_UTC = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(UTC.toZoneId());
    private static final DateTimeFormatter ISO_UTC_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(UTC.toZoneId());

    public static TimeZone getUtcTimeZone() {
        return UTC;
    }

    public static Calendar getUtcCalendar() {
        return Calendar.getInstance(UTC);
    }

    public static SimpleDateFormat getIsoUtcFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(UTC);
        return simpleDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String formatDate(long l, SimpleDateFormat simpleDateFormat) {
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(new Date(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Date parseDate(String string, SimpleDateFormat simpleDateFormat) {
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    public static String formatDate(long l, String string, boolean bl) {
        return DateUtil.formatDate(l, DateTimeFormatter.ofPattern(string).withZone((bl ? UTC : LOCALE).toZoneId()));
    }

    public static String formatSimpleDate(long l, boolean bl) {
        return DateUtil.formatDate(l, bl ? SIMPLE_UTC : SIMPLE_LOCALE);
    }

    public static String formatLocaleDate(long l) {
        return DateUtil.formatDate(l, ISO_LOCALE);
    }

    public static String formatLocaleDate(long l, boolean bl) {
        return DateUtil.formatDate(l, bl ? ISO_LOCALE_MILLIS : ISO_LOCALE);
    }

    public static String formatUtcDate(long l) {
        return DateUtil.formatDate(l, ISO_UTC);
    }

    public static String formatUtcDate(long l, boolean bl) {
        return DateUtil.formatDate(l, bl ? ISO_UTC_MILLIS : ISO_UTC);
    }

    private static String formatDate(long l, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.format(Instant.ofEpochMilli(l));
    }

    public static Date parseDate(String string, String string2, boolean bl) {
        return DateUtil.parseDate(string, DateTimeFormatter.ofPattern(string2).withZone((bl ? UTC : LOCALE).toZoneId()));
    }

    public static Date parseSimpleDate(String string, boolean bl) {
        return DateUtil.parseDate(string, bl ? SIMPLE_UTC : SIMPLE_LOCALE);
    }

    public static Date parseLocaleDate(String string) {
        return DateUtil.parseDate(string, string.length() > 20 ? ISO_LOCALE_MILLIS : ISO_LOCALE);
    }

    public static Date parseUtcDate(String string) {
        return DateUtil.parseDate(string, string.length() > 20 ? ISO_UTC_MILLIS : ISO_UTC);
    }

    public static Date parseIso8601Date(String string) {
        TemporalAccessor temporalAccessor = null;
        try {
            temporalAccessor = DateTimeFormatter.ISO_DATE_TIME.parseBest(string, ZonedDateTime::from, LocalDateTime::from);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)temporalAccessor).toInstant());
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)temporalAccessor).toInstant(ZoneOffset.of("Z")));
        }
        return new Date(0L);
    }

    private static Date parseDate(String string, DateTimeFormatter dateTimeFormatter) {
        try {
            return Date.from(ZonedDateTime.parse(string, dateTimeFormatter).toInstant());
        }
        catch (DateTimeParseException dateTimeParseException) {
            return new Date(0L);
        }
    }

    public static String getDate(String string) {
        return string.length() > 10 ? string.substring(0, 10) : string;
    }

    public static String getTime(String string) {
        int n = string.length();
        if (n > 11) {
            return n > 19 ? string.substring(11, 19) : string.substring(11);
        }
        return string;
    }
}

