/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionUtil {
    public static <T> T first(Collection<T> collection) {
        if (collection != null && !collection.isEmpty()) {
            if (collection instanceof List) {
                return (T)((List)collection).get(0);
            }
            if (collection instanceof SortedSet) {
                return (T)((SortedSet)collection).first();
            }
            return collection.iterator().next();
        }
        return null;
    }

    public static <T> T last(Collection<T> collection) {
        if (collection != null && !collection.isEmpty()) {
            if (collection instanceof List) {
                return (T)((List)collection).get(collection.size() - 1);
            }
            if (collection instanceof SortedSet) {
                return (T)((SortedSet)collection).last();
            }
            T t2 = null;
            for (T t2 : collection) {
            }
            return t2;
        }
        return null;
    }

    public static int[] toArray(Collection<Integer> collection) {
        int[] nArray = null;
        if (collection != null) {
            nArray = new int[collection.size()];
            int n = 0;
            for (Integer n2 : collection) {
                nArray[n++] = n2 != null ? n2 : 0;
            }
        }
        return nArray;
    }

    public static <T> List<T> listOf(T[] TArray) {
        if (TArray != null) {
            return Arrays.asList(TArray);
        }
        return null;
    }

    public static Set<Integer> setOf(int[] nArray) {
        TreeSet<Integer> treeSet = null;
        if (nArray != null) {
            treeSet = new TreeSet<Integer>();
            for (int n : nArray) {
                treeSet.add(n);
            }
        }
        return treeSet;
    }

    public static <T extends Comparable<?>> Set<T> setOf(T ... TArray) {
        TreeSet<T> treeSet = null;
        if (TArray != null) {
            treeSet = new TreeSet<T>();
            for (T t : TArray) {
                treeSet.add(t);
            }
        }
        return treeSet;
    }

    public static <T extends Comparable<?>> Set<T> setOf(Collection<T> collection) {
        TreeSet<T> treeSet = null;
        if (collection != null) {
            treeSet = collection instanceof Set ? (TreeSet<T>)collection : new TreeSet<T>(collection);
        }
        return treeSet;
    }
}

