/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.springframework.config;

import com.sas.svcs.authorization.client.AuthorizationServicePermissionEvaluator;
import com.sas.svcs.authorization.client.CapabilityVoter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.intercept.AfterInvocationProviderManager;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityMetadataSourceAdvisor;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAdviceProvider;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdviceVoter;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MethodSecurityBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Logger logger = LogManager.getLogger(MethodSecurityBeanDefinitionParser.class);
    static final String PERMISSION_EVALUATOR_ID = "sas.svcs.security.permissionEvaluator";
    static final String EXPRESSION_HANDLER_ID = "sas.svcs.security.expressionHandler";
    static final String SERVICE_ACCESS_DECISION_MANAGER_ID = "sas.svcs.security.serviceAccessDecisionManager";
    static final String AUTHORIZATION_SERVICE_ID = "authorizationService";
    static final String CAPABILITY_RESOLVER_ID = "sas.svcs.capabilityResolver";
    static final String CAPABILITY_HELPER_ID = "sas.svcs.capabilityHelperBean";
    static final String ATT_AUTH_SERVICE = "authorization-service-ref";

    private static void registerPermissionEvaluator(BeanDefinitionRegistry registry, String authorizationServiceId) {
        if (!registry.containsBeanDefinition(PERMISSION_EVALUATOR_ID)) {
            if (logger.isInfoEnabled()) {
                logger.info("Creating new sas.svcs.security.permissionEvaluator bean");
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationServicePermissionEvaluator.class);
            if (!StringUtils.hasText((String)authorizationServiceId)) {
                authorizationServiceId = AUTHORIZATION_SERVICE_ID;
            }
            builder.addPropertyReference(AUTHORIZATION_SERVICE_ID, authorizationServiceId);
            registry.registerBeanDefinition(PERMISSION_EVALUATOR_ID, (BeanDefinition)builder.getBeanDefinition());
        } else if (logger.isInfoEnabled()) {
            logger.info("Using pre-defined sas.svcs.security.permissionEvaluator bean");
        }
    }

    private static void registerExpressionHandler(BeanDefinitionRegistry registry, CapabilityInfo capabilityInfo) {
        if (!registry.containsBeanDefinition(EXPRESSION_HANDLER_ID)) {
            if (logger.isInfoEnabled()) {
                logger.info("Creating new sas.svcs.security.expressionHandler bean");
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(DefaultMethodSecurityExpressionHandler.class);
            builder.addPropertyReference("permissionEvaluator", PERMISSION_EVALUATOR_ID);
            if (capabilityInfo.enabled) {
                builder.addPropertyReference("roleHierarchy", CAPABILITY_RESOLVER_ID);
                BeanDefinitionBuilder capabilityHelperBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)"com.sas.svcs.authorization.helper.CapabilityHelperBean");
                capabilityHelperBuilder.addConstructorArgReference(CAPABILITY_RESOLVER_ID);
                registry.registerBeanDefinition(CAPABILITY_HELPER_ID, (BeanDefinition)capabilityHelperBuilder.getBeanDefinition());
            }
            registry.registerBeanDefinition(EXPRESSION_HANDLER_ID, (BeanDefinition)builder.getBeanDefinition());
        } else if (logger.isInfoEnabled()) {
            logger.info("Using pre-defined sas.svcs.security.expressionHandler bean");
        }
    }

    private static CapabilityInfo getCapabilityInfo(Element element) {
        CapabilityInfo info = new CapabilityInfo();
        Element capabilities = DomUtils.getChildElementByTagName((Element)element, (String)"support-capabilities");
        if (null != capabilities) {
            info.enabled = true;
            info.userSessionFactory = capabilities.getAttribute("user-session-factory-ref");
        }
        return info;
    }

    private static void registerServiceAccessDecisionManager(BeanDefinitionRegistry registry, CapabilityInfo capabilityInfo) {
        if (!registry.containsBeanDefinition(SERVICE_ACCESS_DECISION_MANAGER_ID)) {
            if (logger.isInfoEnabled()) {
                logger.info("Creating new sas.svcs.security.serviceAccessDecisionManager bean");
            }
            BeanDefinitionBuilder decisionManager = BeanDefinitionBuilder.rootBeanDefinition(AffirmativeBased.class);
            BeanDefinitionBuilder voters = BeanDefinitionBuilder.rootBeanDefinition(ListFactoryBean.class);
            ManagedList voterItems = new ManagedList(3);
            voterItems.add(BeanDefinitionBuilder.rootBeanDefinition(RoleVoter.class).getBeanDefinition());
            voterItems.add(BeanDefinitionBuilder.rootBeanDefinition(AuthenticatedVoter.class).getBeanDefinition());
            if (capabilityInfo.enabled) {
                BeanDefinitionBuilder capabilityResolverBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)"com.sas.svcs.authorization.helper.OMRCapabilityResolver");
                if (null != capabilityInfo.userSessionFactory) {
                    capabilityResolverBuilder.addConstructorArgReference(capabilityInfo.userSessionFactory);
                } else {
                    capabilityResolverBuilder.setAutowireMode(3);
                }
                registry.registerBeanDefinition(CAPABILITY_RESOLVER_ID, (BeanDefinition)capabilityResolverBuilder.getBeanDefinition());
                BeanDefinitionBuilder capabilityVoterBuilder = BeanDefinitionBuilder.rootBeanDefinition(CapabilityVoter.class);
                capabilityVoterBuilder.addConstructorArgReference(CAPABILITY_RESOLVER_ID);
                voterItems.add(capabilityVoterBuilder.getBeanDefinition());
            }
            BeanDefinitionBuilder adviceVoterBuilder = BeanDefinitionBuilder.rootBeanDefinition(PreInvocationAuthorizationAdviceVoter.class);
            BeanDefinitionBuilder expressionAdviceBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedPreInvocationAdvice.class);
            expressionAdviceBuilder.addPropertyReference("expressionHandler", EXPRESSION_HANDLER_ID);
            adviceVoterBuilder.addConstructorArgValue((Object)expressionAdviceBuilder.getBeanDefinition());
            voterItems.add(adviceVoterBuilder.getBeanDefinition());
            voters.addPropertyValue("innerBeans", (Object)voterItems);
            decisionManager.addConstructorArgValue((Object)voterItems);
            registry.registerBeanDefinition(SERVICE_ACCESS_DECISION_MANAGER_ID, (BeanDefinition)decisionManager.getBeanDefinition());
        } else if (logger.isInfoEnabled()) {
            logger.info("Using pre-defined sas.svcs.security.serviceAccessDecisionManager bean");
        }
    }

    private static BeanReference registerDelegatingMethodSecurityMetadataSource(ParserContext pc, ManagedList<BeanMetadataElement> delegates, Object source) {
        RootBeanDefinition delegatingMethodSecurityMetadataSource = new RootBeanDefinition(DelegatingMethodSecurityMetadataSource.class);
        delegatingMethodSecurityMetadataSource.setSource(source);
        delegatingMethodSecurityMetadataSource.getConstructorArgumentValues().addGenericArgumentValue(delegates);
        String id = pc.getReaderContext().registerWithGeneratedName((BeanDefinition)delegatingMethodSecurityMetadataSource);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)delegatingMethodSecurityMetadataSource, id));
        return new RuntimeBeanReference(id);
    }

    private static void registerGlobalMethodSecurity(ParserContext pc, Object source, Element element) {
        ManagedList delegates = new ManagedList();
        ManagedList afterInvocationProviders = new ManagedList();
        BeanDefinitionBuilder afterInvocationBldr = BeanDefinitionBuilder.rootBeanDefinition(PostInvocationAdviceProvider.class);
        BeanDefinitionBuilder mds = BeanDefinitionBuilder.rootBeanDefinition(PrePostAnnotationSecurityMetadataSource.class);
        BeanDefinitionBuilder expressionPreAdviceBldr = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedPreInvocationAdvice.class);
        expressionPreAdviceBldr.addPropertyReference("expressionHandler", EXPRESSION_HANDLER_ID);
        BeanDefinitionBuilder expressionPostAdviceBldr = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedPostInvocationAdvice.class);
        expressionPostAdviceBldr.addConstructorArgReference(EXPRESSION_HANDLER_ID);
        afterInvocationBldr.addConstructorArgValue((Object)expressionPostAdviceBldr.getBeanDefinition());
        BeanDefinitionBuilder annotationInvocationFactory = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedAnnotationAttributeFactory.class);
        annotationInvocationFactory.addConstructorArgReference(EXPRESSION_HANDLER_ID);
        mds.addConstructorArgValue((Object)annotationInvocationFactory.getBeanDefinition());
        afterInvocationProviders.add((Object)afterInvocationBldr.getBeanDefinition());
        delegates.add((Object)mds.getBeanDefinition());
        BeanReference metadataSource = MethodSecurityBeanDefinitionParser.registerDelegatingMethodSecurityMetadataSource(pc, (ManagedList<BeanMetadataElement>)delegates, source);
        BeanReference interceptor = MethodSecurityBeanDefinitionParser.registerMethodSecurityInterceptor(pc, SERVICE_ACCESS_DECISION_MANAGER_ID, null, metadataSource, (List<BeanMetadataElement>)afterInvocationProviders, source);
        MethodSecurityBeanDefinitionParser.registerAdvisor(pc, interceptor, metadataSource, source, null);
    }

    private static BeanReference registerMethodSecurityInterceptor(ParserContext pc, String accessManagerId, String runAsManagerId, BeanReference metadataSource, List<BeanMetadataElement> afterInvocationProviders, Object source) {
        BeanDefinitionBuilder bldr = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityInterceptor.class);
        bldr.getRawBeanDefinition().setSource(source);
        bldr.addPropertyReference("accessDecisionManager", accessManagerId);
        bldr.addPropertyValue("authenticationManager", (Object)new RootBeanDefinition(AuthenticationManagerDelegator.class));
        bldr.addPropertyValue("securityMetadataSource", (Object)metadataSource);
        if (StringUtils.hasText((String)runAsManagerId)) {
            bldr.addPropertyReference("runAsManager", runAsManagerId);
        }
        if (!afterInvocationProviders.isEmpty()) {
            RootBeanDefinition afterInvocationManager = null;
            afterInvocationManager = new RootBeanDefinition(AfterInvocationProviderManager.class);
            afterInvocationManager.getPropertyValues().addPropertyValue("providers", afterInvocationProviders);
            bldr.addPropertyValue("afterInvocationManager", (Object)afterInvocationManager);
        }
        AbstractBeanDefinition bean = bldr.getBeanDefinition();
        String id = pc.getReaderContext().registerWithGeneratedName((BeanDefinition)bean);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bean, id));
        return new RuntimeBeanReference(id);
    }

    private static void registerAdvisor(ParserContext parserContext, BeanReference interceptor, BeanReference metadataSource, Object source, String adviceOrder) {
        if (parserContext.getRegistry().containsBeanDefinition("org.springframework.security.methodSecurityMetadataSourceAdvisor")) {
            parserContext.getReaderContext().error("Duplicate <global-method-security> detected.", source);
        }
        RootBeanDefinition advisor = new RootBeanDefinition(MethodSecurityMetadataSourceAdvisor.class);
        if (StringUtils.hasText((String)adviceOrder)) {
            advisor.getPropertyValues().addPropertyValue("order", (Object)adviceOrder);
        }
        advisor.setRole(2);
        advisor.setSource(source);
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)interceptor.getBeanName());
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)metadataSource);
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)metadataSource.getBeanName());
        parserContext.getRegistry().registerBeanDefinition("org.springframework.security.methodSecurityMetadataSourceAdvisor", (BeanDefinition)advisor);
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String authorizationServiceId = element.getAttribute(ATT_AUTH_SERVICE);
        CapabilityInfo capabilityInfo = MethodSecurityBeanDefinitionParser.getCapabilityInfo(element);
        MethodSecurityBeanDefinitionParser.registerPermissionEvaluator(registry, authorizationServiceId);
        MethodSecurityBeanDefinitionParser.registerExpressionHandler(registry, capabilityInfo);
        MethodSecurityBeanDefinitionParser.registerServiceAccessDecisionManager(registry, capabilityInfo);
        Object source = parserContext.extractSource((Object)element);
        MethodSecurityBeanDefinitionParser.registerGlobalMethodSecurity(parserContext, source, element);
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        return null;
    }

    private static final class CapabilityInfo {
        String userSessionFactory;
        boolean enabled;

        private CapabilityInfo() {
        }
    }

    static final class AuthenticationManagerDelegator
    implements AuthenticationManager,
    BeanFactoryAware {
        private AuthenticationManager delegate;
        private final Object delegateMonitor = new Object();
        private BeanFactory beanFactory;

        AuthenticationManagerDelegator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            Object object = this.delegateMonitor;
            synchronized (object) {
                if (this.delegate == null) {
                    Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to resolve org.springframework.security.authenticationManager");
                    try {
                        this.delegate = (AuthenticationManager)this.beanFactory.getBean("org.springframework.security.authenticationManager", ProviderManager.class);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        if ("org.springframework.security.authenticationManager".equals(e.getBeanName())) {
                            throw new NoSuchBeanDefinitionException("org.springframework.security.authenticationManager", "Did you forget to add a global <authentication-manager> element to your configuration (with child <authentication-provider> elements)? Alternatively you can use the authentication-manager-ref attribute on your <http> and <global-method-security> elements.");
                        }
                        throw e;
                    }
                }
            }
            return this.delegate.authenticate(authentication);
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

