/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.client;

import com.sas.svcs.authorization.client.CapabilityResolver;
import java.util.Collection;
import java.util.Set;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class CapabilityVoter
implements AccessDecisionVoter<Object> {
    public static final String DEFAULT_CAPABILITY_PREFIX = "PRIV_";
    private String prefix = "PRIV_";
    private CapabilityResolver capabilityResolver;

    public CapabilityVoter(CapabilityResolver capabilityResolver) {
        this.capabilityResolver = capabilityResolver;
    }

    public boolean supports(ConfigAttribute attribute) {
        return null != attribute.getAttribute() && attribute.getAttribute().startsWith(this.getPrefix());
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        int result = 0;
        Set<GrantedAuthority> capabilities = null;
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            result = -1;
            if (null == capabilities) {
                capabilities = this.capabilityResolver.getCurrentUserCapabilities();
            }
            for (GrantedAuthority authority : capabilities) {
                if (!attribute.getAttribute().equals(authority.getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

